//
//
//	NFF objects parser
//
//												(C) 1998 JoOl


#ifndef _PARSER_NFF_H_
#define _PARSER_NFF_H_


#include "LAPtextParser.h"
#include "LexerNff.h"
#include "PierrotParser.h"



class						ParserNff: public LAPtextParser, public PierrotParser
{
	enum
	{
		DEFAULT_CONE_PRECISION		= 16,
		DEFAULT_TORUS_PRECISION		= 16,
		DEFAULT_SPHERE_PRECISION	= 16
	};

	int32					conePrecision;
	int32					spherePrecision;
	int32					torusPrecision;


	virtual status_t		_Identify();
	virtual status_t		_Parse();
	virtual status_t		DoAbort();

	void					ParseColor(pSpectra& );
	void					ParsePoint(pPoint3& );
	void					ParseVector(pVector3& );

	void					ParseView();
	void					ParseBackground();
	void					ParseLight();
	void					ParseMaterial();
	void					ParseCone();
	void					ParseSphere();
	void					ParsePolygon(bool );
	//--
	void					ParseTorus();
	void					ParseRing();
	void					ParsePrism();

	pMaterial*				currentMaterial;
	pObject*				currentObject;

public:

							ParserNff(int32 );
	virtual					~ParserNff();
};


#if __POWERPC__
#pragma export on
#endif
extern "C" ParserNff*		instantiate_parser(int32 );
#if __POWERPC__
#pragma export reset
#endif


#endif	/* _PARSER_NFF_H_ */

