//
//
//	NFF-WTK objects parser
//
//												(C) 1998 JoOl


#include "ParserNffWtk.h"



#if __POWERPC__
#pragma export on
#endif
char			handlerName[]		= "Sense8's Neutral File Format v2.1 (.nff-wtk)";
char			handlerVersion[]	= "1.0.0";
char			handlerAuthor[]		= "Alain GAUTHEROT";
char			handlerEmail[]		= "gauthero@club-internet.fr";
#if __POWERPC__
#pragma export reset
#endif



ParserNffWtk*
instantiate_parser(int32 bs)
{
	return new ParserNffWtk(bs);
}


ParserNffWtk::ParserNffWtk(int32 blockSize)
: LAPtextParser()
{
	SetLexer(new LexerNffWtk(max_c(1024, blockSize), new LAPlexemeBuffer(128, true)));

	SetTo(new LAPtracer(128, LAP_BUFFER_OUTPUT_ON_OVERFLOW, LAP_BUFFER_SCREEN_OUTPUT),
			new LAPtextBufferedOutput(128, LAP_BUFFER_OUTPUT_ON_OVERFLOW, LAP_BUFFER_NO_OUTPUT/*LAP_BUFFER_SCREEN_OUTPUT*/),
			new LAPdisplay(),
			LAP_OWN_ERROR_OUTPUT | LAP_OWN_TRACE_OUTPUT | LAP_OWN_DISPLAY);
}


ParserNffWtk::~ParserNffWtk()
{
	if (data)
		delete (pScene* )data;
}


status_t
ParserNffWtk::DoAbort()
{
	PierrotParser::Reset();
	return LAP_NO_ERROR;
}


status_t
ParserNffWtk::_Identify()
{
	bool		silent = traceOutput->IsSilent();
	traceOutput->SetSilent(true);

	ParseHeader();

	traceOutput->SetSilent(silent);

	return LAP_NO_ERROR;
}


status_t
ParserNffWtk::_Parse()
{
	PierrotParser::Reset();

	scene = new pScene((char* )GetLexer()->GetInputName(),
						2, 2,					// lights
						16, 16,					// materials
						16, 16);				// objects

	ParseHeader();
	while (!Peek(LAP_TOKEN_EOF))
	{
		ParseObject();
	}

	pSphere				normSphere(pPoint3(0.0, 0.0, 0.0), 1.0);
	scene->Preprocess(&normSphere, appliInterface, 0.0, 1.0);

	scene->ambient.Set(0.5, 0.5, 0.5);
	if (scene->lights.CountItems() == 0)
	{
		pLight*			l1 = NewDirectionalLight("directional light 1", pVector3(-0.5, 0.5, 0.8));
		l1->ambient.Set(0.2, 0.2, 0.2);
		l1->diffuse.Set(1.0, 1.0, 1.0);
		l1->specular.Set(1.0, 1.0, 1.0);
	}

	Output(*traceOutput, scene, PRINT_LIGHT_ALL | PRINT_MATERIAL_ALL |
			PRINT_OBJECT_BOUNDS | PRINT_OBJECT_MATRIX | PRINT_OBJECT_POINTS);

	data = scene;
	scene = NULL;

	return LAP_NO_ERROR;
}


void
ParserNffWtk::ParsePoint(pPoint3& pt)
{
	ParseFloat(pt.x);
	ParseFloat(pt.y);
	ParseFloat(pt.z);
}


void
ParserNffWtk::ParseVector(pVector3& v)
{
	ParseFloat(v.x);
	ParseFloat(v.y);
	ParseFloat(v.z);
}


pMaterial*
ParserNffWtk::SearchMaterial(pSpectra& col)
{
	int32			matIndex = scene->materials.Search(col);
	if (matIndex >= 0)
		return scene->materials[matIndex];

	char				buf[32];
	sprintf(buf, "material %d", scene->materials.CountItems());
	pMaterial*			newMaterial = NewMaterial(buf);
	newMaterial->ambient.Set(0.1, 0.1, 0.1);
	newMaterial->diffuse.Set(col);
	newMaterial->specular.Set(0.5, 0.5, 0.5);
	newMaterial->shininess = 40.0;
	return newMaterial;
}



void
ParserNffWtk::ParseHeader()
{
	float				version = 0.0;
	pPoint3				viewPos;
	pVector3			viewDir;

	Match(Peek(TOKEN_NFF) ? TOKEN_NFF : TOKEN_S8);

		if (Peek(TOKEN_VERSION))
		{
			Match(TOKEN_VERSION);
			LexFloat(version);
		}

		if (Peek(TOKEN_VIEWPOS))
		{
			Match(TOKEN_VIEWPOS);
			ParsePoint(viewPos);
		}

		if (Peek(TOKEN_VIEWDIR))
		{
			Match(TOKEN_VIEWDIR);
			ParseVector(viewDir);
		}
/*
	*traceOutput << "nff version " << version << eol;
	*traceOutput << adv;
		*traceOutput << "from ";			Output(*traceOutput, viewPos);
		*traceOutput << eol << "towards ";	Output(*traceOutput, viewDir);
	*traceOutput << eol << ret;
*/
}


void
ParserNffWtk::ParseObject()
{
	char*				objectName = LexIdentifier();
	int32				nbVert;
	int32				nbFaces;

	pObject*			object = NewObject(objectName);
//	*traceOutput << "object " << objectName << eol << adv;

	LexInt(nbVert);
	object->vertices->SetAlloc(nbVert, 0);
//	*traceOutput << nbVert << " vertices" << adv << eol;
	for (int32 i = 0; i < nbVert; i++)
	{
		pPoint3					pt;
		ParsePoint(pt);
		SkipLine();
/*
		pVector3				norm;
		float					u, v;
		char*					hexColor = NULL;
		uint32					col24;
		if (Peek(TOKEN_NORM))
		{
			Match(TOKEN_NORM);
			ParseVector(norm);
		}

		if (Peek(TOKEN_RGB))
		{
			Match(TOKEN_RGB);
			SkipSpaces();
			hexColor = LexWord();
			sscanf("%x", hexColor, &col24);
			delete[] hexColor;
		}

		if (Peek(TOKEN_UV))
		{
			Match(TOKEN_UV);
			ParseFloat(u);
			ParseFloat(v);
		}
*/
		object->vertices->AddItem(pt);

//		Output(*traceOutput, pt);
//		*traceOutput << eol;
	}


	LexInt(nbFaces);
	object->faces.SetAlloc(nbFaces, 0);
//	*traceOutput << ret << nbFaces << " faces" << adv << eol;
	for (int32 i = 0; i < nbFaces; i++)
	{
		LexInt(nbVert);
//		*traceOutput << nbVert;

		int32					index;
		PierrotArray<int32 >	indexes(nbVert, 1);
		for (int32 j = 0; j < nbVert; j++)
		{
			LexInt(index);
			indexes.AddItem(index);
//			*traceOutput << ' ' << index;
		}

		int32				dummy;
		LexInt(dummy);
		char*				hexColor = LexWord();
		SkipLine();			// the rest is skipped...

		int32				col = 0;
		pSpectra			spec;
		sscanf(hexColor, "%x", &col);
		if (strlen(hexColor) == 3+2)
			spec.Set(	float((col >> 8) & 0xf) / 16.0,
						float((col >> 4) & 0xf) / 16.0,
						float((col)      & 0xf) / 16.0);
		else
			spec.Set(	float((col >> 16) & 0xff) / 255.0,
						float((col >> 8)  & 0xff) / 255.0,
						float((col)       & 0xff) / 255.0);
		delete[] hexColor;

//		Output(*traceOutput, spec);
//		*traceOutput << eol;

		object->faces.AddItem(new pFace(SearchMaterial(spec), nbVert, indexes.Items()));
	}
	delete[] objectName;

	*traceOutput << ret << ret;
}
