//
//
//	OBJ objects parser
//
//											(C) 1997 JoOl


#include "ParserObj.h"
#include "TokensObj.h"


#if __POWERPC__
#pragma export on
#endif
char			handlerName[]		= "Wavefront v3.0 (.obj)";
char			handlerVersion[]	= "1.0.0";
char			handlerAuthor[]		= "Alain GAUTHEROT";
char			handlerEmail[]		= "gauthero@club-internet.fr";
#if __POWERPC__
#pragma export reset
#endif



ParserObj*
instantiate_parser(int32 bs)
{
	return new ParserObj(bs);
}


ParserObj::ParserObj(int32 blockSize)
: LAPtextParser()
{
	SetLexer(new LexerObj(max_c(1024, blockSize), new LAPlexemeBuffer(128, true)));

	SetTo(new LAPtracer(128, LAP_BUFFER_OUTPUT_ON_OVERFLOW, LAP_BUFFER_SCREEN_OUTPUT),
			new LAPtextBufferedOutput(128, LAP_BUFFER_OUTPUT_ON_OVERFLOW, LAP_BUFFER_NO_OUTPUT/*LAP_BUFFER_SCREEN_OUTPUT*/),
			new LAPdisplay(),
			LAP_OWN_ERROR_OUTPUT | LAP_OWN_TRACE_OUTPUT | LAP_OWN_DISPLAY);
}


ParserObj::~ParserObj()
{
//	lexer deleted in parent classes
//	so are the error output, the tracer and the display (cf. SetTo call)

	if (data)
		delete (pScene* )data;
}


status_t
ParserObj::DoAbort()
{
	PierrotParser::Reset();
	return LAP_NO_ERROR;
}


status_t
ParserObj::_Identify()
{
	bool		silent = traceOutput->IsSilent();
	traceOutput->SetSilent(true);

	bool		error = false;
	int32		i = 20;
	while (!Peek(LAP_TOKEN_EOF) && (i-- > 0) && (!error))
	{
		if (!ParseSwitch(true))
			error = true;
	}

	traceOutput->SetSilent(silent);

	if (Peek(LAP_TOKEN_EOF) || error)
		return LAP_BAD_INPUT_TYPE;

	return LAP_NO_ERROR;
}


status_t
ParserObj::_Parse()
{
	PierrotParser::Reset();

	scene = new pScene((char* )GetLexer()->GetInputName(),
						2, 2,					// lights
						16, 16,					// materials
						16, 16);				// objects

	currentGroup = NewObject("default", POLY_VERTICES_ALLOC,
										POLY_VERTICES_BLOCK,
										0,
										POLY_FACES_BLOCK);


	// create default material
	currentMaterial = NewMaterial("default material");
	currentMaterial->ambient.Set(0.1, 0.1, 0.1);
	currentMaterial->diffuse.Set(0.4, 0.5, 0.6);
	currentMaterial->specular.Set(0.4, 0.4, 0.4);
	currentMaterial->shininess = 40.0;

	while (!Peek(LAP_TOKEN_EOF))
	{
		Lock();
			ParseSwitch(false);
		Unlock();
	}

	pSphere				normSphere(pPoint3(0.0, 0.0, 0.0), 1.0);
	scene->Preprocess(&normSphere, appliInterface, 0.0, 1.0);

	scene->ambient.Set(0.5, 0.5, 0.5);
	if (scene->lights.CountItems() == 0)
	{
		pLight*			l1 = NewDirectionalLight("directional light 1", pVector3(-0.5, 0.5, 0.8));
		l1->ambient.Set(0.2, 0.2, 0.2);
		l1->diffuse.Set(1.0, 1.0, 1.0);
		l1->specular.Set(1.0, 1.0, 1.0);
	}

	Output(*traceOutput, scene, PRINT_LIGHT_ALL | PRINT_MATERIAL_ALL |
			PRINT_OBJECT_BOUNDS | PRINT_OBJECT_MATRIX | PRINT_OBJECT_POINTS);

	data = scene;
	scene = NULL;
	return LAP_NO_ERROR;
}


//--------------------------------------------------------
// misc. methods
//--------------------------------------------------------

void
ParserObj::ParseVector1or2or3(float& x, float& y, float& z)
{
	ParseFloat(x);
	if (Peek(LAP_TOKEN_NUMBER))
		ParseFloat(y);
	else
		y = 0.0;
	if (Peek(LAP_TOKEN_NUMBER))
		ParseFloat(z);
	else
		z = 0.0;
}


void
ParserObj::ParseVector3(float& x, float& y, float& z)
{
	ParseFloat(x);
	ParseFloat(y);
	ParseFloat(z);
}


void
ParserObj::ParseVector3or4(float& x, float& y, float& z, float& w)
{
	ParseVector3(x, y, z);
	if (Peek(LAP_TOKEN_NUMBER))
		ParseFloat(w);
	else
		w = 1.0;
}


void
ParserObj::ParseTriplet(int32& v, int32& vt, int32& vn)
{
	LexInt(v);
	if (Peek(TOKEN_SLASH))
	{
		Match(TOKEN_SLASH);
		if (Peek(LAP_TOKEN_NUMBER))
			LexInt(vt);
		else
			vt = INT32_NO_VALUE;
		if (Peek(TOKEN_SLASH))
		{
			Match(TOKEN_SLASH);
			LexInt(vn);
		}
		else
			vn = INT32_NO_VALUE;
	}
	else
	{
		vt = vn = INT32_NO_VALUE;
	}
}


void
ParserObj::ParseVertex()
{
	pPoint3			pt;
	float			w;
	Match(TOKEN_V);
	ParseVector3or4(pt.x, pt.y, pt.z, w);

	currentGroup->vertices->AddItem(pt);

//	*traceOutput << "v " << pt.x << ' ' << pt.y << ' ' << pt.z << eol;
}

/*
void
ParserObj::ParseVtexture()
{
	float		x, y, z;

	Match(TOKEN_VTEXTURE);
	ParseVector1or2or3(x, y, z);
//	*traceOutput << "vt " << x << ' ' << y << ' ' << z << eol;
}


void
ParserObj::ParseVnormal()
{
	float		x, y, z;

	Match(TOKEN_VNORMAL);
	ParseVector3(x, y, z);
//	*traceOutput << "vn " << x << ' ' << y << ' ' << z << eol;
}


void
ParserObj::ParseVparam()
{
	float		x, y, z;

	Match(TOKEN_VPARAM);
	ParseVector1or2or3(x, y, z);
//	*traceOutput << "vp " << x << ' ' << y << ' ' << z << eol;
}
*/

//--------------------------------------------------------
//
//--------------------------------------------------------

bool
ParserObj::ParseSwitch(bool identification)
{
	switch (currentToken)
	{
		// vertex data
		case TOKEN_V:			(identification) ? SkipLine() : ParseVertex();		break;
		// elements data
		case TOKEN_FACE:		(identification) ? SkipLine() : ParseFace();		break;

		// grouping
		case TOKEN_GROUPNAME:	(identification) ? SkipLine() : ParseGroup();		break;
		// render attributes
		case TOKEN_USEMATERIAL:	(identification) ? SkipLine() : ParseUseMaterial();	break;

		case TOKEN_VTEXTURE:
		case TOKEN_VNORMAL:
		case TOKEN_SMOOTHGROUP:
		case TOKEN_MERGEGROUP:
		case TOKEN_OBJECTNAME:
		case TOKEN_MAPLIB:
		case TOKEN_USEMAP:
		case TOKEN_MATLIB:

		case TOKEN_VPARAM:
		case TOKEN_CSTYPE:
		case TOKEN_CTECH:
		case TOKEN_STECH:
		case TOKEN_DEGREE:
		case TOKEN_BMATU:
		case TOKEN_BMATV:
		case TOKEN_STEP:

		case TOKEN_POINT:
		case TOKEN_LINE:
		case TOKEN_CURVE:
		case TOKEN_CURVE2D:
		case TOKEN_SURFACE:

		// free-form curve/surface
		case TOKEN_PARAMU:
		case TOKEN_PARAMV:
		case TOKEN_TRIM:
		case TOKEN_HOLE:
		case TOKEN_SCURVE:
		case TOKEN_SPOINT:
		case TOKEN_ENDSTMT:
		// free-form surfaces connectivity
		case TOKEN_CONNECT:

		case TOKEN_BEVELINTERP:
		case TOKEN_CINTERP:
		case TOKEN_DINTERP:
		case TOKEN_SHADOW:
		case TOKEN_TRACE:
//printf("line %d: skip (%d %s %s)\n", lexer->GetLineNumber(), currentToken, lexer->GetLexeme(currentToken), lexer->GetStringLiteral());
			SkipLine();
			return true;

		default:
printf("line %d: unknown token (%d %s %s)\n", lexer->GetLineNumber(), currentToken, lexer->GetLexeme(currentToken), lexer->GetStringLiteral());
			SkipLine();
			return false;
	}

	return true;
}


//----------------------------------------
// Elements-related routines
//----------------------------------------

void
ParserObj::ParseFace()
{
	PierrotArray<int32>	indices(16, 8);

	Match(TOKEN_FACE);

	while (Peek(LAP_TOKEN_NUMBER))
	{
		int32			vert, txtr, norm;
		ParseTriplet(vert, txtr, norm);
		vert--;					// indices must start at zero!
		indices.AddItem(vert);
	}

	currentGroup->faces.AddItem(new pFace(currentMaterial, indices.CountItems(),
								indices.Items()));
/*
	for (int32 i = 0; i < indices.CountItems(); i++)
		*traceOutput << indices[i] << ' ';
	*traceOutput << eol;
*/
}


//----------------------------------------
// Grouping-related routines
//----------------------------------------

void
ParserObj::ParseGroup()
{
	char*		groupName;

	Match(TOKEN_GROUPNAME);

	int32		ln = lexer->GetLineNumber();
	SkipSpaces();
	if (lexer->GetLineNumber() != ln)
		groupName = strdup("default");
	else
	{
		groupName = LexWord();
		SkipLine();				// possible other group names are skipped!
	}

	int32			groupIndex = scene->objects.Search(groupName);
	if (groupIndex < 0)
	{
		groupIndex = scene->objects.CountItems();
		currentGroup = NewObject(groupName, scene->objects[0]->vertices, scene->objects[0]->normals);
		currentGroup->faces.SetAlloc(POLY_FACES_ALLOC, POLY_FACES_BLOCK);
//		*traceOutput << "created group " << currentGroup->name << eol;
	}
	else
		currentGroup = scene->objects[groupIndex];
//	currentMaterial = scene->materials[(groupIndex & 0x7) + 4];

//	*traceOutput << "group: " << currentGroup->name
//				<< ", " << currentMaterial->name << eol;
	delete[] groupName;
}

/*
void
ParserObj::ParseSmoothGroup()
{
	Match(TOKEN_SMOOTHGROUP);

	if (Peek(LAP_TOKEN_IDENTIFIER))
	{
		char*			off;
		off = LexIdentifier();
		if (!strcmp(off, "off"))
		{
			*traceOutput << "smooth group: off" << eol;
		}
		else
		{
			*traceOutput << "smooth group: '" << off << "' error?\n" << eol;
		}
		delete[] off;
		return ;
	}

	*traceOutput << "smooth group: ";
	while (Peek(LAP_TOKEN_NUMBER))
	{
		int32			groupIndex;
		LexInt(groupIndex);
		*traceOutput << groupIndex << ' ';
	}
	*traceOutput << eol;
}


void
ParserObj::ParseMergeGroup()
{
	int32			groupIndex;

	Match(TOKEN_MERGEGROUP);
	LexInt(groupIndex);
	*traceOutput << "merge group " << groupIndex;
	if (Peek(LAP_TOKEN_NUMBER))
	{
		float			reso;
		LexFloat(reso);
		*traceOutput << " reso " << reso << eol;
	}
	*traceOutput << eol;
}


void
ParserObj::ParseObjectName()
{
	char*			objName;
	Match(TOKEN_OBJECTNAME);

	SkipSpaces();
	objName = LexWord();
	*traceOutput << "object '" << objName << '\'' << eol;
	delete[] objName;
}
*/

//----------------------------------------
// Rendering attributes related routines
//----------------------------------------
/*
void
ParserObj::ParseMapLib()
{
	Match(TOKEN_MAPLIB);
	*traceOutput << "maplib: ";

	int32		Ln = lexer->GetLineNumber();
	SkipSpaces();
	while (lexer->GetLineNumber() == Ln)
	{
		char*		mapFile;
		mapFile = LexWord();
		*traceOutput << '\'' << mapFile << "' ";
		delete[] mapFile;
		SkipSpaces();
	}
	*traceOutput << eol;
}


void
ParserObj::ParseUseMap()
{
	char*			mapName;
	Match(TOKEN_USEMAP);
	SkipSpaces();
	mapName = LexWord();
	if (!strcmp(mapName, "off"))
	{
		*traceOutput << "usemap none" << eol;
	}
	else
	{
		*traceOutput << "usemap '" << mapName << '\'' << eol;
	}
	delete[] mapName;
}
*/

void
ParserObj::ParseUseMaterial()
{
	char*			matName;
	Match(TOKEN_USEMATERIAL);
	SkipSpaces();
	matName = LexWord();
//	*traceOutput << "use material '" << matName << '\'' << eol;

	int32			matIndex = scene->materials.Search(matName);
	if (matIndex < 0)
	{
		float			magic = float((scene->objects.CountItems() & 0x7) + 6) * 0.0625;
		currentMaterial = NewMaterial(matName);
		currentMaterial->SetAmbientAndDiffuse(pSpectra(magic*0.6, magic*0.7, magic));
/*
		currentMaterial = NewMaterial(matName);
		currentMaterial->ambient.Set(0.2, 0.2, 0.2);
		currentMaterial->diffuse.Set(0.4, 0.4, 0.5);
		currentMaterial->specular.Set(0.8, 0.8, 0.8);
		currentMaterial->shininess = 60.0;
*/	}
	else
		currentMaterial = scene->materials[matIndex];
	delete[] matName;
}

/*
void
ParserObj::ParseMaterialLib()
{
	Match(TOKEN_MATLIB);
	*traceOutput << "matlib: ";

	int32			ln = lexer->GetLineNumber();
	SkipSpaces();
	while (lexer->GetLineNumber() == ln)
	{
		char*		libName;
		libName = LexWord();
		*traceOutput << '\'' << libName << "' ";
		delete[] libName;
		SkipSpaces();
	}
	*traceOutput << eol;
}
*/
