//
//
//	LAP library lexer exceptions
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include <ctype.h>
#include "LAPlexerException.h"
#include "LAPerrors.h"



LAPlexerException::LAPlexerException(int32 w, const char* l)
: LAPexception(w, l)
{
}


LAPlexerException::LAPlexerException(LAPlexerException& e)
: LAPexception(e.what, e.where)
{
}


LAPlexerException::~LAPlexerException()
{
}


//-------------------------------------------------------------
//
//-------------------------------------------------------------

LAPillegalCharacter::LAPillegalCharacter(const char* location, char ic)
: LAPlexerException(LAP_ILLEGAL_CHARACTER, location)
{
	c = ic;
}


LAPillegalCharacter::LAPillegalCharacter(LAPillegalCharacter& e)
: LAPlexerException(e.what, e.where)
{
	c = e.c;
}


LAPillegalCharacter::~LAPillegalCharacter()
{
}


void
LAPillegalCharacter::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
	out << ": illegal character ";
	if (isprint(c))
		out << '\'' << c << '\'';
	else
		out << "ASCII " << int16(c);
	out << eol << flush;
/*
	printf(": illegal character ", c);
	if (isprint(c))
		printf(" '%c'\n", c);
	else
		printf(" ASCII %d\n", int16(c));
*/
}
