//
//
//	LAP library parser exceptions
//
//										(C) JoOl 1998


#ifndef _LAP_PARSER_EXCEPTION_H_
#define _LAP_PARSER_EXCEPTION_H_


#include "LAPexception.h"
#include "LAPliteral.h"
#include "LAPtoken.h"
#include "LAPtextBufferedOutput.h"


//-------------------------------------------------------------
//
//-------------------------------------------------------------

class					LAPparserException: public LAPexception
{
public:
//#if __POWERPC__
#pragma export on
//#endif

						LAPparserException(int32 , const char* );
						LAPparserException(LAPparserException& );
	virtual				~LAPparserException();

//#if __POWERPC__
#pragma export reset
//#endif
};


//-------------------------------------------------------------
//
//-------------------------------------------------------------

class					LAPmismatchToken: public LAPparserException
{
public:

//#if __POWERPC__
#pragma export on
//#endif

	LAPtoken			expectedToken;
	const char*			expectedLexeme;
	LAPtoken			actualToken;
	const char*			actualLexeme;
	LAPliteralType		type;
	LAPliteral			value;

						LAPmismatchToken(const char*, LAPtoken , const char* ,
										LAPtoken, const char* );
						LAPmismatchToken(const char*, LAPtoken , const char* ,
										LAPtoken, const char* , char );
						LAPmismatchToken(const char*, LAPtoken , const char* ,
										LAPtoken, const char* , int64& );
						LAPmismatchToken(const char*, LAPtoken , const char* ,
										LAPtoken, const char* , double& );
						LAPmismatchToken(const char*, LAPtoken , const char* ,
										LAPtoken, const char* , char* );
						LAPmismatchToken(LAPmismatchToken& );
	virtual				~LAPmismatchToken();

	virtual void		Output(LAPtextBufferedOutput& );

//#if __POWERPC__
#pragma export reset
//#endif
};


//-------------------------------------------------------------
//
//-------------------------------------------------------------

class					LAPloadAborted: public LAPparserException
{
public:

//#if __POWERPC__
#pragma export on
//#endif
	ssize_t				asked;
	ssize_t				limit;

						LAPloadAborted(const char* );
						LAPloadAborted(LAPloadAborted& );
	virtual				~LAPloadAborted();

	virtual void		Output(LAPtextBufferedOutput& );

//#if __POWERPC__
#pragma export reset
//#endif
};



//-------------------------------------------------------------
//
//-------------------------------------------------------------

class					LAPbadScope: public LAPparserException
{
public:

//#if __POWERPC__
#pragma export on
//#endif
						LAPbadScope(const char* );
						LAPbadScope(LAPbadScope& );
	virtual				~LAPbadScope();

	virtual void		Output(LAPtextBufferedOutput& );

//#if __POWERPC__
#pragma export reset
//#endif
};


//-------------------------------------------------------------
//
//-------------------------------------------------------------

class					LAPmismatchLength: public LAPparserException
{
public:

	off_t				expected;
	off_t				actual;

//#if __POWERPC__
#pragma export on
//#endif
						LAPmismatchLength(const char* , off_t , off_t );
						LAPmismatchLength(LAPmismatchLength& );
	virtual				~LAPmismatchLength();

	virtual void		Output(LAPtextBufferedOutput& );

//#if __POWERPC__
#pragma export reset
//#endif
};



#endif	/* _LAP_PARSER_EXCEPTION_H_ */
