//
//
//	LAP text parser class
//
//										(C) JoOl 1998


#ifndef _LAP_TEXT_PARSER_H_
#define _LAP_TEXT_PARSER_H_


#include "LAPtextLexer.h"
#include "LAPparser.h"
#include "LAPtokenSet.h"


class						LAPtextParser: public LAPparser
{
protected:

//#if __POWERPC__
#pragma export on
//#endif
	LAPtextLexer*			lexer;
	void					SetLexer(LAPtextLexer* );

	bool					peekFlag;
	LAPtoken				currentToken;
	void					NextToken();
	bool					Peek(LAPtoken );
	void					Match(LAPtoken );
	void					MatchNumber(LAPliteralType );
	void					GenerateMismatchToken(const char* , LAPtoken , const char* ,
													LAPtoken , const char* )
									throw (LAPmismatchToken);
	void					GenerateMismatchLiteral(const char* , LAPliteralType , LAPtoken )
									throw (LAPmismatchToken);

	bool					Synchronize(LAPtokenSet& );
	bool					Synchronize(LAPtokenSet& , LAPtokenSet& );
	bool					Synchronize(LAPtokenSet& , LAPtokenSet& , LAPtokenSet& );

	void					SkipSpaces(); // throw (LAPloadAborted);
	void					SkipLine(); // throw (LAPloadAborted);
	char*					LexWord(); // throw (LAPloadAborted);
	char*					LexIdentifier(); // throw (LAPloadAborted);

	void					LexInt(int32& ); // throw (LAPloadAborted);
	void					LexInt(int64& ); // throw (LAPloadAborted);
	void					ParseInt(int32& ); // throw (LAPloadAborted);
	void					ParseInt(int64& ); // throw (LAPloadAborted);

	void					LexFloat(float& ); // throw (LAPloadAborted);
	void					LexFloat(double& ); // throw (LAPloadAborted);
	void					ParseFloat(float& ); // throw (LAPloadAborted);
	void					ParseFloat(double& ); // throw (LAPloadAborted);


public:
							LAPtextParser();
	virtual					~LAPtextParser();

	virtual status_t		SetInput(entry_ref , uint8 );

//#if __POWERPC__
#pragma export reset
//#endif
};


#endif	/* _LAP_TEXT_PARSER_H_ */
