//
//
//	LAP binary lexer class
//
//										(C) JoOl 1998

#include "LAPimpexp.h"

#include "LAPbinLexer.h"
#include "LAPerrors.h"


LAPbinLexer::LAPbinLexer(int32 bufSize, LAPendianness e)
: LAPlexer(new LAPbinBufferedInput(bufSize, e))
{
	input = (LAPbinBufferedInput* )_input;
}


LAPbinLexer::LAPbinLexer(LAPbinBufferedInput* bbi)
: LAPlexer(bbi)
{
	input = (LAPbinBufferedInput* )_input;
}


LAPbinLexer::~LAPbinLexer()
{
}


LAPbinBufferedInput*
LAPbinLexer::GetInput() const
{
	return input;
}


status_t
LAPbinLexer::_SetInput(entry_ref /*ref*/)
{
	if (errorOutput && input)
		errorOutput->SetHeader(input->GetInputLeaf(), input);
	return LAP_NO_ERROR;
}


void				LAPbinLexer::ReadInt8(int8& out)
{
	*input >> out;
}


void				LAPbinLexer::ReadInt16(int16& out)
{
	*input >> out;
}


void				LAPbinLexer::ReadInt32(int32& out)
{
	*input >> out;
}


void				LAPbinLexer::ReadInt64(int64& out)
{
	*input >> out;
}


void				LAPbinLexer::ReadFloat(float& out)
{
	*input >> out;
}


void				LAPbinLexer::ReadDouble(double& out)
{
	*input >> out;
}


void				LAPbinLexer::ReadBytes(char* out, int32 n)
{
	input->Read(out, n);
}


void				LAPbinLexer::ReadString(char* out, int32 max)
{
	input->ReadString(out, max);
}


void				LAPbinLexer::SkipBytes(int32 n)
{
	input->SkipBytes(n);
}

