//
//
//	LAP lexeme table
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include "LAPlexemeTable.h"
#include "LAPerrors.h"


LAPlexemeTable::LAPlexemeTable()
: LAPtable(LAPlexemeCmpFunc)
{
}


LAPlexemeTable::~LAPlexemeTable()
{
	for (int32 i = 0; i < table.CountItems(); i++)
		delete (LAPlexeme* )table.ItemAt(i);
	table.MakeEmpty();
}


int32
LAPlexemeTable::LAPlexemeCmpFunc(void* e, char* n)
{
	return strcmp(((LAPlexeme* )e)->GetName(), n);
}


LAPlexeme*
LAPlexemeTable::Search(char* n)
{
	return (LAPlexeme* )LAPtable::Search(n);
}


status_t
LAPlexemeTable::Insert(LAPlexeme* l)
{
	if (!l)
		return LAP_BAD_VALUE;
	return LAPtable::Insert((char* )l->GetName(), l);
}

