//
//
//	Pierrot light
//
//										(C) JoOl 1998


#ifndef _PIERROT_LIGHT_H_
#define _PIERROT_LIGHT_H_


#include <SupportDefs.h>
#include "PierrotGeometry.h"
#include "PierrotColor.h"



//--------------------------------------------------------
// Light
//--------------------------------------------------------

class					pLight
{
public:

	enum
	{
		PLIGHT_OFF		= 0x01
	};

	char*				name;
	uint32				flags;
	pSpectra			ambient;
	pSpectra			diffuse;
	pSpectra			specular;
	float				constantAttenuation;
	float				linearAttenuation;
	float				quadraticAttenuation;

#pragma export on

						pLight(char* );
	virtual				~pLight();

	bool				IsOn() const;
	bool				IsOff() const;
	void				SetOn();
	void				SetOff();

	virtual bool		IsDirectional() const;
	virtual bool		IsPositional() const;
	bool				IsSpotlight() const;

	void				SetAmbientAndDiffuse(pSpectra& );
	void				SetAttenuation(float , float , float );
	void				SetDefaultLight();

	virtual void		MoveBy(pVector3& );
	virtual void		ScaleBy(float );

#pragma export reset
};



//--------------------------------------------------------
// Directional light
//--------------------------------------------------------

class					pDirectionalLight: public pLight
{
public:
	pVector3			direction;

#pragma export on
						pDirectionalLight(char* , pVector3& );
	virtual				~pDirectionalLight();

	virtual bool		IsDirectional() const;

#pragma export reset
};



//--------------------------------------------------------
// Positional light
//--------------------------------------------------------

class					pPositionalLight: public pLight
{
public:
	pPoint3				position;

#pragma export on
						pPositionalLight(char* , pPoint3& );
	virtual				~pPositionalLight();

	virtual bool		IsPositional() const;

	virtual void		MoveBy(pVector3& );
	virtual void		ScaleBy(float );

#pragma export reset
};



//--------------------------------------------------------
// Spotlight
//--------------------------------------------------------

class					pSpotlight: public pPositionalLight
{
public:
	pVector3			spotDirection;
	float				spotExponent;
	float				spotCutOff;

#pragma export on
						pSpotlight(char* , pPoint3& , pVector3& , float , float );
	virtual				~pSpotlight();

#pragma export reset
};


#endif /* _PIERROT_LIGHT_H_ */
