//
//
//	Pierrot materials array
//
//											(C) JoOl 1998


#ifndef _PIERROT_MATERIALS_ARRAY_H_
#define _PIERROT_MATERIALS_ARRAY_H_

#include <SupportDefs.h>
#include "PierrotPtrArray.h"
#include "PierrotMaterial.h"


//-----------------------------------------------
// materials arrays
//-----------------------------------------------

class						pMaterialsArray: public PierrotPtrArray<pMaterial* >
{
	static int				pMaterialCmpFunc(void* material, void* name)
	{ return strcmp(((pMaterial* )material)->name, (char* )name); };

	static int				pMaterialCmpFunc2(void* material, void* diffuse)
	{ return (((pMaterial* )material)->diffuse == *(pSpectra* )diffuse) ? 0 : 1; };

public:

	pMaterialsArray(int32 is, int32 bs)
	: PierrotPtrArray<pMaterial* >(is, bs)
	{};

	int32					Search(char* name)
	{
		return PierrotPtrArrayBase::Search(pMaterialCmpFunc, (void* )name);
	};

	int32					Search(pSpectra& diffuse)
	{
		return PierrotPtrArrayBase::Search(pMaterialCmpFunc2, (void* )&diffuse);
	};
};


#endif /* _PIERROT_MATERIALS_ARRAY_H_ */
