//
//
//	Pierrot 4d matrix
//
//										(C) JoOl 1998


#include "PierrotImpExp.h"

#include <math.h>
#include "PierrotMatrix4.h"
#include "PierrotMatrix.h"



//--------------------------------------------------------
// 4d matrix
//--------------------------------------------------------

pMatrix4::pMatrix4()
{}


pMatrix4::pMatrix4(pMatrix3& m)
{
	pVector3			v;
	v = m.GetX();
	mat[0].Set(v.x, v.y, v.z, 0.0);
	v = m.GetY();
	mat[1].Set(v.x, v.y, v.z, 0.0);
	v = m.GetZ();
	mat[2].Set(v.x, v.y, v.z, 0.0);
	mat[3].Set(0.0, 0.0, 0.0, 1.0);
}


pMatrix4::pMatrix4(pMatrix3& m, pVector3& t)
{
	pVector3			v;
	v = m.GetX();
	mat[0].Set(v.x, v.y, v.z, t.x);
	v = m.GetY();
	mat[1].Set(v.x, v.y, v.z, t.y);
	v = m.GetZ();
	mat[2].Set(v.x, v.y, v.z, t.z);
	mat[3].Set(0.0, 0.0, 0.0, 1.0);
}


pMatrix4::pMatrix4(pMatrix4& m)
{
	mat[0] = m.GetX();
	mat[1] = m.GetY();
	mat[2] = m.GetZ();
	mat[3] = m.GetW();
}


pMatrix4::pMatrix4(pVector4& v0, pVector4& v1, pVector4& v2, pVector4& v3)
{
	mat[0] = v0;
	mat[1] = v1;
	mat[2] = v2;
	mat[3] = v3;
}


pMatrix4::~pMatrix4()
{}


void
pMatrix4::SetX(pVector4& v)
{ mat[0] = v; }


void
pMatrix4::SetY(pVector4& v)
{ mat[1] = v; }


void
pMatrix4::SetZ(pVector4& v)
{ mat[2] = v; }


void
pMatrix4::SetW(pVector4& v)
{ mat[3] = v; }


void
pMatrix4::Set0(pVector4& v)
{
	mat[0].x = v.x;
	mat[1].x = v.y;
	mat[2].x = v.z;
	mat[3].x = v.w;
}


void
pMatrix4::Set1(pVector4& v)
{
	mat[0].y = v.x;
	mat[1].y = v.y;
	mat[2].y = v.z;
	mat[3].y = v.w;
}


void
pMatrix4::Set2(pVector4& v)
{
	mat[0].z = v.x;
	mat[1].z = v.y;
	mat[2].z = v.z;
	mat[3].z = v.w;
}


void
pMatrix4::Set3(pVector4& v)
{
	mat[0].w = v.x;
	mat[1].w = v.y;
	mat[2].w = v.z;
	mat[3].w = v.w;
}


pVector4&
pMatrix4::GetX()
{ return mat[0]; }


pVector4&
pMatrix4::GetY()
{ return mat[1]; }


pVector4&
pMatrix4::GetZ()
{ return mat[2]; }


pVector4&
pMatrix4::GetW()
{ return mat[3]; }


void
pMatrix4::Identity()
{
	mat[0].Set(1.0, 0.0, 0.0, 0.0);
	mat[1].Set(0.0, 1.0, 0.0, 0.0);
	mat[2].Set(0.0, 0.0, 1.0, 0.0);
	mat[3].Set(0.0, 0.0, 0.0, 1.0);
}


void
pMatrix4::Scale(float sx, float sy, float sz)
{
	mat[0].x *= sx;
	mat[1].y *= sy;
	mat[2].z *= sz;
}


void
pMatrix4::Scale(float sx, float sy, float sz, float sw)
{
	mat[0].x *= sx;
	mat[1].y *= sy;
	mat[2].z *= sz;
	mat[3].w *= sw;
}



void
pMatrix4::Transpose()
{
	float		tmp;

	PIERROT_MATRIX_SWAP(mat[0].y, mat[1].x);
	PIERROT_MATRIX_SWAP(mat[0].z, mat[2].x);
	PIERROT_MATRIX_SWAP(mat[1].z, mat[2].y);
	PIERROT_MATRIX_SWAP(mat[0].w, mat[3].x);
	PIERROT_MATRIX_SWAP(mat[1].w, mat[3].y);
	PIERROT_MATRIX_SWAP(mat[2].w, mat[3].z);
}


void
pMatrix4::Translate(float tx, float ty, float tz)
{
	mat[0].w += tx;
	mat[1].w += ty;
	mat[2].w += tz;
}


pMatrix4&
pMatrix4::operator=(pMatrix4& m)
{
	mat[0] = m.GetX();
	mat[1] = m.GetY();
	mat[2] = m.GetZ();
	mat[3] = m.GetW();
	return *this;
}


pMatrix4&
pMatrix4::operator+=(pMatrix4& m)
{
	mat[0] += m.GetX();
	mat[1] += m.GetY();
	mat[2] += m.GetZ();
	mat[3] += m.GetW();
	return *this;
}


pMatrix4&
pMatrix4::operator-=(pMatrix4& m)
{
	mat[0] -= m.GetX();
	mat[1] -= m.GetY();
	mat[2] -= m.GetZ();
	mat[3] -= m.GetW();
	return *this;
}


pMatrix4&
pMatrix4::operator*=(float s)
{
	mat[0] *= s;
	mat[1] *= s;
	mat[2] *= s;
	mat[3] *= s;
	return *this;
}


pMatrix4&
pMatrix4::operator/=(float s)
{
	mat[0] /= s;
	mat[1] /= s;
	mat[2] /= s;
	mat[3] /= s;
	return *this;
}


pMatrix4&
pMatrix4::operator*=(pMatrix4& m)
{
	pVector4		v;
	pMatrix4		r;

	v.Set(mat[0].x, mat[1].x, mat[2].x, mat[3].x);
	r.Set0(v * m);
	v.Set(mat[0].y, mat[1].y, mat[2].y, mat[3].y);
	r.Set1(v * m);
	v.Set(mat[0].z, mat[1].z, mat[2].z, mat[3].z);
	r.Set2(v * m);
	v.Set(mat[0].w, mat[1].w, mat[2].w, mat[3].w);
	r.Set3(v * m);

	*this = r;
	return *this;
}


pMatrix4
pMatrix4::operator~()
{
	return pMatrix4(pVector4(mat[0].x, mat[1].x, mat[2].x, mat[3].x),
					pVector4(mat[0].y, mat[1].y, mat[2].y, mat[3].y),
					pVector4(mat[0].z, mat[1].z, mat[2].z, mat[3].z),
					pVector4(mat[0].w, mat[1].w, mat[2].w, mat[3].w));
}


pMatrix4
pMatrix4::operator-()
{
	return pMatrix4(mat[0] * -1,
					mat[1] * -1,
					mat[2] * -1,
					mat[3] * -1);
}


pMatrix4
pMatrix4::operator+(pMatrix4& m)
{
	return pMatrix4(mat[0] + m.GetX(),
					mat[1] + m.GetY(),
					mat[2] + m.GetZ(),
					mat[3] + m.GetW());
}


pMatrix4
pMatrix4::operator-(pMatrix4& m)
{
	return pMatrix4(mat[0] - m.GetX(),
					mat[1] - m.GetY(),
					mat[2] - m.GetZ(),
					mat[3] - m.GetW());
}


pMatrix4
pMatrix4::operator*(float s)
{
	return pMatrix4(mat[0] * s,
					mat[1] * s,
					mat[2] * s,
					mat[3] * s);
}


pMatrix4
pMatrix4::operator/(float s)
{
	return pMatrix4(mat[0] / s,
					mat[1] / s,
					mat[2] / s,
					mat[3] / s);
}


pMatrix4
pMatrix4::operator*(pMatrix4& m)
{
	pVector4		v;
	pMatrix4		r;

	v.Set(mat[0].x, mat[1].x, mat[2].x, mat[3].x);
	r.Set0(v * m);
	v.Set(mat[0].y, mat[1].y, mat[2].y, mat[3].y);
	r.Set1(v * m);
	v.Set(mat[0].z, mat[1].z, mat[2].z, mat[3].z);
	r.Set2(v * m);
	v.Set(mat[0].w, mat[1].w, mat[2].w, mat[3].w);
	r.Set3(v * m);

	return r;
}


pMatrix4
pMatrix4::RotateX4(float s, float c)
{
	return pMatrix4(pVector4(1.0, 0.0, 0.0, 0.0),
					pVector4(0.0, c  , -s , 0.0),
					pVector4(0.0, s  , c  , 0.0),
					pVector4(0.0, 0.0, 0.0, 1.0));
}


pMatrix4
pMatrix4::RotateY4(float s, float c)
{
	return pMatrix4(pVector4(  c, 0.0, s  , 0.0),
					pVector4(0.0, 1.0, 0.0, 0.0),
					pVector4( -s, 0.0, c  , 0.0),
					pVector4(0.0, 0.0, 0.0, 1.0));
}


pMatrix4
pMatrix4::RotateZ4(float s, float c)
{
	return pMatrix4(pVector4(  c,  -s, 0.0, 0.0),
					pVector4(  s,   c, 0.0, 0.0),
					pVector4(0.0, 0.0, 1.0, 0.0),
					pVector4(0.0, 0.0, 0.0, 1.0));
}
