//
//
//	Pierrot object
//
//										(C) JoOl 1998


#include "PierrotImpExp.h"

#include <string.h>
#include <math.h>
#include "PierrotObject.h"


//--------------------------------------------------------
// 3d face
//--------------------------------------------------------

pFace::pFace()
{
	material = NULL;
	vcount = 0;
	index = NULL;
}


pFace::pFace(pMaterial* m, int32 i0, int32 i1, int32 i2)
{
	index = NULL;
	SetTo(m, i0, i1, i2);
}


pFace::pFace(pMaterial* m, int32 i0, int32 i1, int32 i2, int32 i3)
{
	index = NULL;
	SetTo(m, i0, i1, i2, i3);
}


pFace::pFace(pMaterial* m, int32 alloc, int32* in)
{
	index = NULL;
	SetTo(m, alloc, in);
}


pFace::pFace(pFace& f)
{
	index = NULL;
	SetTo(f);
}


pFace::~pFace()
{
	if (index)
		delete[] index;
}


void
pFace::SetTo(pMaterial* m, int32 i0, int32 i1, int32 i2)
{
	material = m;
	Alloc(3);
	index[0] = i0;
	index[1] = i1;
	index[2] = i2;
}


void
pFace::SetTo(pMaterial* m, int32 i0, int32 i1, int32 i2, int32 i3)
{
	material = m;
	Alloc(4);
	index[0] = i0;
	index[1] = i1;
	index[2] = i2;
	index[3] = i3;
}


void
pFace::SetTo(pMaterial* m, int32 alloc, int32* in)
{
	material = m;
	Alloc(alloc);
	memcpy(index, in, sizeof(int32)*vcount);
}


void
pFace::SetTo(pFace& f)
{
	material = f.material;
	Alloc(f.vcount);
	memcpy(index, f.index, sizeof(int32)*vcount);
}


pSpectra
pFace::GetSpectra()
{
//	return (material->diffuse + material->ambient) * 0.5;
	return material->diffuse;
}


pColor
pFace::GetColor()
{
	return pColor(GetSpectra());
}


void
pFace::Alloc(int32 nbSlots)
{
	if (index)
		delete[] index;
	index = new int32[nbSlots];
	vcount = nbSlots;
}


void
pFace::Reverse()
{
	int32				vc2 = vcount/2;
	for (int32 i = 0; i < (vcount >> 1); i++)
	{
		int32			tmp = index[i];
		index[i] = index[vcount-i - 1];
		index[vcount-i - 1] = tmp;
	}
}


//--------------------------------------------------------
// 3d object
//--------------------------------------------------------

pObject::pObject(char* n)
{
	name = strdup(n);
	matrix.Identity();

	ownVertices = true;
	vertices = new pPointsArray();
	normals = new pVectorsArray();
	misc = NULL;
}


pObject::pObject(char* n, int32 vi, int32 vb, int32 fi, int32 fb)
:faces(fi, fb)
{
	name = strdup(n);
	matrix.Identity();

	ownVertices = true;
	vertices = new pPointsArray(vi, vb);
	normals = new pVectorsArray();
	misc = NULL;
}


pObject::pObject(char* n, pPointsArray* vert, pVectorsArray* norm)
{
	name = strdup(n);
	matrix.Identity();

	ownVertices = false;
	vertices = vert;
	normals = norm;
	misc = NULL;
}


pObject::~pObject()
{
	if (ownVertices)
	{
		delete vertices;
		if (normals)
			delete normals;
	}
	delete[] name;
}


void
pObject::Transform(pMatrix4& mat)
{
	if (ownVertices)
	{
		for (int32 i = 0; i < vertices->CountItems(); i++)
		{
			pPoint3			pt3 = (*vertices)[i];
			pPoint4			pt4(pt3.x, pt3.y, pt3.z, 1.0);
			pt4 *= mat;
			(*vertices)[i] = pt4.Perspective();
		}
	}
}


void
pObject::MoveBy(pVector3& t)
{
	if (ownVertices)
	{
		// shift the object...
		for (int32 i = 0; i < vertices->CountItems(); i++)
			(*vertices)[i] += t;
	}
}


void
pObject::Rotate(pMatrix3& m)
{
	if (ownVertices)
	{
		// rotate the object...
		for (int32 i = 0; i < vertices->CountItems(); i++)
			(*vertices)[i] *= m;
	}
}


void
pObject::ScaleBy(float s)
{
	// scale translate vector of the object
	matrix.GetX().w *= s;
	matrix.GetY().w *= s;
	matrix.GetZ().w *= s;

	if (ownVertices)
	{
		// scale the object...
		for (int32 i = 0; i < vertices->CountItems(); i++)
			(*vertices)[i] *= s;
	}
}


void
pObject::Mirror(pPlane& p)
{
	if (p.normal.Colinear(pVector3(1.0, 0.0, 0.0)))
	{
		// mirror X
		for (int32 i = 0; i < vertices->CountItems(); i++)
			(*vertices)[i].MirrorYoZ();
	}
	else if (p.normal.Colinear(pVector3(0.0, 1.0, 0.0)))
	{
		// mirror Y
		for (int32 i = 0; i < vertices->CountItems(); i++)
			(*vertices)[i].MirrorXoZ();
	}
	else if (p.normal.Colinear(pVector3(0.0, 0.0, 1.0)))
	{
		// mirror Z
		for (int32 i = 0; i < vertices->CountItems(); i++)
			(*vertices)[i].MirrorXoY();
	}
	else
	{
		// generic mirror
		for (int32 i = 0; i < vertices->CountItems(); i++)
			(*vertices)[i].Mirror(p);
	}
}



pObject*
pObject::Dup(char* n)
{
	pObject*			out = new pObject(n, vertices->CountItems(), 0,
											faces.CountItems(), 0);
	// copy vertices
	for (int32 i = 0; i < vertices->CountItems(); i++)
		out->vertices->AddItem((*vertices)[i]);

	// copy faces
	for (int32 i = 0; i < faces.CountItems(); i++)
		out->faces.AddItem(new pFace(*faces[i]));

	if (normals->CountItems() > 0)
	{
		out->normals->SetAlloc(normals->CountItems(), 0);
		// copy normals
		for (int32 i = 0; i < normals->CountItems(); i++)
			out->normals->AddItem((*normals)[i]);
	}

	return out;
}


void
pObject::ClearNormals()
{
	if (ownVertices)
	{
		// reset vertices normals
		normals->SetAlloc(vertices->CountItems(), 0);
		for (int32 i = 0; i < vertices->CountItems(); i++)
			normals->AddItem(pVector3(0.0, 0.0, 0.0));
	}
}


void
pObject::SetNormals()
{
	if (vertices->CountItems() > 0)
	{
		// compute face normals
		pVectorsArray			facesNormal(faces.CountItems(), 0);
		for (int32 i = 0; i < faces.CountItems(); i++)
		{
			int32			a = faces[i]->index[0];
			int32			b = faces[i]->index[1];
			int32			c = faces[i]->index[2];
			pVector3		v0((*vertices)[a], (*vertices)[b]);
			pVector3		v1((*vertices)[a], (*vertices)[c]);
			facesNormal.AddItem(v0 ^ v1);
		}

		// compute vertices normal
		for (int32 i = 0; i < faces.CountItems(); i++)
		{
			int32			vcount = faces[i]->vcount;
			for (int32 j = 0; j < vcount; j++)
				(*normals)[faces[i]->index[j]] += facesNormal[i];
		}
	}
}


void
pObject::NormNormals()
{
	if (ownVertices)
	{
		// normalize vertices normal
		for (int32 i = 0; i < vertices->CountItems(); i++)
			(*normals)[i].Norm();
	}
}


void
pObject::SetBounds()
{
	// compute current bounds (using own vertices)
/*	pPoint3			pt3;
	pPoint4			pt4;
	for (int32 i = 0; i < vertices->CountItems(); i++)
	{
		pt3 = (*vertices)[i];
		pt4.Set(pt3.x, pt3.y, pt3.z, 1.0);
		pt4 *= matrix;
		pt3 = pt4.Perspective();
		if (i == 0)
			bounds.Set(pt3, pt3);
		else
			bounds |= pt3;
	}
*/
	for (int32 i = 0; i < vertices->CountItems(); i++)
	{
		pPoint3&		pt3 = (*vertices)[i];
		if (i == 0)
			bounds.Set(pt3, pt3);
		else
			bounds |= pt3;
	}

	// process own vertices
	float			radius = 0.0;
	pPoint3			center = bounds.Center();
	for (int32 i = 0; i < vertices->CountItems(); i++)
	{
		float		currLen = pVector3(center, (*vertices)[i]).Length2();
		if (currLen > radius)
			radius = currLen;
	}
	radius = sqrt(radius);
	sbounds.Set(center, radius);
}

