//
//
//	Pierrot pointer array
//
//											(C) JoOl 1998


#include "PierrotImpExp.h"

#include <malloc.h>
#include "PierrotPtrArray.h"


PierrotPtrArrayBase::PierrotPtrArrayBase()
{
	items = NULL;
	nbItems = nbSlots = blockSize = 0;
}


PierrotPtrArrayBase::PierrotPtrArrayBase(int32 isize, int32 bsize)
{
	items = NULL;
	SetAlloc(isize, bsize);
}


PierrotPtrArrayBase::~PierrotPtrArrayBase()
{
	DelAlloc();
}


void
PierrotPtrArrayBase::GrowForItems(int32 n)
{
	if (nbSlots + n > nbSlots)
		Grow(nbSlots + n);
}


void
PierrotPtrArrayBase::SetAlloc(int32 isize, int32 bsize)
{
	DelAlloc();
	items = (void** )malloc(sizeof(void* ) * isize);
	nbItems = 0;
	nbSlots = isize;
	blockSize = bsize;
}


void
PierrotPtrArrayBase::DelAlloc()
{
	if (items)
		free(items);
	nbSlots = blockSize = nbItems = 0;
}


bool
PierrotPtrArrayBase::IsAllocated() const
{
	return items != NULL;
}


void
PierrotPtrArrayBase::Grow(int32 newSize)
{
	void**			newItems = (void** )malloc(sizeof(void* ) * newSize);
	memcpy(newItems, items, sizeof(void* ) * nbItems);
	free(items);
	items = newItems;
	nbSlots = newSize;
}


int32
PierrotPtrArrayBase::CountItems() const
{
	return nbItems;
}


void
PierrotPtrArrayBase::ClearItem(int32 index)
{
	items[index] = NULL;
}


void
PierrotPtrArrayBase::ClearItems()
{
	for (int32 i = 0; i < nbItems; i++)
		items[i] = NULL;
}


void*
PierrotPtrArrayBase::operator[](int32 index)
{
	return items[index];
}


void
PierrotPtrArrayBase::AddItem(void* item)
{
	if (nbItems >= nbSlots)
		Grow(nbSlots + blockSize);

	if (nbSlots <= nbItems)
		printf("**** PierrotPtrArrayBase::AddItem: can't accomodate new item\n\
				nbItems=%d, nbSlots=%d, blockSize=%d\n",
				nbItems, nbSlots, blockSize);

	items[nbItems++] = item;
}


int32
PierrotPtrArrayBase::Search(ppabCmpFunc cf, void* arg)
{
	for (int32 i = 0; i < nbItems; i++)
	{
		if (!cf(items[i], arg))
			return i;
	}
	return -1;
}
