#include <Debug.h>
#include "GenericInput.h"

#include <StringView.h>
#include <TextControl.h>
#include <Box.h>

#include "GButton.h"
#include "GManager.h"
#include "WindowManager.h"

//=========================================================================

GenericInputWindow::GenericInputWindow( BRect frame, const char* title, const char* name, const char* OK, const char* Cancel, 
										GManager *the_manager,
										BMessage* msg, BHandler* handler, const char* initial, int maxLen, const char* fname)
	 				: BWindow(frame, "", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE ),
	 				  BInvoker( msg, handler )
{
	
	PRINT(("GenericInputWindow::GenericInputWindow\n"));
	mManager = the_manager;
	
	BRect btnRect(62,70,122,90);
	unsigned int extra;
	
	// use the constructor parameters
	sndMessage = msg;
	SetTitle( title );
	strcpy( fieldName, fname );

	// Set up the view
	BRect aRect( Bounds() );
	genView = new GenericInputView( aRect );
	AddChild( genView );
	
	// set up the label
	label = new BStringView( BRect(10,7,192,23), "", name );
	label->SetFont(be_bold_font);
	label->SetFontSize(11);
	genView->AddChild( label );

	// set up the edit control
	personName = new BTextControl( BRect(8,25,192,45), "gen_in", "", "", NULL );
	personName->SetViewColor( 216, 216, 216 );
	personName->SetDivider( 0 );
	genView->AddChild( personName );
	if( initial )
		personName->SetText( initial );
	if( maxLen )
		personName->TextView()->SetMaxBytes( maxLen );
	
	// Now call the function that will let derived classes add extra controls if they want
	MakeExtraControls( genView, extra );
	if( extra ) {
		genView->ResizeBy( 0, extra );
		ResizeBy( 0, extra );
		btnRect.OffsetBy( 0, extra );
	}

	// Make the groovy little line
	BBox* divider = new BBox(BRect(11,55,192,57),"divider", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW, B_FANCY_BORDER);	
	AddChild( divider );
	
	// Make the Save and Cancel buttons
	SaveButton = new GButton( btnRect, "savebutton", OK, new BMessage(B_OK));
	SaveButton->MakeDefault( true );

	btnRect.left += SaveButton -> Bounds().Width() + 7;
	CancelButton = new GButton( btnRect, "cancelbutton", Cancel, new BMessage(B_CANCEL) );
	genView->AddChild( SaveButton );
	genView->AddChild( CancelButton );
	personName->MakeFocus(true);
}

//-------------------------------------------------------------------------

GenericInputWindow::~GenericInputWindow() {
}

//-------------------------------------------------------------------------

void GenericInputWindow::MakeExtraControls( BView* view, unsigned int& extraHeight ) {
	extraHeight = 0;
	PRINT(("GenericInputWindow::MakeExtraControls\n"));
}

//-------------------------------------------------------------------------

bool GenericInputWindow::QuitRequested()
{
	PRINT(("GenericInputWindow::QuitRequested\n"));
	mManager -> windows -> CloseGeneralWindow(this);
	return(true);
}

//-------------------------------------------------------------------------

void GenericInputWindow::MessageReceived(BMessage* msg){
	PRINT(("GenericInputWindow::MessageReceived\n"));
	switch(msg->what)
	{
		case B_OK:
			Save();	
			if(sndMessage) {
				Invoke(sndMessage);
			}
			
		case B_CANCEL:
			QuitRequested();
			Close();
			break;
	
		default:
			BWindow::MessageReceived(msg);
	}
}

//-------------------------------------------------------------------------

void GenericInputWindow::Save() {
	PRINT(("GenericInputWindow::Save\n"));

	if( sndMessage ) {
		sndMessage->AddString( fieldName, personName->Text() );
	}
}

//-------------------------------------------------------------------------

// the cancel function
void GenericInputWindow::DispatchMessage( BMessage* msg, BHandler* handler ) {
	PRINT(("GenericInputWindow::DispatchMessage\n"));

	// if it's a cancel key, post a B_CANCEL message
	if( msg->what == B_KEY_DOWN )
		if( msg->HasString("bytes") && msg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( new BMessage(B_CANCEL) );
			return;
		}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( msg, handler );
}

//=========================================================================

GenericInputView::GenericInputView( BRect rect )
	   	   : BView(rect, "generic_input_view", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW)
{
	PRINT(("GenericInputView::View\n"));
	SetViewColor( 216, 216, 216 );
}

//=========================================================================
