#ifndef PLIST_H
#define PLIST_H

#include <List.h>

#include <stdio.h>

template<class T>
class PList: public BList {

public:
	PList( int32 aBlockSize = 20 ) :BList(aBlockSize){}
	PList( const PList &aList ) :BList( dynamic_cast<BList &>(aList) ) {}

	bool AddItem( T *aItem );
	bool AddItem( T *aItem, int32 aIndex );

	bool RemoveItem( T *aItem );
	T *RemoveItem( int32 aIndex );
	bool RemoveItems( int32 aIndex, int32 aCount );

	T *FirstItem();
	T *LastItem();
	T *ItemAt( int32 aIndex );

	bool HasItem( T *aItem );
	int32 IndexOf( T *aItem );

	T *FindItem( bool (*func)( T *, void *), void *comp );
	void DoForEach( bool (*func)(T *) );
	void DoForEach( bool (*func)(T *,void *), void *arg2 );
	void SortItems( int (*compfunc)(const T *, const T *) );

	void Debug();

	typedef bool (*GenericDoForEach1)(void *);
	typedef bool (*GenericDoForEach2)(void *, void *);
	typedef int (*GenericSort)(const void *, const void *);

};

template<class T>
bool 
PList<T>::AddItem(T *aItem)
{
	return BList::AddItem( static_cast<void *>(aItem) );
}

template<class T>
bool 
PList<T>::AddItem(T *aItem, int32 aIndex)
{
	return BList::AddItem( static_cast<void *>(aItem), aIndex );
}

template<class T>
bool 
PList<T>::RemoveItem(T *aItem)
{
	return BList::RemoveItem( static_cast<void *>(aItem) );
}

template<class T>
T *
PList<T>::RemoveItem(int32 aIndex)
{
	return static_cast<T *>(BList::RemoveItem( aIndex ));
}

template<class T>
bool 
PList<T>::RemoveItems(int32 aIndex, int32 aCount)
{
	return BList::RemoveItems( aIndex, aCount );
}

template<class T>
T *
PList<T>::FirstItem()
{
	return static_cast<T *>( BList::FirstItem() );
}

template<class T>
T *
PList<T>::LastItem()
{
	return static_cast<T *>( BList::LastItem() );
}

template<class T>
T *
PList<T>::ItemAt(int32 aIndex)
{
	return static_cast<T *>( BList::ItemAt( aIndex ) );
}

template<class T>
bool 
PList<T>::HasItem(T *aItem)
{
	return BList::HasItem( static_cast<void *>(aItem) );
}

template<class T>
int32 
PList<T>::IndexOf(T *aItem)
{
	return BList::IndexOf( static_cast<void *>(aItem) );
}

template<class T>
T *
PList<T>::FindItem(bool( *func)( T *, void *), void *comp)
{
	for( int i=0; i<CountItems(); i++ ) {
		T *item = ItemAt( i );
		if( func( item, comp ) )
			return item;
	}
	return NULL;
}

template<class T>
void 
PList<T>::DoForEach(bool( *func)( T *))
{
	BList::DoForEach( reinterpret_cast<GenericDoForEach1>(func) );
}

template<class T>
void 
PList<T>::DoForEach(bool( *func)( T *, void *), void *arg2)
{
	BList::DoForEach( reinterpret_cast<GenericDoForEach2>(func), arg2);
}

template<class T>
void 
PList<T>::SortItems(int( *compfunc)( const T *, const T *))
{
	BList::SortItems( static_cast<GenericSort>(compfunc) );
}

template<class T>
void 
PList<T>::Debug()
{
	int i, size = BList::CountItems();
	printf("\nStart of list:\n");
	for( i=0; i<size; i++ ) {
		printf("\t ptr: 0x%lu\n", (uint32)BList::ItemAt(i) );
	}
	printf("End of list:\n" );	
}


#endif

