#include <Debug.h>
#include "Gim-ICQ.h"

#include <string.h>

#include "GConstants.h"
#include "GManager.h"
#include "WindowManager.h"

//---------------------------------------------------------------------

int main( int argc, void** argv )
{
	GApplication *app = new GApplication();
	app -> Run();

	delete app;
	
	return(0);
}

//---------------------------------------------------------------------

GApplication::GApplication()
	:BApplication(APP_SIGNATURE)
	,mManager( NULL )
{
//	SET_DEBUG_ENABLED(true);
	SET_DEBUG_ENABLED(false);
	mManager = new GManager();
		
	mManager -> windows -> OpenBuddyList();


}

//---------------------------------------------------------------------

GApplication::~GApplication() {

}

//---------------------------------------------------------------------

bool GApplication::QuitRequested() {

	return true;
}

//---------------------------------------------------------------------

// Central message "switchboard" of GIMICQ
void GApplication::MessageReceived( BMessage* aMsg ) {
	aMsg->AddInt32( "proto", int32(AIM_PROTOCOL) );
	
	switch(aMsg->what)
	{

		case GIMICQ_TOGGLE_HIDDEN:
			mManager -> windows -> ToggleHidden();
			break;
			
		case GIMICQ_OPEN_BUDDY_LIST:
			mManager -> windows -> OpenBuddyList();
			break;

//		case ICQ_AUTH_REQUEST:					// ENDAST FOR TEST!!!!!
		case GIMICQ_SEARCH_BY_EMAIL:
		case GIMICQ_UPDATE_MY_INFO:
		case GIMICQ_OPEN_PREFS:
		case B_ABOUT_REQUESTED:
		case GIMICQ_OPEN_USER_WINDOW:
		case GIMICQ_MY_STATUS_CHANGE:
			mManager -> windows -> SendBuddyListMessage(aMsg);
			break;
			
		default:
			BApplication::MessageReceived( aMsg );
	}
}
