#ifndef _LOCALE_H_
#define _LOCALE_H_

#define BUFFER_LENGTH 128

#define _(name) mLocale -> FindString(name)

class BString;
class BMessage;
class BLocker;

class GManager;

class Locale{

public:
	Locale(GManager *aManager);
	~Locale();
	
	const char *FindString(const char *aName);
	int SetLocale(const char *aLocaleFile);
	
private:
	
	int LoadMessage(BFile *aFile);
	void DumpLocale();
	void ClearComment(BString *aStr);
	void ClearWhites(BString *str);
	void LoadDefault();
	
	BMessage *mLocaleMsg;		
	
	BLocker *mLock;
	GManager *mManager;
};

#endif //_LOCALE_H_