#include <Debug.h>
#include "AboutBox.h"

#include <StringView.h>
#include <String.h>


#include "GButton.h"
#include "GConstants.h"
#include "GManager.h"
#include "WindowManager.h"
#include "FancyView.h"
#include "Locale.h"

AboutBox::AboutBox( BRect frame, GManager *the_manager )
	: BWindow( frame, the_manager -> _("title1") , B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE )
{
	PRINT(("AboutBox::AboutBox\n"));
	
	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;
	
	BRect rect3 = Bounds();
	BView* grayView = new BView( rect3, "gray", B_FOLLOW_ALL_SIDES, B_WILL_DRAW );
	grayView->SetViewColor( 216, 216, 216 );
	AddChild( grayView );
	
	rect3.top += 17;
	rect3.bottom = rect3.top + 20;
	rect3.left += 17;

//	BString text = mLocale -> FindString("text1");
	BString text = _("text1");
	text += ": ";
	text += kVERSION;

	BStringView *text_view = new BStringView(rect3, "about", text.String() );
	grayView -> AddChild(text_view);
	
	rect3 = Bounds();
	rect3.right -= 55;
	rect3.left = rect3.right - 40;
	rect3.bottom -= 15;
	rect3.top = rect3.bottom - 15;
	closeButton = new GButton( rect3, "buttonRun", _("closebutton"), new BMessage(B_CANCEL), B_FOLLOW_H_CENTER );
	closeButton->SetTarget(this);
	closeButton->MakeDefault( true );
	
	grayView->AddChild( closeButton );

	
/*	BBitmap* mainlogo = NULL;

	windowBack = new BView( Bounds(), "windowBack", B_FOLLOW_ALL_SIDES, B_WILL_DRAW );
	//windowBack->SetViewColor( 216, 216, 216 );
	windowBack->SetViewColor( 0, 0, 0 );
	AddChild( windowBack );
*/	
	// da logo
/*	GetBitmapFromResources( mainlogo, 42 );
	BRect bframe = Bounds();
	bframe.bottom = 79;
	BitmapView* bview = new BitmapView( bframe, mainlogo );
	windowBack->AddChild( bview );
*/
	// textview stuff
/*	BRect bounds = Bounds();
	bounds.top = 80;
	bounds.bottom = 196;//200;
	BRect rect2 = bounds;
	rect2.OffsetTo( 0, 0 );
	rect2.InsetBy( 2, 2 );
	fancy = new FancyTextView( bounds, "scroller", rect2 );
	fancy->MakeEditable( false );
	fancy->SetStylable( true );
	fancy->MakeSelectable( false );
	windowBack->AddChild( fancy );
	rgb_color black;
	BFont chatFont = be_plain_font;
	black.red = black.blue = 0;
	black.green = 255;
	chatFont.SetSize( 12.0 );
	fancy->SetBaseFontAndColor( chatFont, black );
	fancy->SetAlignment( B_ALIGN_CENTER );
	fancy->SetViewColor( 0, 0, 0 );
	
	// insert some text
	DoTextInsert();
	
	// set up the ticker
	heightDone = 0;
	BMessage* tickMsg = new BMessage(SCROLL_IT);
	ticker = new BMessageRunner( this, tickMsg, 7000 );
*/	
	// insert that bottom view
/*	BRect rect3 = Bounds();
	rect3.top = 199;
	BView* grayView = new BView( rect3, "gray", B_FOLLOW_ALL_SIDES, B_WILL_DRAW );
	grayView->SetViewColor( 216, 216, 216 );
	windowBack->AddChild( grayView );
	
	closeButton = new BButton( BRect( 149, 06, 219, 26 ), "buttonRun", "Close", new BMessage(B_CANCEL) );
	closeButton->SetTarget(this);
	closeButton->MakeDefault( true );
	grayView->AddChild( closeButton );
*/
}


void AboutBox::MessageReceived( BMessage *msg )
{
	PRINT(("AboutBox::MessageReceived\n"));
	switch (msg -> what )
	{

		case B_CANCEL:
			PostMessage( new BMessage(B_QUIT_REQUESTED) );
			break;
			
		case SCROLL_IT:
			DoScroll();
			break;

		default:
			BWindow::MessageReceived(msg);
			break;
	};
}

bool AboutBox::QuitRequested()
{
	PRINT(("AboutBox::QuitRequested\n"));
	mManager -> windows -> CloseGeneralWindow(this);
	return(true);
}


void AboutBox::DoScroll() {

	PRINT(("AboutBox::DoScroll\n"));
	//fancy->ScrollBy( 0, 1 );
	fancy->ScrollBy( 0, 1 );
	++heightDone;
	
	if( heightDone > totalHeight ) {
		heightDone = 0;
		fancy->ScrollTo( 0, 0 );
	}
}


void AboutBox::DoTextInsert() {

	PRINT(("AboutBox::DoTextInsert\n"));
	fancy->ClearInsertStuff();
	fancy->ResetFontToBase();
	fancy->InsertSomeText( "\n\n\n\n\n\n\n" );
	
	// Gim-ICQ in big letters
	fancy->SetFontAttribute( B_BOLD_FACE, true );
	fancy->SetFontSize( 40 );
	fancy->SetFontColor( 0, 128, 0 );
	fancy->InsertSomeText( "G" );
	fancy->SetFontColor( 0, 132, 0 );
	fancy->InsertSomeText( "i" );
	fancy->SetFontColor( 0, 150, 0 );
	fancy->InsertSomeText( "m" );
	fancy->SetFontColor( 0, 175, 0 );
	fancy->InsertSomeText( "I" );
	fancy->SetFontColor( 0, 200, 0 );
	fancy->InsertSomeText( "C" );
	fancy->SetFontColor( 0, 255, 0 );
	fancy->InsertSomeText( "Q" );
	fancy->SetFontColor( 255, 0, 0 );
	fancy->SetFontSize( 55 );
	fancy->SetFontAttribute( B_ITALIC_FACE, true );
	fancy->InsertSomeText( " 2" );
	fancy->ResetFontToBase();
	fancy->SetFontSize( 11 );
	fancy->InsertSomeText( "\n(OK... version 2.01)\nhttp://www.gimmick.org\n" );
	fancy->ResetFontToBase();
	
	// stuff
	fancy->InsertSomeText( "\n\n\nFeaturing the talents of:\n\n" );
	fancy->SetFontSize( 20 );
	fancy->SetFontAttribute( B_BOLD_FACE, true );
	fancy->InsertSomeText( "Sean Heber\n" );
	fancy->InsertSomeText( "Greg Nichols\n" );
	fancy->InsertSomeText( "The BeOS team\n\n" );
	fancy->ResetFontToBase();
	
	fancy->SetFontSize( 16 );
	fancy->SetFontAttribute( B_BOLD_FACE, true );
	fancy->InsertSomeText( "\n\n\nSpecial thanks to:\n" );
	fancy->ResetFontToBase();
	fancy->InsertSomeText( "(this could take a while...)\n\n" );
	fancy->SetFontColor( 255, 0, 255 );
	fancy->InsertSomeText( "The Color Purple\n" );
	fancy->SetFontColor( 0, 255, 0 );
	fancy->InsertSomeText( "The Number 42\n" );
	fancy->SetFontAttribute( B_ITALIC_FACE, true );
	fancy->InsertSomeText( "The Matrix\nThe Mummy\n" );
	fancy->SetFontAttribute( B_ITALIC_FACE, false );
	fancy->InsertSomeText( "George Lucas and ILM\n" );
	fancy->SetFontAttribute( B_ITALIC_FACE, true );
	fancy->InsertSomeText( "The Phantom Menace\nThe Little Menace\nStar Wars\nThe Empire Strikes Back\nReturn of the Jedi\nTroops\nRubber Band Guy\n" );
	fancy->SetFontAttribute( B_ITALIC_FACE, false );
	fancy->InsertSomeText( "Kyle, Cartman, Kenny, and Stan\nAnyone named Chrissy\nSpring Wind\nBryce Parks and the Video Rangers\nGod\nJean-Louis Gassée\nSteve Sakoman\nScott Barta\nYoda\nYogurt\nLoneStar and Barf\nPresident Scroob\nScooby-Doo\nPapa Smurf\nPapa Johns\nJohn Doe\n" );
	fancy->InsertSomeText( "Jerry Green\nLegions (sniff)\n" );
	fancy->InsertSomeText( "Mountain Dew\nMountain Dew\n" );
	fancy->SetFontColor( 100, 200, 255 );
	fancy->InsertSomeText( "BeNews\nBeOSCentral\n#beos at oz.org\nGord McLeod\nTimothy Elliot\nTV Guide\nI AM ZEPH\nwARd\nkang\n{rHiNo}\nAllan Anderson\nJohn Ashmun\nChris Herboth\nyou guys, too\n" );
	fancy->SetFontColor( 0, 255, 0 );
	fancy->InsertSomeText( "Bill Gates and Steve Jobs\n" );
	fancy->SetFontSize( 9 );
	fancy->InsertSomeText( "(without whom there would be no BeOS)\n" );
	fancy->ResetFontToBase();
	fancy->InsertSomeText( "Rubber Ducky\nMason Reese\nJackie Chan\nChris Tucker\nUSA and USB\nNASA\nNAACP\nNCAA\nNFL, NBA, NHL, MLB, and MIB\nDVD, PCS, HDTV, and LCD\nCIA, FBI, NSA, and Bill\nHillary, too\nQueen Elizabeth II\nThe King of Norway\n" );
	fancy->InsertSomeText( "The Friendly Faces on Easter Island\nZaphod Beeblebrox\nSlartibartfast\nStarship Heart of Gold\nMagrathea Chamber of Commerce\nMulder and Scully\nThe Cigarette Smoking Man\nCrop circles\nBees with strange diseases\n" );
	fancy->InsertSomeText( "The Black Oil from Long, Long ago\n" );
	fancy->InsertSomeText( "The inhabitants of a galaxy far, far away\n" );
	fancy->InsertSomeText( "The Be, Inc. documentation guys\n" );
	fancy->InsertSomeText( "...who turned into kernel engineers\n" );
	fancy->InsertSomeText( "The FedEx guy\n" );
	fancy->SetFontSize( 9 );
	fancy->InsertSomeText( "(who brought us Genki! Yeah!)\n" );
	fancy->ResetFontToBase();
	fancy->InsertSomeText( "Jean-Baptiste Queru\n" );
	fancy->SetFontSize( 9 );
	fancy->InsertSomeText( "(for whipping BeDevTalk into shape)\n" );

	fancy->AddStatement();
	fancy->ClearInsertStuff();
	fancy->ResetFontToBase();
	fancy->InsertSomeText( "Howard the Network guy\nHoward the Duck\nHoward the Stern\n" );
	fancy->InsertSomeText( "BeDevTalk\nBeCodeTalk\nBe Gossip Talk\nBe Church Chat\nBe Fruit-of-the-Month club\nBe Paranormal, L.L.C.\nBeGone Pest Repellant\nBeCool shades\nBeClean soap\nBeCrazy Caffeine Supplements\n" );
	fancy->InsertSomeText( "CodyCam\nJennicam\nThe Truman Show\nCristof\nJim Carrey\nNatascha McElhone\nWill Smith\nThe Easter Bunny\nSanta Claus\nThe Tooth Fairy\nThe Cheshire Cat\nAlice\nThe White Rabbit\nDennis Nedry\nNeo\nMorpheus\nMorphine\n" );
	fancy->InsertSomeText( "Morbias\nDeck16\nAriza\nNOT Elsinore or DeathFan!\nHealPod\nFith\nRadikus\nTundra\nCurse\nTim Sweeney\nJohn Carmack\nThe Beetles\nThe VW Bug\nAustin Powers, baby, yeah!\nDr. Evil\nMini-Me\nSCOTT!!!\nGeneralissimo\nSalacious Crumb\n7 of 9\nSpock\n" );
	fancy->InsertSomeText( "Agent Smith\nThe Wachowski Brothers\nDarth Maul\nDarth Vader\nDarth Sidious\nJar-Jar Binks\nNatalie Portman\nKirsten Lyshoj\nThe Microsoft USB Optical Intellimouse\nWilliam Bull (artillion.com)\nStormy Chinchilla\nMP3's\nGettin' Jiggy wit it\nIggy\nDust Puppy\nPrak\nThe frogs of the world\nThe Virtual Noodle\n\n\n\n" );
	
	fancy->SetFontSize( 16 );
	fancy->SetFontAttribute( B_BOLD_FACE, true );
	fancy->InsertSomeText( "\n\n\nNo thanks to:\n" );
	fancy->ResetFontToBase();
	fancy->InsertSomeText( " School\nUnplanned business trips\nDivx\n'nuff said.\n\n\n\n" );

	fancy->SetFontColor( 255, 255, 0 );
	fancy->InsertSomeText( "\n\nYou're wondering why we spent so much time on this stupid about box when we should be coding Gimmick, right?\n\n\n\n" );
	fancy->InsertSomeText( "So are we." );
	fancy->AddStatement();
	
	lineCount = fancy->CountLines();
	lastOffset = fancy->OffsetAt( lineCount );
	totalHeight = fancy->TextHeight( 0, lastOffset );
	
	fancy->ScrollTo( 0, 0 );
}




// the cancel function
void AboutBox::DispatchMessage( BMessage* msg, BHandler* handler ) {

	PRINT(("AboutBox::DispatchMessage\n"));
	// if it's a cancel key, post a B_CANCEL message
	if( msg->what == B_KEY_DOWN )
		if( msg->HasString("bytes") && msg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( new BMessage(B_CANCEL) );
			return;
		}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( msg, handler );
}

