/*
 * Used for Authorization requests.
 */

#include <Debug.h>
#include "AuthorizationWindow.h"

#include <View.h>
#include <StringView.h>
#include <String.h>

#include "GButton.h"
#include "Gicq.h"
#include "GManager.h"
#include "WindowManager.h"
#include "Locale.h"

AuthorizationWindow::AuthorizationWindow(const char *nickname, unsigned int from_uin, const char *reason, GManager *the_manager) :
						BWindow(BRect(50,50,400,200), the_manager -> _("title2") , B_MODAL_WINDOW_LOOK, B_NORMAL_WINDOW_FEEL,
										B_NOT_ZOOMABLE | B_NOT_RESIZABLE, B_ALL_WORKSPACES )
{
	PRINT(("AuthorizationWindow::AuthorizationWindow\n"));

	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;
	
	BView *view = new BView(Bounds(),"view", B_FOLLOW_ALL_SIDES, B_WILL_DRAW);
	
	BString msg;
	GButton *button;
	BRect place = view -> Bounds();
	place.bottom = place.top + 25;

	
	msg = _("text2");
	msg += ":";
	
	BStringView *str_view = new BStringView(place,"text", msg.String() , B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP);
	str_view -> SetAlignment(B_ALIGN_CENTER);
	view -> AddChild(str_view);
	
	place.top = place.bottom;
	place.bottom += 20;

	msg = nickname;
	msg += "(UIN ";
	msg << from_uin;
	msg += ") "; 
	msg += _("text3");

	str_view = new BStringView(place,"text", msg.String() , B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP);
	str_view -> SetAlignment(B_ALIGN_LEFT);
	view -> AddChild(str_view);

	place.top = place.bottom;
	place.bottom += 40;

	msg = _("text4");
	msg += ":  ";
	msg += reason;
	
	str_view = new BStringView(place,"text", msg.String() , B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP);
	str_view -> SetAlignment(B_ALIGN_LEFT);
	view -> AddChild(str_view);


	place.top = view -> Bounds().bottom - 25;
	place.bottom = view -> Bounds().bottom-7;
	
	place.right -= 7;
	place.left = place.right - 40;
	
	BMessage *auth_message = new BMessage(ICQ_GRANT_AUTH);
	auth_message -> AddInt32("UIN", from_uin);
	
	button = new GButton(place,"yes_button", _("yesbutton") ,auth_message, B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM);
	view -> AddChild(button);

	place.right = view -> Bounds().right - button -> Bounds().Width() - 7;
	place.left = place.right - 40;
	
	button = new GButton(place,"no_button", _("nobutton") ,new BMessage(AUTH_DENIED), B_FOLLOW_RIGHT|B_FOLLOW_BOTTOM);
	view -> AddChild( button );
	
	place.left = view -> Bounds().left + 7;
	place.right = place.left + 70;
	
	BMessage *user_info = new BMessage(GIMICQ_OPEN_USER_WINDOW);
	user_info->AddInt32( "UIN", (int32)from_uin );	
	user_info->AddInt32( "wtype", (int32)USER_INFO_TYPE );
	user_info->AddPointer( "poswindow", this );

	button = new GButton(place,"userinfo_button", _("userinfobutton") ,user_info, B_FOLLOW_LEFT|B_FOLLOW_BOTTOM);
	view -> AddChild( button );
	
	view -> SetViewColor(216,216,216);
	
	AddChild(view);
}

AuthorizationWindow::~AuthorizationWindow() {
	mManager -> windows -> CloseGeneralWindow(this);
}

void AuthorizationWindow::MessageReceived(BMessage *msg) {
	PRINT(("AuthorizationWindow::MessageReceived\n"));
	switch(msg -> what) {

		case ICQ_GRANT_AUTH:
			mManager -> icq -> PostMessage( msg );
			Lock();
			Quit();
			break;
		
		case AUTH_DENIED:
			Lock();
			Quit();
			break;
			
		case GIMICQ_OPEN_USER_WINDOW:
			mManager -> windows -> SendBuddyListMessage(msg);
			break;
			
		default:
			BWindow::MessageReceived(msg);
			break;
		
	}
	
}