#ifndef _BEAIM_CHATWINDOW_H__
#define _BEAIM_CHATWINDOW_H__


#include <Window.h>
#include <StringView.h>
#include <View.h>

#include "GConstants.h"

class	BBox;
class BRect;
class BPoint;
class BMessage;
class BHandler;
class	BMenuBar;
class	BMenu;
class BMenuItem;
class	BScrollView;
class	BFont;

class GButton;
class GManager;
class Locale;
class	FancyTextView;
class	HTMLView;


//=====================================================

const uint32 CHATWINDOW_SHOW_IN_ALL_WORKSPACES = 'shAw';
const uint32 CHATWINDOW_SHOW_IN_THIS_WORKSPACE = 'shTw';
const uint32 CHATWINDOW_POPUP_ON_RECEIVE       = 'pPRc';
const uint32 CHATWINDOW_SHOW_FONT_COLORS_SIZES = 'aWot';
const uint32 CHATWINDOW_ENABLE_LINKS 		   = 'lYnX';
const uint32 CHATWINDOW_CLOSE_AFTER_SEND	   = 'cLaS';
const uint32 CHATWINDOW_FONT_BASE   = 'cfs0';
const uint32 CHATWINDOW_FONT_SIZE_1 = 'cfs1';
const uint32 CHATWINDOW_FONT_SIZE_2 = 'cfs2';
const uint32 CHATWINDOW_FONT_SIZE_3 = 'cfs3';
const uint32 CHATWINDOW_FONT_SIZE_4 = 'cfs4';
const uint32 CHATWINDOW_FONT_SIZE_5 = 'cfs5';
const uint32 CHATWINDOW_FONT_SIZE_6 = 'cfs6';
const uint32 CHATWINDOW_FONT_SIZE_7 = 'cfs7';
const uint32 CHATWINDOW_FONT_NORMAL = 'cfNM';
const uint32 CHATWINDOW_FONT_ITALIC = 'cfIT';
const uint32 CHATWINDOW_FONT_BOLD   = 'cfBL';

//=====================================================

class PointerStringView : public BStringView {

	public:
		PointerStringView( BRect frame, const char *name, const char *text, 
					   uint32 resizingMode = B_FOLLOW_LEFT | B_FOLLOW_TOP, 
					   uint32 flags = B_WILL_DRAW );
		virtual void MouseMoved( BPoint where, uint32 code, const BMessage *msg );
};

//=====================================================

class BottomView : public BView {
	
	friend class ChatWindow;

	public:
		BottomView( BRect frame, GManager *the_manager );
	private:
		GButton *sendButton;

		GManager *mManager;
};

//=====================================================

class ChatWindow : public BWindow {

 	public:
		ChatWindow( uint32 u, const char* nick, BRect frame, bool minimize, uint32 enc, GManager *the_manager );
		virtual void MessageReceived(BMessage *message);
		virtual void FrameResized( float width, float height );
		virtual bool QuitRequested(); 
		virtual void MenusBeginning();
		virtual void DispatchMessage( BMessage* msg, BHandler* handler );
		virtual void WindowActivated( bool active );

		void Popup();
		void ForcePopup();
		void LoadPrefs();
		void InformDeskbar(uint32 what);

	private:
		void _InitWindow(void);
		void ProcessIncomingIM( BMessage* , bool play_sound = true);
		void ProcessIncomingURL( BMessage*,  bool play_sound = true);
		void AddMyStatement( const char* statement , bool play_sound = true);
		void SetStyles( BMessage* );
		void AddPerson( BMessage* );
		void UpdateLastMessage();
		void SendURL();
		void SendMessage();
		void DisplaySentURL( BMessage* , bool play_sound = true);
		void FixLineBreaks( char* buffer, const char* input );
		void UnFixLineBreaks( char* buffer, char* input );
		void SetEncoding( uint32 encoding );
		void AddOfflineDone( bool repeat=false );
	
		BMenuBar* menubar;
		FancyTextView* textview;
		HTMLView* editview;
		BScrollView* textscrollview;
		BScrollView* editscrollview;
		BBox* dragger;
		BMenuItem* saveitem;
		BottomView* btView;
		PointerStringView* lastView;
		
		BMenuItem* miCopy;
		BMenuItem* miCut;
		BMenuItem* miPaste;	
		BMenuItem* miUndo;
		BMenuItem* miSelectAll;
		BMenuItem* miPopupOnReceive;
		BMenuItem* miAllWorkspaces;
		BMenuItem* miThisWorkspace;
		BMenuItem* miShowFontColorSizes;
		BMenuItem* miEnableLinks;

		BMenuItem* miNormal;
		BMenuItem* miBold;
		BMenuItem* miItalic;
		BMenuItem* miS1;
		BMenuItem* miS2;
		BMenuItem* miS3;
		BMenuItem* miS4;
		BMenuItem* miS5;
		BMenuItem* miS6;
		BMenuItem* miS7;
		
		BMenuItem* e1;
		BMenuItem* e2;
		BMenuItem* e3;
		BMenuItem* e4;
		BMenuItem* e5;
		BMenuItem* e6;
		BMenuItem* e7;
		BMenuItem* e8;
		BMenuItem* e9;
		BMenuItem* e10;
		BMenuItem* e11;
		BMenuItem* e12;
		
		BMenu* nameMenu;
		
		float divider;
		float topUIMargin;
		float midUIMargin;
		float botUIMargin;
		float totalUIMargin;
		float lastWidth, lastHeight;
		
		bool mFinnishedUpdating;
		bool popupOnReceive;
		bool showFontColorSizes;
		bool linksEnabled;
		bool hasNewMessage;
		bool prefixNewMessages;
		bool enterIsNewline;
		bool closeAfterSend;
		bool isFlashing;
		
		BFont chatFont;
		char displayName[DISPLAY_NAME_MAX];
		uint32 uin;
		
		uint32 useEncoding;
		GManager *mManager;
		Locale *mLocale;
};

//=====================================================

#endif
