#ifndef BEAIM_FANCY_TEXT_VIEW_H
#define BEAIM_FANCY_TEXT_VIEW_H

#include <TextView.h>

#include "TextElement.h"
#include "GenList.h"

#define NORMAL_FONT_SIZE 3

#define FANCY_MESSAGE_MAX 2048

//=========================================================

class BRect;
class BPoint;
class BFont;
class BScrollBar;

class GManager;

struct linkInfo {
	linkInfo() { link = 0; offset = len = 0; };
	~linkInfo() { delete[] link; link = 0; };
	linkInfo( int32 off, int32 thelen, char* nlink )
	{ link = 0; Set( off, thelen, nlink ); };
	linkInfo( linkInfo& g )
	{ link = 0; Set(g.offset, g.len, g.link); };

	linkInfo* operator=( linkInfo& g )
	{ Set(g.offset, g.len, g.link); return this; };

	void Set( int32, int32, const char* link );
	int32 offset, len;
	char* link;
};

//=========================================================

struct textRunStyle {
	text_run run;
	bool variable;
	bool link;
};

//=========================================================

class FancyTextView : public BTextView {

	public:
		FancyTextView( BRect, const char*, GManager *the_manager , BRect, uint32 = B_FOLLOW_ALL, uint32 = B_WILL_DRAW | B_PULSE_NEEDED );
		virtual void InsertText(const char*, int32, int32, const text_run_array* ); 

		void AddStyledText( char*, styleList, bool=true );

		void SetShowFontColorSizes( bool );
		void SetShowLinks( bool );
		void SetAutoScrollEnabled( bool );
		void ScrollToBottom();
		
		void SetBaseFontAndColor( BFont& font, rgb_color& color, bool=true );
		void SetFontAttribute( int32 attrib, bool state );
		void SetFontColor( rgb_color color );
		void SetFontSize( int32 );
		void SetFontColor( int32, int32, int32 );
		void ClearInsertStuff();
		void ResetFontToBase();
		void AddStatement();
		void InsertSomeText( const char* text );
		bool IsEmpty() { return (TextLength() == 0); };
		BFont GetBaseFont() { return baseFont; };
		
		virtual void MouseMoved( BPoint where, uint32 code, const BMessage *msg );
		virtual void MouseDown( BPoint where );
		
		void Clear();

	private:
	
		void MakeRGBColor( gColor&, rgb_color& );
		void RebuildStyles();
		void RebuildLinks();
		uint32 StrLen( const char* );
		void Open( char* link );

		bool Empty;
		BFont baseFont;
		rgb_color baseColor;
		text_run insertstyle;
		BScrollBar* scroll;
		bool showFontColorSizes;
		bool showLinks;
		bool autoScrollEnabled;
		
		// to hold styles until everything is inserted
		GenList<text_run> insertStyles;
		
		// holds the text_run stuff
		GenList<textRunStyle> masterStyles;

		// hold links
		GenList<linkInfo> links;

		int32 curOffset;
		char insertText[FANCY_MESSAGE_MAX];
		bool styleChanged;
		char* message;
		
		GManager *mManager;
};

//=========================================================

#endif