#include <Debug.h>
#include "LoginBox.h"

#include <CheckBox.h>
#include <TextControl.h>
#include <MenuField.h>
#include <Menu.h>
#include <StringView.h>
#include <Box.h>
#include <Autolock.h>
#include <Locker.h>
#include <MenuItem.h>

#include <stdlib.h>

#include "GButton.h"
#include "Say.h"
#include "MiscStuff.h"
#include "BitmapView.h"
#include "GManager.h"
#include "Prefs.h"
#include "WindowManager.h"
#include "Gicq.h"
#include "classSoundMaster.h"
#include "ProtocolManager.h"
#include "Locale.h"

//=====================================================================

LoginWindow::LoginWindow(BRect aFrame, GManager *aManager)
 				: BWindow(aFrame, aManager -> _("title4"),
 									B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE )
{
	// load the saved rect if there is one
	
	PRINT(("LoginWindow::LoginWindow\n"));
	mManager = aManager;
	mLocale = mManager -> mLocale;
		
	if( mManager -> prefs ) {
		BPoint point = mManager -> prefs->ReadPoint( "lgpoint", aFrame.LeftTop(), true );
		aFrame.OffsetTo(point);
		if( mManager -> windows )
			mManager -> windows->AdjustFrame( aFrame );
		MoveTo( aFrame.LeftTop() );
	}

	BBitmap* mainlogo = NULL;
	
	mOrigRect = Bounds();
	
	// Set up the views

	GetBitmapFromResources( mainlogo, 42 , mLocale );
	BRect bframe = Bounds();
	bframe.bottom = 77;
	BitmapView *bview = new BitmapView( bframe, mainlogo );

	BRect aRect( Bounds() );
	aRect.top = bframe.bottom + 1;
	mLoginView = new LoginView(aRect, mManager);
	aRect = Bounds();
	aRect.bottom = 150;
	mProgressView = new LoginProgressView(aRect, mManager);
	mProgressView->Hide();
	
	aRect = mLoginView -> Bounds();
//	aRect = frame;
	aRect.top = 128;
	aRect.bottom = aRect.top + 31;
	aRect.left += 5;
	aRect.right -= 5;
	mCountView = new LoginCountdownView( aRect, mManager);
	
	// Now add them to the window
	AddChild( bview );
	AddChild( mLoginView );
	AddChild( mProgressView );
	mLoginView->AddChild( mCountView );
	mCountView->Hide();
	mLoginView->mUinField->MakeFocus(true);
	
	
	
	// load the login settings
	LoadLoginSettings();
}

//---------------------------------------------------------------------

LoginWindow::~LoginWindow() {
}

//---------------------------------------------------------------------

bool LoginWindow::QuitRequested()
{
	PRINT(("LoginWindow::QuitRequested\n"));
	bool should_quit = false;
	mManager -> windows -> CloseSignOnWindow(should_quit);
	if( mManager -> prefs )
		mManager -> prefs->WritePoint( "lgpoint", Frame().LeftTop(), true );

	SaveLoginSettings();
	return(true);
}

//---------------------------------------------------------------------

void LoginWindow::MessageReceived(BMessage* aMsg){
	BPoint point;
	BRect frame;
	
	switch(aMsg->what)
	{
		case 1511159:
			mCountView->StopCountdown();
			break;
	
		case GIMICQ_SIGN_ON:
			// added to not try to login while it's already happening
			mCountView->StopCountdown();
			mLoginView->mSignOnButton->SetEnabled(false);
			DoLogin();
			break;

#if 0
		case GIMICQ_NEW_USER:
			mManager -> windows->OpenNewUserBox();
			break;
#endif
		case GIMICQ_CANCEL_SIGN_ON:
			mManager -> icq -> PostMessage( new BMessage( ICQ_LOGOUT ) );
			SetProgressMode( false );
			break;
			
		case GIMICQ_SET_LOGIN_STEP_COUNT:	// set the number of steps in the progress bar
			break;
			
		case GIMICQ_LOGIN_STEP:
			if( aMsg->FindBool("update_text") )
				mProgressView->mCaption->SetText( aMsg->FindString("status") );
			break;

		case ICQ_LOGGED_OUT:
		case GIMICQ_LOGIN_FAILURE:
		{
			// turn off the deskbar icon
			BMessage* noDeskbarIcon = new BMessage(GIMICQ_TOGGLE_DESKBAR_ICON);
			noDeskbarIcon->AddBool( "enabled", false );
			mManager -> windows -> SendBuddyListMessage( noDeskbarIcon );
						
			// fix the progress bar, and display the reason
			SetProgressMode( false );
			//mManager -> sounds->PlaySound( WS_LOGOFF );
			break;
		}
		
		case ICQ_BAD_PASSWORD:
		{
			// turn off the deskbar icon
			BMessage* noDeskbarIcon = new BMessage(GIMICQ_TOGGLE_DESKBAR_ICON);
			noDeskbarIcon->AddBool( "enabled", false );
			mManager -> windows -> SendBuddyListMessage(noDeskbarIcon);
			
			// fix the progress bar, and display the reason
			SetProgressMode( false );
			mManager -> sounds->PlaySound( WS_LOGOFF );
			Say( _("text100") );
			break;
		}
		
		case ICQ_LOGIN_ERROR:
		{
			// turn off the deskbar icon
			BMessage* noDeskbarIcon = new BMessage(GIMICQ_TOGGLE_DESKBAR_ICON);
			noDeskbarIcon->AddBool( "enabled", false );
			mManager -> windows -> SendBuddyListMessage(noDeskbarIcon);
			
			// fix the progress bar, and display the reason
			SetProgressMode( false );
			mManager -> sounds->PlaySound( WS_LOGOFF );
			Say( _("text101") );
			break;
		}
			
		case GIMICQ_OPEN_PREFS:
			point = Frame().LeftTop();
			frame = BRect(0, 0, 340, 200);
			mManager -> windows->MakeDialogFrame( frame, point );
			point = frame.LeftTop();
			mManager -> windows->OpenPrefsWindow( true, &point );
			break;
			
		case PEOPLE_SELECTOR_MSG:
			mLoginView->LoadUserSettings( aMsg->FindInt32("index") );
			break;
			
		case LOGIN_COUNTDOWN_MSG:
			mCountView->Tick();
			break;
		
		case LOGIN_STOP_COUNTDOWN:
			mCountView->StopCountdown();
			break;
			
		case B_CANCEL:
			QuitRequested();
			Close();
			break;

		case LOGIN_RESET:
			break;

#if 0
		case ST_CONNECTED:
			DoLoginStep();
			break;
#endif
					
		default:
			BWindow::MessageReceived(aMsg);
	}
}

//---------------------------------------------------------------------

void LoginWindow::StopCountdown() {
	PRINT(("LoginWindow::StopCountdown\n"));
	mCountView->StopCountdown();
}

//---------------------------------------------------------------------

// the cancel function
void LoginWindow::DispatchMessage( BMessage* aMsg, BHandler* aHandler ) {

	// if it's a cancel key, post a B_CANCEL message
	if( aMsg->what == B_KEY_DOWN )
		if( aMsg->HasString("bytes") && aMsg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( new BMessage(B_CANCEL) );
			return;
		}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( aMsg, aHandler );
}

//---------------------------------------------------------------------

void LoginWindow::SetCountdownMode( bool mode ) {

	PRINT(("LoginWindow::SetCountdownMode\n"));
	// remake the window to show the countdown display
	if( mode ) {
		mLoginView->ResizeTo( mOrigRect.Width() , mOrigRect.Height() + mCountView -> Bounds().Height() );
		ResizeTo( mOrigRect.Width() , mOrigRect.Height() + mCountView -> Bounds().Height() );
		mCountView->Show();
		mLoginView->EnableControls(false);
		mCountView->mCancelButton->MakeFocus(true);
		mCountView->DoCountdown();
	}
	
	// turn off the countdown display and stop the countdown
	else { 
		mLoginView->ResizeTo( mOrigRect.Width() , mOrigRect.Height() );
		ResizeTo( mOrigRect.Width() , mOrigRect.Height() );
		mCountView->Hide();
		mLoginView->EnableControls(true);
		mLoginView->mUinField->MakeFocus(true);
	}
}

//---------------------------------------------------------------------

void LoginWindow::SetProgressMode( bool mode ) {

	PRINT(("LoginWindow::SetProgressMode\n"));
	// remake the window to show the countdown display
	if( mode ) {
		ResizeTo( mProgressView -> Bounds().Width(), mProgressView -> Bounds().Height() );
		mLoginView->Hide();
		mProgressView->Show();
		mProgressView->mCancelButton->MakeFocus(true);
		mProgressView->mCancelButton->MakeDefault(true);
	}

	// turn off the countdown display and stop the countdown
	else { 
		mLoginView->EnableControls(true);
		mLoginView -> ResizeTo( mOrigRect.Width() , mOrigRect.Height() );
		ResizeTo( mOrigRect.Width() , mOrigRect.Height() );
		mProgressView->Hide();
		mLoginView->Show();
		mLoginView->mUinField->MakeFocus(true);
		mLoginView->mSignOnButton->SetEnabled(true);
		mLoginView->mSignOnButton->MakeDefault(true);
		mManager -> LoggedIn = false;
	}
}

//---------------------------------------------------------------------

void LoginWindow::LoadLoginSettings() {
	
	PRINT(("LoginWindow::LoadLoginSettings\n"));
	unsigned lastLogin;
	
	// grab the name of the person who last logged in...
	// and if there was one, load their settings
	lastLogin = (unsigned)mManager -> prefs->ReadInt32( "lastlogin", 0, true );
	if( lastLogin != 0 )
		mLoginView->LoadUserSettings( lastLogin );

	// Now... if the auto-login check box is checked, then do the autologin
	if( mLoginView->mAutoLogin->Value() ) {
		if( strcmp( mLoginView->mPassword->Text(), "" ) != 0 )
			SetCountdownMode( true );
		else
			mLoginView->mPassword->MakeFocus(true);
	}
}

//---------------------------------------------------------------------

void LoginWindow::SaveLoginSettings() {

	PRINT(("LoginWindow::SaveLoginSettings\n"));
	uint32 uin;
	
	// Get and save the username, and let the user view save its own stuff
	uin = atoi( mLoginView->mUinField->Text() );
	if( uin ) {
		mManager -> prefs->WriteInt32( "lastlogin", uin, true );
		mLoginView->SaveUserSettings( uin );
	}
}

//---------------------------------------------------------------------

void LoginWindow::DoLogin() {

	PRINT(("LoginWindow::DoLogin\n"));

	// Host and port
	char icq_host[255];
	int32 icq_port = 0;	
	int32 prevStat = StatusB( (ICQStatus)mManager -> prefs->ReadInt32("status", IS_AVAILABLE ) );

	// save these settings and setup the window for the login
	SaveLoginSettings();
	
	uint32 uin = atoi( mLoginView->mUinField->Text() );

	// Open the prefs, buddylist, etc. for this user
	mManager -> p_comm -> SetProgramUser( uin );

	// read the host/port prefs
	mManager -> prefs -> ReadString( "icq_host", icq_host, "login.icq.com", 255, true );
	icq_port = mManager -> prefs -> ReadInt32( "icq_port", 5190, true );

	BMessage* sendMessage = new BMessage( ICQ_LOGIN );
	sendMessage->AddInt32( "UIN", uin );
	sendMessage->AddString( "PASSWORD", mLoginView->mPassword->Text() );
	sendMessage->AddInt32( "STATUS", prevStat );
	sendMessage->AddString( "HOST", icq_host );
	sendMessage->AddInt32( "PORT", icq_port );
	mManager -> icq -> PostMessage( sendMessage );

	SetProgressMode( true );
	DoLoginStep();

}

//---------------------------------------------------------------------

void LoginWindow::DoLoginStep() {

	PRINT(("LoginWindow::DoLoginStep\n"));

	mProgressView->mCaption->SetText( _("text102") );

}

//=====================================================================

LoginView::LoginView(BRect aRect, GManager *aManager)
	   	   : BView(aRect, "login_view", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW)
{
	PRINT(("LoginView::LoginView\n"));
	mManager = aManager;
	mLocale = mManager -> mLocale;
	
	SetViewColor( 216, 216, 216 );
	BBox* Divider;
	BString temp;
	BRect a_rect = Bounds();
	// Construct the views
	
	a_rect.bottom = a_rect.top + 2;	
	a_rect.left += 10;
	a_rect.right -= 10;
	Divider = new BBox( a_rect,"divider", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW, B_FANCY_BORDER);	
	
	temp = _("label40");
	temp += ":";
	a_rect = Bounds();
	a_rect.top += 10;
	a_rect.bottom = a_rect.top + 20;
	a_rect.left += 8;
	a_rect.right -= 25;
	mUinField = new BTextControl( a_rect, "screenname", temp.String() , "", NULL );
	mUinField->SetViewColor( 216, 216, 216 );
	mUinField->SetDivider( 75 );
	

	temp = _("label41");
	temp += ":";
	a_rect.top += mUinField -> Bounds().Height() + 5;
	a_rect.bottom = a_rect.top + 20;
	a_rect.right = Bounds().right - 8;
	mPassword = new BTextControl( a_rect, "password", temp.String() , "", NULL );
	mPassword->TextView()->HideTyping( true );
	mPassword->SetViewColor( 216, 216, 216 );
	mPassword->SetDivider( 75 );

	a_rect.top += mPassword -> Bounds().Height() + 5;
	a_rect.bottom = a_rect.top + 20;
	a_rect.right = Bounds().right - 97;
	mSavePassword = new BCheckBox( a_rect , "Save Password", _("label42") , NULL );
	mSavePassword->SetViewColor( 216, 216, 216 );

	a_rect.left = a_rect.right + 23;
	a_rect.right = Bounds().right - 2;
	mAutoLogin = new BCheckBox( a_rect , "autologin", _("label43") , NULL );		
	mAutoLogin->SetViewColor( 216, 216, 216 );
	
	a_rect.top += mAutoLogin -> Bounds().Height() + 9;
	a_rect.bottom = a_rect.top + 20;	
	a_rect.right = Bounds().right - 8;
	mSignOnButton = new GButton( a_rect , "loginbutton", _("button1") , new BMessage(GIMICQ_SIGN_ON), B_FOLLOW_RIGHT | B_FOLLOW_TOP);
	mSignOnButton -> MakeDefault( true );
	
	a_rect.left = 8;
	a_rect.right = a_rect.left + 50;		
	mSetupButton = new GButton( a_rect , "setupbutton", _("button2") , new BMessage(GIMICQ_OPEN_PREFS));
	
	MakeUserList();
	a_rect = Bounds();
	a_rect.right -= 7;
	a_rect.left = a_rect.right - 15;
	a_rect.top += 8;
	a_rect.bottom = a_rect.top + 19;
	mUserList = new BMenuField( a_rect , NULL, NULL, mUserMenu, true );

	// Now add them to the window
	AddChild( mUinField );
	AddChild( mUserList );
	AddChild( mPassword );
	AddChild( mSavePassword );
	AddChild( mAutoLogin );
	AddChild( mSetupButton );
	AddChild( mSignOnButton );
	AddChild( Divider );
	
	
	
}

//---------------------------------------------------------------------

void LoginView::LoadUserSettings( int32 index ) {

	PRINT(("LoginView::LoadUserSettings\n"));
	char userName[DISPLAY_NAME_MAX];
	unsigned uin;

	// is this the guest account?
	if( index == 0 ) {
		mSavePassword->SetValue( false );
		mAutoLogin->SetValue( false );
		mUinField->SetText( "" );
		mPassword->SetText( "" );
		return;
	}

	// Nope... so grab the user's name and call the other settings function
	strcpy( userName, mUserList->Menu()->ItemAt(index)->Label() );
	uin = atoi(userName);
	LoadUserSettings( uin );
}

//---------------------------------------------------------------------

void LoginView::LoadUserSettings( unsigned uin ) {

	PRINT(("LoginView::LoadUserSettings\n"));
	BString username;
	char password[50];
	bool autoLogin = false, savePassword = false;

	// grab the user's info
	mManager -> prefs->GetUserLoginParameters( uin, password, 50, autoLogin, savePassword );

	// set stuff up based on the info in the user file
	mSavePassword->SetValue( savePassword );
	mAutoLogin->SetValue( autoLogin );
	username = "";
	username << uin;
	mUinField->SetText( username.String() );

	if( savePassword ) {
		mPassword->SetText( password );
	}

}

//---------------------------------------------------------------------

void LoginView::SaveUserSettings( unsigned uin ) {

	PRINT(("LoginView::SaveUserSettings\n"));
	if( !uin )
		return;

	mManager -> prefs->LoadUserFile( uin );

	mManager -> prefs->WriteString( "password", "" );
	if( mSavePassword->Value() )
		mManager -> prefs->WriteString( "password", mPassword->Text() );

	mManager -> prefs->WriteBool( "autologin", mAutoLogin->Value() );
	mManager -> prefs->WriteBool( "savepassword", mSavePassword->Value() );
}

//---------------------------------------------------------------------

void LoginView::EnableControls( bool enabled ) {

	PRINT(("LoginView::EnableControls\n"));
	mSavePassword->SetEnabled( enabled );
	mAutoLogin->SetEnabled( enabled );
	mUinField->SetEnabled( enabled );
	mPassword->SetEnabled( enabled );
	mUserList->SetEnabled( enabled );
	mSetupButton->SetEnabled( enabled );
}

//---------------------------------------------------------------------

void LoginView::MakeUserList() {

	PRINT(("LoginView::MakeUserList\n"));
	BString name;
	uint32 uin = 0;
	bool ret = true;
	bool start = true;
	int32 msgID = 1;
	BMessage* selectMessage = new BMessage(PEOPLE_SELECTOR_MSG);
	selectMessage->AddInt32( "index", 0 );
	
	// add the guest item
	mUserMenu = new BMenu("");
	mUserMenu->AddItem( new BMenuItem( _("menuitem130") , selectMessage) );
	mUserMenu->AddSeparatorItem();

	// add the users
	while( ret ) {
		ret = mManager -> prefs->GetNextUser( uin, start );
		if( !ret ) break;		
		if( start )	start = false;
		if( uin == 0 )
			continue;
		name = "";
		name << uin;
		selectMessage = new BMessage(PEOPLE_SELECTOR_MSG);
		selectMessage->AddInt32( "index", ++msgID );
		mUserMenu->AddItem( new BMenuItem( name.String() , selectMessage) );
	}
}

//=====================================================================

LoginProgressView::LoginProgressView(BRect aRect, GManager *aManager)
	   	   : BView(aRect, "progress_view", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW)
{
	PRINT(("LoginProgressView::LoginProgressView\n"));
	mLocale = aManager -> mLocale;

	SetViewColor( 216, 216, 216 );
	mCaption = new BStringView( BRect(5,70,195,90), "caption", "" );
	mCaption->SetFontSize(12.0);
	
	mCancelButton = new GButton( BRect(75,103,125,123), "cancel", _("cancelbutton"), 
															new BMessage(GIMICQ_CANCEL_SIGN_ON), B_FOLLOW_H_CENTER | B_FOLLOW_BOTTOM );
	
	AddChild( mCaption );
	AddChild( mCancelButton );
}

void LoginProgressView::AttachedToWindow() {

	PRINT(("LoginProgressView::AttachedToWindow\n"));
	BString temp = _("text103");
	temp += B_UTF8_ELLIPSIS;
	mCaption->SetText( temp.String() );
}

//=====================================================================

LoginCountdownView::LoginCountdownView(BRect aRect, GManager *aManager)
	   	   : BView(aRect, "count_view", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW)
{
	PRINT(("LoginCountdownView::LoginCountdownView\n"));
	mLocale = aManager -> mLocale;
	
	BString temp;
	BRect a_rect = Bounds();
	// Bounds() = 5,206,196,237
	mLock = new BLocker();
	SetViewColor( 216, 216, 216 );
	BBox *box = new BBox( Bounds() );
	
	a_rect.right -= 10;
	a_rect.left = a_rect.right - 50;
	a_rect.top = 3;
	a_rect.bottom = a_rect.top + 20;
	mCancelButton = new GButton( a_rect, "cancel", _("cancelbutton") , new BMessage(LOGIN_STOP_COUNTDOWN) , B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM  );
	
	temp = _("text104");
	temp += B_UTF8_ELLIPSIS;
	a_rect = Bounds();
	a_rect.left += 7;
	a_rect.right -= mCancelButton -> Bounds().Width() + 2;
	a_rect.top += 4;
	a_rect.bottom = a_rect.top + 20; 
	mCaption = new BStringView( a_rect , "caption", temp.String() );
	mCaption->SetFontSize(10.0);

	AddChild( mCancelButton );

	AddChild( box );
	AddChild( mCaption );
}

//---------------------------------------------------------------------

void LoginCountdownView::DoCountdown() {

	PRINT(("LoginCountdownView::DoCountdown\n"));
	// default is 3 seconds... should probably make an option for this
	mCounter = 3;

	// make the thread and do the first tick
			thread_id count_thread = spawn_thread( counter_thread_entry, "countdown_thread", B_LOW_PRIORITY, this );
	if( count_thread <= 0 )
		Say( _("text105") );
	else {
		resume_thread( count_thread );
		Tick();
	}
}

//---------------------------------------------------------------------

void LoginCountdownView::StopCountdown() {

	PRINT(("LoginCountdownView::StopCountdown\n"));
	BAutolock a(mLock);
	//beep();

	mShouldExit = true;
	
	// Remake the window to hide this view
	LoginWindow* window = dynamic_cast<LoginWindow*>( Window() );
	window->SetCountdownMode( false );
}

//---------------------------------------------------------------------

void LoginCountdownView::Tick() {

	PRINT(("LoginCountdownView::Tick\n"));
	BAutolock a(mLock);
	BString label;
	LoginWindow* parent_window = dynamic_cast<LoginWindow*>(Window());
	
	if( mCounter > 0 ) {
		label = _("text106");
		label += " ";
		label << mCounter;
		label += " ";
		if(mCounter == 1)
			label += _("text107");
		else
			label += _("text108");

		mCaption->SetText( label.String() );
	} else {
	
		// Do the login
		mShouldExit = true;
		parent_window->DoLogin();
	}

	mCounter--;
}

//---------------------------------------------------------------------

int32 LoginCountdownView::counter_thread_entry( void *arg ) {

	PRINT(("LoginCountdownView::count_threa_entry\n"));
	LoginCountdownView* this_class = (LoginCountdownView*)arg;
	return this_class->do_count();
}

//---------------------------------------------------------------------

int32 LoginCountdownView::do_count() {

	PRINT(("LoginCountdownView::do_count\n"));
	// sleep for one second, then send a tick message
	mShouldExit = false;
	while( !mShouldExit ) {
		snooze( 1000000 );
		if(mShouldExit)
			return 0;
		
		Window() -> LockLooper();
		Window()->PostMessage( new BMessage(LOGIN_COUNTDOWN_MSG) );
		Window() -> UnlockLooper();
	}
	return 0;
}
		
//=====================================================================
