#ifndef LOGIN_BOX_H
#define LOGIN_BOX_H

#include <Window.h>
#include <View.h>

class BCheckBox;
class BTextControl;
class BMenuField;
class BMenu;
class BStringView;
class BBox;
class BLocker;

class GButton;
class GManager;
class Locale;
class BitmapView;

const uint32 PEOPLE_SELECTOR_MSG = 'psbs';
const uint32 LOGIN_COUNTDOWN_MSG = 'BOOM';
const uint32 LOGIN_STOP_COUNTDOWN = 'sTc?';
const uint32 LOGIN_RESET		  = 'lRST';

//=====================================================================

// The LoginView class
class LoginView : public BView 
{
	friend class LoginWindow;	// kludge

	public:
		LoginView(BRect aRect, GManager *aManager);
		
		void EnableControls( bool );
		
	private:
		void MakeUserList();
		void LoadUserSettings( int32 index );
		void LoadUserSettings( unsigned uin );
		void SaveUserSettings( unsigned uin );
	
		BTextControl *mUinField;
		BTextControl *mPassword;
		BCheckBox *mSavePassword;
		BCheckBox *mAutoLogin;
		GButton *mSignOnButton;
		GButton *mSetupButton;
		BMenuField *mUserList;
		BMenu *mUserMenu;
		
		Locale *mLocale;
		GManager *mManager;
};

//=====================================================================

// The LoginProgressView class
class LoginProgressView : public BView 
{
	friend class LoginWindow;	// kludge

	public:
		LoginProgressView(BRect aRect, GManager *aManager);
		void AttachedToWindow();

	private:
		GButton *mCancelButton;
		BStringView *mCaption;
		
		Locale *mLocale;
};

//=====================================================================

// The LoginCountdownView class
class LoginCountdownView : public BView 
{
friend class LoginWindow;	// kludge

public:
	LoginCountdownView(BRect aRect, GManager *aManager);

private:
	
	// counter thread stuff
	void DoCountdown();
	void StopCountdown();
	void Tick();
	static int32 counter_thread_entry( void *arg );
	int32 do_count();

	GButton *mCancelButton;
	BStringView *mCaption;
	BLocker *mLock;
	int mCounter;
	
	volatile bool mShouldExit;
	
	Locale *mLocale;
};

//=====================================================================

// The Window class
class LoginWindow : public BWindow 
{
	public:
		LoginWindow(BRect aFrame, GManager *aManager);
		~LoginWindow();
		
		virtual	bool QuitRequested();
		virtual void MessageReceived(BMessage *aMsg );
		virtual void DispatchMessage( BMessage *aMsg, BHandler *aHandler );
		
		void StopCountdown();
		void SetCountdownMode( bool );
		void SetProgressMode( bool );
		void DoLogin();

	private:

		BRect mOrigRect;

		void LoadLoginSettings();
		void SaveLoginSettings();		
		void DoLoginStep();
	
		LoginView *mLoginView;
		LoginProgressView *mProgressView;
		LoginCountdownView *mCountView;

		Locale *mLocale;
		GManager *mManager;
};

//=====================================================================

#endif //LOGIN_BOX_H
