#ifndef _NOTES_EDITOR_H_
#define _NOTES_EDITOR_H_

#include <Window.h>

class BMessage;
class BHandler;
class BView;
class BScrollView;
class BStringView;

class GButton;
class GManager;

class NotesEditor : public BWindow
{
	protected:
		BView			*windowBack;
		BScrollView		*listFilesScroll;
		GButton* SaveButton;
		GButton* CancelButton;
		
		BTextView* notes;
		BScrollView* notes_scroller;		
		BStringView* notesLabel;

		virtual bool QuitRequested();
		virtual void DispatchMessage( BMessage* msg, BHandler* handler );
	
	public:
		NotesEditor( BRect, unsigned u, const char* nick, GManager *the_manager );
		void MessageReceived( BMessage * );
		
	private:
		void Save();
		void LoadNotes();
		unsigned uin;
		
		GManager *mManager;
};

#endif
