#include <Debug.h>
#include "PasswordChanger.h"

#include <View.h>
#include <Box.h>
#include <String.h>
#include <TextControl.h>

#include "GButton.h"
#include "Say.h"
#include "GManager.h"
#include "WindowManager.h"
#include "Gicq.h"
#include "Locale.h"
#include "ProtocolManager.h"

PasswordChanger::PasswordChanger( BRect frame, GManager *aManager )
								: BWindow( frame, "Change Password", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE )
{

	mManager = aManager;
	mLocale = mManager -> mLocale;
	
	BString temp;
	
	BView			*windowBack = new BView( Bounds(), "windowBack", B_FOLLOW_ALL_SIDES, B_WILL_DRAW );
	windowBack -> SetViewColor( 216, 216, 216 );
	AddChild( windowBack );
	BRect bounds = windowBack->Bounds();

	
	temp = _("label70");
	temp += ":";
	mPassword1 = new BTextControl(BRect(7, 10, bounds.right - 7, 30), "nick", temp.String() , "", 0);
	mPassword1->TextView()->HideTyping( true );
	mPassword1->SetFont(be_bold_font);
	mPassword1->SetFontSize(11);
	mPassword1->SetDivider(90);
	windowBack->AddChild( mPassword1 );
	
	temp = _("label71");
	temp += ":";
	mPassword2 = new BTextControl(BRect(7, 35, bounds.right - 7, 55), "first", temp.String() , "", 0);
	mPassword2->TextView()->HideTyping( true );
	mPassword2->SetFont(be_bold_font);
	mPassword2->SetFontSize(11);
	mPassword2->SetDivider(90);
	windowBack->AddChild( mPassword2 );

	BRect a_rect = Bounds();
	a_rect.right -= 5;
	a_rect.left = a_rect.right - 80;
	a_rect.bottom -= 10;
	a_rect.top = a_rect.bottom - 20;	
	GButton *cancelButton = new GButton( a_rect , "cancel",_("cancelbutton") , new BMessage(B_CANCEL) );
	cancelButton->SetTarget(this); 
	windowBack->AddChild( cancelButton );

	a_rect.right -= cancelButton -> Bounds().Width() + 7;
	a_rect.left = a_rect.right - 80;
	GButton *saveButton = new GButton(	a_rect , "save", _("savebutton") , new BMessage(B_OK) );
	saveButton->SetTarget(this);
	saveButton->MakeDefault(true);
	windowBack->AddChild( saveButton );


	BBox* divider = new BBox(BRect(11,65,bounds.right-11,67),"divider", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW, B_FANCY_BORDER);	
	windowBack->AddChild( divider );
	mPassword1->MakeFocus(true);
}


void PasswordChanger::MessageReceived( BMessage *aMsg )
{
	switch( aMsg->what )
	{

		case B_OK:
			if( !Save() )
				break;
			
		case B_CANCEL:
			PostMessage( new BMessage(B_QUIT_REQUESTED) );
			break;

		default:
			BWindow::MessageReceived(aMsg);
			break;
	};
}

bool PasswordChanger::QuitRequested()
{
	mManager -> windows -> CloseGeneralWindow(this);

	return(true);
}


// the cancel function
void PasswordChanger::DispatchMessage( BMessage* aMsg, BHandler* aHandler ) {

	// if it's a cancel key, post a B_CANCEL message
	if( aMsg->what == B_KEY_DOWN )
		if( aMsg->HasString("bytes") && aMsg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( new BMessage(B_CANCEL) );
			return;
		}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( aMsg, aHandler );
}


bool PasswordChanger::Save() {

	if( strcmp( mPassword1->Text() , mPassword2->Text() ) != 0 ) {
		Say( _("label120") );
		mPassword1->MakeFocus(true);
		return false;
	}
	
	BMessage* msg = new BMessage( ICQ_UPDATE_PASSWORD );
	msg->AddString( "PASSWORD", mPassword1->Text() );
	mManager -> icq -> PostMessage( msg );
	return true;
}

