#include <Debug.h>
#include "PrefsWindow.h"

#include <CheckBox.h>
#include <TextControl.h>
#include <PopUpMenu.h>
#include <UTF8.h>
#include <MenuField.h>
#include <MenuItem.h>
#include <Box.h>
#include <ListView.h>
#include <ScrollView.h>
#include <StringView.h>
#include <Directory.h>
#include <Entry.h>
#include <Path.h>

#include "GButton.h"
#include "GManager.h"
#include "Prefs.h"
#include "WindowManager.h"
#include "Locale.h"

//-------------------------------------------------------------------------------------------------------


GenPrefView::GenPrefView(BRect rect, GManager *the_manager, bool go)
	   	   : PrefsView(rect, "GenPrefsTab", the_manager )
{
	
	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;
		
	BString temp;
	SetViewColor( 216, 216, 216 );
	globalOnly = go;
	
	// Show Buddy list in all workspaces
	BRect CheckRect = BRect(4,4,20,20);
	BuddyListAllWorkspaces = new BCheckBox( CheckRect, "", _("text130"),  NULL );
	BuddyListAllWorkspaces->ResizeToPreferred();
	BuddyListAllWorkspaces->SetEnabled( !globalOnly );
	AddChild( BuddyListAllWorkspaces );	
	
	// Play sound effects or not
	CheckRect.top += 20;
	PlaySounds = new BCheckBox( CheckRect, "", _("text131"),  NULL );
	PlaySounds->ResizeToPreferred();
	PlaySounds->SetEnabled( !globalOnly );
	AddChild( PlaySounds );

	// enable the GIMICQ Deskbar Icon
	CheckRect.top += 20;
	DoIdleTime = new BCheckBox( CheckRect, "", _("text132"),  NULL );
	DoIdleTime->ResizeToPreferred();
	DoIdleTime->SetEnabled( !globalOnly );
	AddChild( DoIdleTime );

	// enable the GIMICQ Deskbar Icon
	CheckRect.top += 20;
	DoDeskbarIcon = new BCheckBox( CheckRect, "", _("text133"),  new BMessage(DESKBAR_ICON_ENABLED) );
	DoDeskbarIcon -> ResizeToPreferred();
	DoDeskbarIcon -> SetEnabled( !globalOnly );
	AddChild( DoDeskbarIcon );

	// enable the GIMICQ Deskbar Icon
	CheckRect.top += 20;
	BRect cr2 = CheckRect;
	cr2.left += 20;
	FlashDeskbarIcon = new BCheckBox( cr2, "", _("text134"),  NULL );
	FlashDeskbarIcon->ResizeToPreferred();
	FlashDeskbarIcon->SetEnabled( !globalOnly );
	AddChild( FlashDeskbarIcon );

	// encoding popup (oh boy)...
	useEncoding = new BPopUpMenu( _("menu4") );
	useEncoding->SetRadioMode( true );
	BMessage* encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_ISO2_CONVERSION );
	useEncoding->AddItem(e1 = new BMenuItem( _("menuitem110") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_ISO5_CONVERSION );
	useEncoding->AddItem(e2 = new BMenuItem( _("menuitem111") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_KOI8R_CONVERSION );
	useEncoding->AddItem(e3 = new BMenuItem( _("menuitem112") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_MS_DOS_866_CONVERSION );
	useEncoding->AddItem(e4 = new BMenuItem( _("menuitem113") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_MS_WINDOWS_1251_CONVERSION );
	useEncoding->AddItem(e5 = new BMenuItem( _("menuitem114") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_ISO7_CONVERSION );
	useEncoding->AddItem(e6 = new BMenuItem( _("menuitem115") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_SJIS_CONVERSION );
	useEncoding->AddItem(e7 = new BMenuItem( _("menuitem116") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_EUC_CONVERSION );
	useEncoding->AddItem(e8 = new BMenuItem( _("menuitem117") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_UNICODE_CONVERSION );
	useEncoding->AddItem(e9 = new BMenuItem( _("menuitem118") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_ISO1_CONVERSION );
	useEncoding->AddItem(e10 = new BMenuItem( _("menuitem119") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_MAC_ROMAN_CONVERSION );
	useEncoding->AddItem(e11 = new BMenuItem( _("menuitem120") , encMsg) );
	encMsg = new BMessage(GIMICQ_CHANGE_ENCODING);
	encMsg->AddInt32( "encoding", (int32)B_MS_WINDOWS_CONVERSION );
	useEncoding->AddItem(e12 = new BMenuItem( _("menuitem121") , encMsg) );
	
	// now make the menufield
	CheckRect.top += 20;
	CheckRect.right = Bounds().right;
	temp = _("menu5");
	temp += ":";
	EncodingMenuField = new BMenuField( CheckRect, "encoding", temp.String() , useEncoding );
	EncodingMenuField->SetDivider( 90 );
	EncodingMenuField->SetEnabled( !globalOnly );
	AddChild( EncodingMenuField );

	// Now initialize them
	BuddyListAllWorkspaces->SetValue( mManager -> prefs->ReadBool("bl_aw", true) );
	PlaySounds->SetValue( mManager -> prefs->ReadBool("gm_ps", true) );
	DoIdleTime->SetValue( mManager -> prefs->ReadBool("gm_id", true) );
	DoDeskbarIcon->SetValue( mManager -> prefs->ReadBool("gm_di", true) );
	FlashDeskbarIcon->SetValue( mManager -> prefs->ReadBool("gm_fl", true) );
	SetDBStuffOn();
	SetEncoding( (uint32)mManager -> prefs -> ReadInt32("def_encoding", (int32)B_MS_WINDOWS_CONVERSION ) );
}


void GenPrefView::AllAttached(){

	useEncoding -> SetTargetForItems( this );
	DoDeskbarIcon -> SetTarget( this );
}

void GenPrefView::MessageReceived(BMessage *msg){

	switch(msg -> what) {
	
	case GIMICQ_CHANGE_ENCODING:
		SetEncoding( (uint32)msg->FindInt32("encoding") );
		break;

	case DESKBAR_ICON_ENABLED:
		SetDBStuffOn();
		break;

	default:
		PrefsView::MessageReceived( msg );
		break;		
	}

}

void GenPrefView::Save() {

	// save the prefs
	if( !globalOnly ) {
		mManager -> prefs->WriteBool("bl_aw", BuddyListAllWorkspaces->Value() );
		mManager -> prefs->WriteBool("gm_ps", PlaySounds->Value() );
		mManager -> prefs->WriteBool("gm_id", DoIdleTime->Value() );
		mManager -> prefs->WriteInt32( "def_encoding", (int32)encoding );
		mManager -> prefs->WriteBool("gm_di", DoDeskbarIcon->Value() );
		mManager -> prefs->WriteBool("gm_fl", FlashDeskbarIcon->Value() );
	}
}


void GenPrefView::SetEncoding( uint32 enc ) {

	// set the encoding
	printf("encoding: %lu\n", enc);
	encoding = enc;
	switch( encoding ) {
		case B_ISO2_CONVERSION:
			e1->SetMarked(true);
			break;
		case B_ISO5_CONVERSION:
			e2->SetMarked(true);
			break;
		case B_KOI8R_CONVERSION:
			e3->SetMarked(true);
			break;
		case B_MS_DOS_866_CONVERSION:
			e4->SetMarked(true);
			break;
		case B_MS_WINDOWS_1251_CONVERSION:
			e5->SetMarked(true);
			break;
		case B_ISO7_CONVERSION:
			e6->SetMarked(true);
			break;
		case B_SJIS_CONVERSION:
			e7->SetMarked(true);
			break;
		case B_EUC_CONVERSION:
			e8->SetMarked(true);
			break;
		case B_UNICODE_CONVERSION:
			e9->SetMarked(true);
			break;
		case B_ISO1_CONVERSION:
			e10->SetMarked(true);
			break;
		case B_MAC_ROMAN_CONVERSION:
			e11->SetMarked(true);
			break;
		case B_MS_WINDOWS_CONVERSION:
			e12->SetMarked(true);
			break;
	}
}


void GenPrefView::SetDBStuffOn() {

	if( !globalOnly ) {
		if( DoDeskbarIcon->Value() )
			FlashDeskbarIcon->SetEnabled( true );
		else {
			FlashDeskbarIcon->SetEnabled( false );
			FlashDeskbarIcon->SetValue( false );
		}
	}
}

//-------------------------------------------------------------------------------------------------------


ConnectionPrefView::ConnectionPrefView(BRect rect, GManager *the_manager, bool go)
	   	   : PrefsView(rect, "ConPrefsTab", the_manager )
{

	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;
	
	BString temp;
	
	SetViewColor( 216, 216, 216 );
	BBox* serverBox;
	char hostName[255];
	char portName[50];
	globalOnly = go;

	// Add the server group box
	serverBox = new BBox( BRect(8,4,250,82) );
	serverBox->SetLabel( _("label80") );
	AddChild( serverBox );

	// set up the server text boxes
	temp << _("label81") << ":";
	conHost = new BTextControl( BRect(15,20,225,40), "hostname", temp.String(), "", NULL );
	conHost->SetViewColor( 216, 216, 216 );
	conHost->SetDivider( 50 );
	
	temp = "";
	temp << _("label82") <<  ":";
	conPort = new BTextControl( BRect(15,45,225,65), "portname", temp.String(), "", NULL );
	conPort->SetViewColor( 216, 216, 216 );
	conPort->SetDivider( 50 );
		
	// add them
	serverBox->AddChild( conHost );
	serverBox->AddChild( conPort );

	// now initialize them
	mManager -> prefs->ReadString( "icq_host", hostName, "login.icq.com", 255, true );
	conHost->SetText( hostName );
	sprintf( portName, "%lu", mManager -> prefs->ReadInt32("icq_port", 5190, true) );
	conPort->SetText( portName );


	reconnect_box = new BCheckBox( BRect(4,90,250,110 ), "", _("text220") ,  NULL );
	AddChild( reconnect_box );
	reconnect_box -> SetValue( mManager -> prefs -> ReadBool("reconnect", true, true ) );	
	
}


void ConnectionPrefView::Save() {

	int32 port = 0;

	sscanf( conPort->Text(), "%lu", &port );

	mManager -> prefs -> WriteString( "icq_host", const_cast<char *>(conHost->Text()) , true );
	mManager -> prefs -> WriteInt32( "icq_port", port, true );
	mManager -> prefs -> WriteBool("reconnect", reconnect_box -> Value() , true );

}


//-------------------------------------------------------------------------------------------------------


ChatWindowPrefView::ChatWindowPrefView(BRect rect, GManager *the_manager, bool go)
	   	   : PrefsView(rect, "ChatPrefsTab", the_manager )
{
	
	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;

	SetViewColor( 216, 216, 216 );
	globalOnly = go;

	// Show chat windows in all workspaces
	BRect CheckRect = BRect(4,4,20,20);
	ChatWindowAllWorkspaces = new BCheckBox( CheckRect, "", _("text140") ,  NULL );
	ChatWindowAllWorkspaces->ResizeToPreferred();
	ChatWindowAllWorkspaces->SetEnabled( !globalOnly );
	AddChild( ChatWindowAllWorkspaces );

	// Popup the chat window when a message is received
	CheckRect.top += 20;
	ChatWindowPopup = new BCheckBox( CheckRect, "", _("text141") ,  NULL );
	ChatWindowPopup->ResizeToPreferred();
	ChatWindowPopup->SetEnabled( !globalOnly );
	AddChild( ChatWindowPopup );

	// Show URL/mailto links by default
	CheckRect.top += 20;
	ChatShowLinks = new BCheckBox( CheckRect, "", _("text142") ,  NULL );
	ChatShowLinks->ResizeToPreferred();
	ChatShowLinks->SetEnabled( !globalOnly );
	AddChild( ChatShowLinks );
	
	// Prefix incoming messages with '>' in the title bar
	CheckRect.top += 20;
	ChatPrefixNewMessages = new BCheckBox( CheckRect, "", _("text143") ,  NULL );
	ChatPrefixNewMessages->ResizeToPreferred();
	ChatPrefixNewMessages->SetEnabled( !globalOnly );
	AddChild( ChatPrefixNewMessages );
	
	//ChatPrefixNewMessages = new BCheckBox( CheckRect, "", "Use Mod+Enter to send (Enter inserts a newline instead)",  NULL );
	
	// Funky behavior where enter inserts a newline instead of sending a message
	CheckRect.top += 20;
	ChatEnterIsNewline = new BCheckBox( CheckRect, "", _("text144") ,  NULL );
	ChatEnterIsNewline->ResizeToPreferred();
	ChatEnterIsNewline->SetEnabled( !globalOnly );
	AddChild( ChatEnterIsNewline );	
	
	// Close the chat window after sending a message
	CheckRect.top += 20;
	ChatCloseAfterSend = new BCheckBox( CheckRect, "", _("text145") ,  NULL );
	ChatCloseAfterSend->ResizeToPreferred();
	ChatCloseAfterSend->SetEnabled( !globalOnly );
	AddChild( ChatCloseAfterSend );


	// now initialize them
	ChatWindowAllWorkspaces->SetValue( mManager -> prefs->ReadBool("cw_aw", false) );
	ChatWindowPopup->SetValue( mManager -> prefs->ReadBool("cw_pu", false) );
	ChatShowLinks->SetValue( mManager -> prefs->ReadBool("cw_lk", true) );
	ChatPrefixNewMessages->SetValue( mManager -> prefs->ReadBool( "cw_p>", false ) );
	ChatEnterIsNewline->SetValue( mManager -> prefs->ReadBool( "cw_en", true ) );
	ChatCloseAfterSend->SetValue( mManager -> prefs->ReadBool( "cw_cs", false ) );

}


void ChatWindowPrefView::Save() {

	// save the prefs
	if( !globalOnly ) {
		mManager -> prefs->WriteBool("cw_aw", ChatWindowAllWorkspaces->Value() );
		mManager -> prefs->WriteBool("cw_pu", ChatWindowPopup->Value() );
		mManager -> prefs->WriteBool("cw_lk", ChatShowLinks->Value() );
		mManager -> prefs->WriteBool("cw_p>", ChatPrefixNewMessages->Value() );
		mManager -> prefs->WriteBool("cw_en", ChatEnterIsNewline->Value() );
		mManager -> prefs->WriteBool("cw_cs", ChatCloseAfterSend->Value() );
	}
}


LocalePrefView::LocalePrefView(BRect rect, GManager *the_manager, bool go)
	   	   : PrefsView(rect, "LocalePrefsTab", the_manager )
{
	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;
	SetViewColor( 216, 216, 216 );
	BString str;
		
	BRect a_rect = Bounds();
	a_rect.top += 5;
	a_rect.left += 5;
	a_rect.bottom = a_rect.top + 15;
	str << _("text230") << ":";

	locale_info = new BStringView(a_rect, "locale_info", str.String() );

	a_rect.top = a_rect.bottom;
	a_rect.bottom = a_rect.top + 15;
	
	BString path_string;
	path_string << mManager->prefs->SettingDir().Path() << "/Locale";
	BStringView *path_view = new BStringView(a_rect, "path", path_string.String() );

	a_rect.top += 20;
	a_rect.bottom = Bounds().bottom - 40;
	a_rect.right = Bounds().right/2;
	language_list = new BListView(a_rect, "language_list");
	BScrollView *language_scroller = new BScrollView("language_scroller", language_list, B_FOLLOW_LEFT | B_FOLLOW_TOP_BOTTOM, 0, false, true);
	
	a_rect.top = a_rect.bottom + 5;
	a_rect.bottom = a_rect.top + 15;
	a_rect.right = Bounds().right;
	BStringView *download_view = new BStringView( a_rect, "download", _("text231") );

	a_rect.top = a_rect.bottom;
	a_rect.bottom = a_rect.top + 15;
	BStringView *restart_view = new BStringView( a_rect, "restart", _("text232") );

	FillLanguageList();
	AddChild(locale_info);
	AddChild(path_view);
	AddChild(language_scroller);
	AddChild(download_view);
	AddChild(restart_view);
}

void LocalePrefView::Save() {

	BString the_filename;
	
	int32 index = language_list -> CurrentSelection(); 	
	if(index < 0) 
		return;
	
	BStringItem *the_item = dynamic_cast<BStringItem *>( language_list -> ItemAt(index) );
	the_filename = the_item -> Text();
	
	mManager -> prefs -> WriteString("locale_file", the_filename.String(), true );

}

void LocalePrefView::FillLanguageList() {

	BDirectory locale_dir;
	BPath locale_path;
	BEntry locale_entry;
	BString path_string;
	BStringItem *locale_item;
	path_string << mManager->prefs->SettingDir().Path() << "/Locale";
	
	
	if( locale_dir.SetTo( path_string.String() ) != B_OK )
		return;
	
	locale_dir.Rewind();
	
	while( locale_dir.GetNextEntry( &locale_entry) != B_ENTRY_NOT_FOUND) {
	
		locale_path.SetTo( &locale_entry );
		locale_item = new BStringItem( locale_path.Leaf() );
		language_list -> AddItem( locale_item );
	
	}

}

//-------------------------------------------------------------------------------------------------------

PrefsItem::PrefsItem(PrefsView *the_view, const char *the_text)
					:BStringItem(the_text){

	// Setup View, set text for the View. i.e.    ---- General ----
	//																						|		the_view		|
	//																						-----------------
	view = the_view;

}

PrefsItem::~PrefsItem(){
	
	delete view;
	
}

void PrefsItem::Save(){

	view -> Save();
		
}
	
void PrefsItem::Show() {
	
	view -> Window() -> LockLooper();
	view -> Show();
	view -> Window() -> UnlockLooper();

}

void PrefsItem::Hide() {
	
	view -> Window() -> LockLooper();
	view -> Hide();
	view -> Window() -> UnlockLooper();

}

BView *PrefsItem::GetView() {

	return view;

}

PrefsWindow::PrefsWindow(BRect frame, GManager *the_manager, bool globalOnly)
			: BWindow(frame, "Gim-ICQ Preferences", B_TITLED_WINDOW, B_NOT_ZOOMABLE | B_NOT_RESIZABLE )
{

	BRect view_rect(15,15,350,140); // GO AWAY!!!
	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;
		
	BRect list_rect, box_rect;
		
	/* Add the basic background */
	BView* bg_view = new BView( Bounds(), "PrefView", B_FOLLOW_ALL_SIDES, B_WILL_DRAW | B_FULL_UPDATE_ON_RESIZE );
	bg_view->SetViewColor( 216, 216, 216 );
	AddChild( bg_view );


	/* Add the list_view control */
	list_rect = bg_view -> Bounds();
	list_rect.left +=	10;
	list_rect.top += 10;
	list_rect.right = list_rect.left + 100;
//	list_rect.bottom = list_rect.top + view_rect.bottom;
	list_rect.bottom -= 40;

	list = new BListView( list_rect , "prefs_list", B_SINGLE_SELECTION_LIST , B_FOLLOW_LEFT | B_FOLLOW_TOP_BOTTOM );
	list -> SetSelectionMessage( new BMessage(LIST_ITEM_SELECTED) );
	
	// Add the scroller to the list view
	BScrollView *list_scroller = new BScrollView( "prefs_list_scroll" , list , B_FOLLOW_LEFT | B_FOLLOW_TOP_BOTTOM , 0 , true , true );
	list_scroller->SetViewColor( 216, 216, 216 );
	bg_view->AddChild( list_scroller );
	


	/* Add Box View and the prefs views */
	box_rect = bg_view -> Bounds();
	box_rect.right -=	10;
	box_rect.top += 10;
	box_rect.left = list_rect.right + 25;
	box_rect.bottom = list_rect.bottom;
	
	box_view = new BBox(box_rect, "prefs_box", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP_BOTTOM);
	
	view_rect = box_view -> Bounds();
	view_rect.top += 15;
	view_rect.bottom -= 3;
	view_rect.left += 3;
	view_rect.right -= 3;
	
	PrefsView *gen_view = new GenPrefView( view_rect , mManager , globalOnly );
	PrefsView *con_view = new ConnectionPrefView( view_rect , mManager , globalOnly );
	PrefsView *cht_view = new ChatWindowPrefView( view_rect , mManager , globalOnly );
	PrefsView *loc_view = new LocalePrefView( view_rect, mManager, globalOnly );
	
	list -> AddItem( new PrefsItem( gen_view , _("label90") ) );
	list -> AddItem( new PrefsItem( cht_view , _("label91") ) );
	list -> AddItem( new PrefsItem( con_view , _("label92") ) );
	list -> AddItem( new PrefsItem( loc_view , _("label93") ) );

	bg_view -> AddChild( box_view );	
	


	/* Add buttons */
	BRect button_rect;
	button_rect.bottom = ( bg_view -> Bounds() ).bottom - 10;
	button_rect.top = button_rect.bottom - 20;
	button_rect.right = box_rect.right + 5;
	button_rect.left = button_rect.right - 60;

	GButton *btn_cancel = new GButton(button_rect, "Cancel", _("cancelbutton") , 
																		new BMessage(PREFS_CANCEL) , B_FOLLOW_BOTTOM | B_FOLLOW_RIGHT );

	button_rect.right = button_rect.right - btn_cancel -> Bounds().Width() - 7;
	button_rect.left = button_rect.right - 80;
	GButton *btn_save = new GButton(button_rect, "Save", _("savebutton") ,
																	new BMessage(PREFS_SAVE), B_FOLLOW_BOTTOM | B_FOLLOW_RIGHT);	
	btn_save->MakeDefault( true );
	bg_view->AddChild( btn_save );
	bg_view->AddChild( btn_cancel );	

	// Show View...
	UpdateBBox(0);
}


void PrefsWindow::MessageReceived( BMessage *aMsg ) {

	BMessage msg( GIMICQ_RELOAD_PREF_SETTINGS );
	switch( aMsg->what ) {
	
		case PREFS_SAVE:

			// have all the views save themselves
			for(int i = list -> CountItems()-1; i>=0;i--) {
				dynamic_cast<PrefsItem *>(list -> ItemAt(i)) -> Save();
			} 

			// send a message to all windows telling them to reload settings
			mManager->windows->BroadcastMessage( &msg );

		case B_CANCEL:
		case PREFS_CANCEL:
			QuitRequested();
			Close();
			break;
			
		case LIST_ITEM_SELECTED:
			UpdateBBox( aMsg -> FindInt32("index") );
			break;
		default:
			BWindow::MessageReceived( aMsg );
			break;
	}
}



bool PrefsWindow::QuitRequested()
{
	mManager -> windows -> CloseGeneralWindow(this);

	return(true);
}


// the cancel function
void PrefsWindow::DispatchMessage( BMessage* aMsg, BHandler* handler ) {

	// if it's a cancel key, post a B_CANCEL message
	if( aMsg->what == B_KEY_DOWN )
		if( aMsg->HasString("bytes") && aMsg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( B_CANCEL );
			return;
		}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( aMsg, handler );
}

void PrefsWindow::UpdateBBox(int index) {

	if(index < 0) 
		return;
		
	PrefsItem *the_item = dynamic_cast<PrefsItem *>( list -> ItemAt(index) );

	box_view -> Window() -> LockLooper();

	if(box_view -> CountChildren() > 0)
		box_view -> RemoveChild( box_view -> ChildAt(0) );
	
	list -> Select(index);
	box_view -> SetLabel( the_item -> Text() );
	box_view -> AddChild( the_item -> GetView() );
	box_view -> Invalidate();

	box_view -> Window() -> UnlockLooper();
}


