#ifndef _PREFERENCES_H_
#define _PREFERENCES_H_

#include <Window.h>
#include <ListItem.h>
#include <String.h>

#include "PrefsViewInterface.h"

class BCheckBox;
class BListView;
class BList;
class BMenuItem;
class BTextControl;
class BPopUpMenu;

class GManager;

const uint32 PREFS_SAVE = 'PrSv';
const uint32 PREFS_CANCEL = 'PrCl';
const uint32 DESKBAR_ICON_ENABLED = 'dEsk';

const uint32 LIST_ITEM_SELECTED = 'LInv';

class GenPrefView : public PrefsView
{
	public:
		GenPrefView(BRect frame, GManager *the_manager, bool globalOnly = false );
		virtual void Save();
		virtual void MessageReceived(BMessage *msg);
		virtual void AllAttached();
		
		void SetEncoding( uint32 encoding );
		void SetDBStuffOn();

	private:
		BCheckBox* BuddyListAllWorkspaces;
		BCheckBox* PlaySounds;
		BCheckBox* DoIdleTime;
		BCheckBox* DoDeskbarIcon;
		BCheckBox* FlashDeskbarIcon;
		BMenuField* EncodingMenuField;
		BPopUpMenu* useEncoding;
		BMenuItem* e1;
		BMenuItem* e2;
		BMenuItem* e3;
		BMenuItem* e4;
		BMenuItem* e5;
		BMenuItem* e6;
		BMenuItem* e7;
		BMenuItem* e8;
		BMenuItem* e9;
		BMenuItem* e10;
		BMenuItem* e11;
		BMenuItem* e12;
		
		uint32 encoding;
		bool globalOnly;
		
		GManager *mManager;
};


//-------------------------------------------------------------------------------------------------------

class ConnectionPrefView : public PrefsView
{
	public:
		ConnectionPrefView(BRect frame, GManager *the_manager, bool globalOnly = false);
		virtual void Save();

	private:
		BTextControl* conHost;
		BTextControl* conPort;
		BCheckBox* reconnect_box;
		bool globalOnly;
		
		GManager *mManager;
};


//-------------------------------------------------------------------------------------------------------

class ChatWindowPrefView : public PrefsView
{
	public:
		ChatWindowPrefView(BRect frame, GManager *the_manager, bool globalOnly = false);
		virtual void Save();

	private:
		BCheckBox* ChatWindowAllWorkspaces;
		BCheckBox* ChatWindowPopup;
		BCheckBox* ChatShowLinks;
		BCheckBox* ChatPrefixNewMessages;
		BCheckBox* ChatEnterIsNewline;
		BCheckBox* ChatCloseAfterSend;
		bool globalOnly;
		
		GManager *mManager;
};

class LocalePrefView : public PrefsView
{
	public:
		LocalePrefView(BRect frame, GManager *the_manager, bool globalOnly = false);
		virtual void Save();
	
	private:
		
		void FillLanguageList();
		
		BStringView *locale_info; // "Will change language at startup".
		BListView   *language_list;
		
		GManager *mManager;
		
};

class PrefsItem : public BStringItem {

public:
	PrefsItem(PrefsView *the_view, const char *the_text);
	~PrefsItem();
	
	void Save();
	void Show();
	void Hide();
	
	BView *GetView();
private:
	
	BString text;				/* text = new char[strlen(the_text)]; */
	PrefsView *view;

};

class PrefsWindow : public BWindow {

public:
	PrefsWindow(BRect frame, GManager *the_manager, bool globalOnly = false );
	
	void UpdateBBox(int index);
	
	virtual	bool QuitRequested();
	virtual void MessageReceived( BMessage *aMsg );
	virtual void DispatchMessage( BMessage* aMsg, BHandler* handler );

private:

	BBox *box_view;	
	BListView *list;				//List over "preference views".
	
	GManager *mManager;
};

#endif		// _PREFERENCES_H_