#ifndef RESULTS_WINDOW_H
#define RESULTS_WINDOW_H

#include <Window.h>
#include <View.h>
#include <String.h>

#include "CLVEasyItem.h"
#include "ColumnListView.h"

class BPopUpMenu;
class BStringView;
class BTextView;

class GButton;
class BetterScrollView;
class BarberPole;
class GManager;
class Locale;

const uint32 ENABLE_CONTEXT_BUTTONS = 'eCtx';

//=========================================================================

class StatusView : public BView 
{
	friend class ResultsView;
	friend class SearchResultsWindow;

	public:
		StatusView(BRect frame, GManager *the_manager);
		virtual void Draw( BRect );
		virtual void MouseDown( BPoint cursor );
		
		void SetFoundAnother();
		void SetDone( bool more );
		
	private:
		BPopUpMenu* userPopup;
		int found;
		bool searching;
		BString showString;

		GManager *mManager;
		Locale *mLocale;
};

//=========================================================================

class SearchItem : public CLVEasyItem
{ 
	public: 
		SearchItem( const char *s, bool f = false ) : CLVEasyItem() {};
		bool fake;
};

//=========================================================================

class ResultsListView : public ColumnListView
{
	public:
		ResultsListView( BRect, BetterScrollView** , GManager *the_manager);
		~ResultsListView();
		virtual void MouseDown( BPoint cursor );
		virtual void SelectionChanged();

	private:
		BPopUpMenu* userPopup;

		GManager *mManager;
};

//=========================================================================

class ResultsView : public BView 
{
	friend class SearchResultsWindow;

	public:
		ResultsView( BRect frame, const char *name , GManager *the_manager);
		virtual void Pulse();
		
	private:
		BStringView* resLabel;
		ResultsListView* lview;
		BetterScrollView* container;
		GButton* closeButton;
		GButton* addToListButton;
		GButton* infoButton;
		
		CLVColumn* columnUIN;
		CLVColumn* columnNick;
		CLVColumn* columnFirst;
		CLVColumn* columnLast;
		CLVColumn* columnEmail;
		CLVColumn* columnReqAck;

		GManager *mManager;
};


//=========================================================================

class SearchResultsWindow : public BWindow
{
	public:

		SearchResultsWindow( BRect frame, GManager *the_manager ); 
		virtual	bool QuitRequested();
		virtual void MessageReceived( BMessage* );
		
		virtual void DispatchMessage( BMessage* msg, BHandler* handler );
				
	private:
	
		void SetupNewSearch( BMessage* msg );
		void ParseIncomingResults( BMessage* );

		ResultsView* resView;
		StatusView* statView;
		BTextView* resLabel;
		BarberPole* spinner;
		bool empty;
		
		GManager *mManager;
		Locale *mLocale;
};

//=========================================================================

#endif //HELLO_WINDOW_H
