#include <Debug.h>
#include "KDeskbar.h"

#include <Roster.h>
#include <Application.h>
#include <Messenger.h>
#include <View.h>
#include <Window.h>
#include <Shelf.h>

#include <cstring>

#include "GConstants.h"

const bigtime_t kTimeout = 1000000;	// 1 sec.

KDeskbar* KDeskbar::sInstance = NULL;

//----------------------------------------------------------------------

KDeskbar::KDeskbar()
  : mTimeout(kTimeout)
{

	app_info aInfo;

	be_app->GetAppInfo(&aInfo);
	if (strcasecmp(DESKBAR_SIGNATURE, aInfo.signature) == 0) {
		mIsLocal = true;
	} else {
		mIsLocal = false;
	}
}


//----------------------------------------------------------------------

KDeskbar*
KDeskbar::Instance()
{

	if (sInstance == NULL)
		sInstance = new KDeskbar();

	return sInstance;
}


//----------------------------------------------------------------------

status_t
KDeskbar::AddReplicant(const BView* view, bool force)
{

	if (view == NULL)
		return B_ERROR;

	if (!force && (CountReplicant(view->Name()) != 0))
		return B_ERROR;

	status_t aErr = B_OK;

	BMessage aMessage(B_ARCHIVED_OBJECT);

	aErr = view->Archive(&aMessage);
	if (aErr != B_OK)
		return aErr;

	BMessenger aDeskbar(DESKBAR_SIGNATURE, -1, &aErr);
	if (aErr != B_OK)
		return aErr;

	aErr = aDeskbar.SendMessage(&aMessage, (BHandler*)NULL, mTimeout);

	return aErr;
}


//----------------------------------------------------------------------

status_t
KDeskbar::RemoveReplicant(const char* name)
{

	BMessage aMessage(B_DELETE_PROPERTY);
	BMessage aSpecifier(B_NAME_SPECIFIER);
	BMessage aReply;
	status_t aErr = B_OK;

	aSpecifier.AddString("name", name);
	aSpecifier.AddString("property", "Replicant");
	aMessage.AddSpecifier(&aSpecifier);

	aErr = Shelf().SendMessage(&aMessage, (BHandler*)NULL, mTimeout);

	return aErr;
}


//----------------------------------------------------------------------

status_t KDeskbar::TalkToReplicant( BMessage* msg )
{

	BMessage aReply;
	status_t aErr = B_OK;

	msg->AddInt32( "what2", msg->what );
	msg->what = B_SET_PROPERTY;
	msg->AddSpecifier( "View" );
	msg->AddSpecifier( "Replicant", kViewName );
	aErr = Shelf().SendMessage( msg, (BHandler*)NULL, mTimeout );
	return 0;
}

//----------------------------------------------------------------------

int32
KDeskbar::CountReplicant(const char* name)
{

	int32 aResult = 0;
	BMessenger aShelf = Shelf();

	if (name == NULL) {
		BMessage aMessage(B_COUNT_PROPERTIES);
		BMessage aSpecifier(B_DIRECT_SPECIFIER);

		aSpecifier.AddString("property", "Replicant");
		aMessage.AddSpecifier(&aSpecifier);

		BMessage aReply;

		if (aShelf.SendMessage(&aMessage, &aReply, mTimeout, mTimeout) == B_OK)
			aReply.FindInt32("result", &aResult);
	} else {
		const char *aString;

		for (int i = 0; ; i++) {
			BMessage aMessage(B_GET_PROPERTY);

			aMessage.AddSpecifier("Name");
			aMessage.AddSpecifier("Replicant", i);

			BMessage aReply;
			status_t aErr;

			aErr = aShelf.SendMessage(&aMessage, &aReply, mTimeout, mTimeout);
			if (aErr != B_OK) {
//				printf("error = %ld\n", aErr);
				break;
			}

			switch (aReply.what) {
			  case B_REPLY:
				aReply.FindString("result", &aString);  
 				if (strcasecmp(aString, name) == 0)
					aResult += 1;
				break;
			  case B_MESSAGE_NOT_UNDERSTOOD:
				aReply.FindInt32("error", &aErr);
				aReply.FindString("message", &aString);

				goto EXIT;
				break;
			  default:
				goto EXIT;
				break;
			}	// switch (aReply.what)
		}	// for (int i = 0; ; i++)
	}	// if (name == NULL)

  EXIT:
	return aResult;
}


//----------------------------------------------------------------------

BMessenger
KDeskbar::Shelf()
{
	BMessenger aResult;

	if (IsLocal()) {
		BWindow* aWindow = NULL;

		int32 aWindowNum = be_app->CountWindows();
		for (int32 i = 0; i < aWindowNum; i++) {
			BWindow* tmpWindow = be_app->WindowAt(i);
			if ((tmpWindow != NULL) && (strcasecmp(tmpWindow->Title(), "Deskbar") == 0)) {
				aWindow = tmpWindow;
				break;
			}
		}

		if (aWindow != NULL) {
			int32 aHandlerNum = aWindow->CountHandlers();
			for (int32 i2 = 0; i2 < aHandlerNum; i2++) {
				BShelf* tmpShelf = dynamic_cast<BShelf*>(aWindow->HandlerAt(i2));
				if (tmpShelf != NULL) {
					aResult = BMessenger(tmpShelf);
				}
			}
		}
	} else {
		status_t aErr = B_OK;
		BMessenger aDeskbar(DESKBAR_SIGNATURE, -1, &aErr);
		if (aErr != B_OK)
			return aResult;

		BMessage aMessage(B_GET_PROPERTY);
	
		aMessage.AddSpecifier("Messenger");
		aMessage.AddSpecifier("Shelf");
		aMessage.AddSpecifier("View", "Status");
		aMessage.AddSpecifier("Window", "Deskbar");
	
		BMessage aReply;

		if (aDeskbar.SendMessage(&aMessage, &aReply, mTimeout, mTimeout) == B_OK)
			aReply.FindMessenger("result", &aResult);
	}

	return aResult;
}


//----------------------------------------------------------------------

status_t
KDeskbar::Activate()
{
	status_t aErr = B_OK;

	team_id aTeam = be_roster->TeamFor(DESKBAR_SIGNATURE);
	if (aTeam < B_OK) {
		aErr = aTeam;
	} else {
		aErr = be_roster->ActivateApp(aTeam);
	}

	return aErr;
}


//----------------------------------------------------------------------

BRect
KDeskbar::Frame()
{
	const BRect kInvalidRect(0, 0, -1, -1);
	BRect aResultRect;

	if (IsLocal()) {
		BWindow* aWindow = NULL;

		int32 aWindowNum = be_app->CountWindows();
		for (int32 i = 0; i < aWindowNum; i++) {
			BWindow* tmpWindow = be_app->WindowAt(i);
			if ((tmpWindow != NULL) && (strcasecmp(tmpWindow->Title(), "Deskbar") == 0)) {
				aWindow = tmpWindow;
				break;
			}
		}

		if (aWindow != NULL) {
			aResultRect = aWindow->Frame();
		} else {
			aResultRect = kInvalidRect;
		}
	} else {
		status_t aErr = B_OK;

#if (B_BEOS_VERSION	>= 0x0400)
		aErr = get_deskbar_frame(&aResultRect);
		if (aErr != B_OK)
			aResultRect = kInvalidRect;
#else
		BMessenger aMessenger(DESKBAR_SIGNATURE);
		if (!aMessenger.IsValid())
			return kInvalidRect;
	
		BMessage aMessage(B_GET_PROPERTY);
		aErr = aMessage.AddSpecifier("Frame");
		aErr = aMessage.AddSpecifier("Window", "Deskbar");

		BMessage aReply;
		aErr = aMessenger.SendMessage(&aMessage, &aReply, mTimeout, mTimeout);
		if (aErr < B_OK)
			return kInvalidRect;

		switch (aReply.what)
		{
		  case B_REPLY:
			aErr = aReply.FindRect("result", &aResultRect);
			if (aErr < B_OK)
				aResultRect = kInvalidRect;
			break;
		  default:
			PRINT_OBJECT((aReply));
			aResultRect = kInvalidRect;
			break;
		}
#endif
	}
	PRINT_OBJECT(aResultRect);

	return aResultRect;
}


//----------------------------------------------------------------------

status_t
KDeskbar::SetTimeout(bigtime_t timeout)
{
	PRINT(("KDeskbar::SetTimeout\n"));
	status_t aResult = B_OK;

	if (timeout < 0LL)
		aResult = B_ERROR;
	else {
		mTimeout = timeout;
		aResult = B_OK;
	}

	return aResult;
}
