#include <Debug.h>
#include "classSound.h"

#include <Entry.h>
#include <Sound.h>

#warning consider convert to gamesound
// The constructor actually loads and stores the sound file into
// memory.
classSound::classSound( const char *path)
{
	OK = false;
	sound = NULL;
	BEntry entry(path, true );
	entry_ref ref;

	if (entry.GetRef(&ref) == B_OK) {
	
		sound = new BSound(&ref, true);  // Actually load the sound file into memory
		fmt = sound -> Format();
		if (sound->InitCheck() == B_OK) {
			OK = true;
		}
	}
}	

// Destroy the player and things (only if it was ever made)
classSound::~classSound( )
{
	if( OK )
	{ 
		sound -> ReleaseRef();
		//delete entry;
	}
}

BSoundPlayer::play_id classSound::PlaySound(BSoundPlayer *player) {

	if(!OK)
		return (BSoundPlayer::play_id) -1;

	BSoundPlayer::play_id pid = player -> StartPlaying(sound);

	return pid;

}


// Just checks to make sure all is good.
bool classSound::IsOK( )
{
	return OK;
}