#include "classWindow.h"

#include <stdio.h>

classWindow::classWindow( BRect frame ) : BWindow( frame, "Fun with ICQ", B_TITLED_WINDOW, B_NOT_RESIZABLE )
{
	windowBack = new BView( Bounds(), "windowBack", B_FOLLOW_ALL_SIDES, B_WILL_DRAW );
	windowBack -> SetViewColor( 216, 216, 216 );
	AddChild( windowBack );

	float minW, maxW, minH, maxH;

	GetSizeLimits( &minW, &maxW, &minH, &maxH );
	SetSizeLimits( 457, maxW, 217, maxH );

	buttonLogin = new BButton( BRect( 5, 5, 70, 25 ), "buttonLogin", "Login", new BMessage( A_BUTTON ) );
	buttonLogin -> SetEnabled( false );
	windowBack -> AddChild( buttonLogin );

	buttonLogout = new BButton( BRect( 75, 5, 140, 25 ), "buttonLogout", "Logout", new BMessage( B_BUTTON ) );
	buttonLogout -> SetEnabled( false );
	windowBack -> AddChild( buttonLogout );

	buttonStatus = new BButton( BRect( 145, 5, 210, 25 ), "buttonStatus", "Set Away", new BMessage( C_BUTTON ) );
	buttonStatus -> SetEnabled( false );
	windowBack -> AddChild( buttonStatus );

	buttonSend = new BButton( BRect( 215, 5, 280, 25 ), "buttonSend", "Send ICQ", new BMessage( D_BUTTON ) );
	buttonSend -> SetEnabled( false );
	windowBack -> AddChild( buttonSend );

	buttonURL = new BButton( BRect( 285, 5, 350, 25 ), "buttonURL", "Send URL", new BMessage( E_BUTTON ) );
	buttonURL -> SetEnabled( false );
	windowBack -> AddChild( buttonURL );
	
	buttonInfo = new BButton( BRect( 355, 5, 420, 25 ), "buttonInfo", "Req Info", new BMessage( F_BUTTON ) );
	buttonInfo -> SetEnabled( false );
	windowBack -> AddChild( buttonInfo );
	
	buttonAdd = new BButton( BRect( 425, 5, 490, 25 ), "buttonAdd", "Add UIN", new BMessage( G_BUTTON ) );
	buttonAdd -> SetEnabled( false );
	windowBack -> AddChild( buttonAdd );

	buttonSearch = new BButton( BRect( 495, 5, 560, 25 ), "buttonSearch", "Search", new BMessage( H_BUTTON ) );
	buttonSearch -> SetEnabled( false );
	windowBack -> AddChild( buttonSearch );

	BRect listframe = Bounds();
	listframe.top = buttonLogin -> Bounds().bottom + 12;
	listframe.right -= B_V_SCROLL_BAR_WIDTH;

	listView = new BListView(listframe, "listView", B_SINGLE_SELECTION_LIST);

	listScroll = new BScrollView("listScroll", listView, B_FOLLOW_LEFT | B_FOLLOW_TOP, 0, false, true);

	windowBack -> AddChild( listScroll );

	Show();

	BMessage uin( ICQ_SET_UIN );
	uin.AddInt32( "UIN", 7259922 );
	
	icq = new protoICQ( );
	icq -> SetTarget( this );

	icq -> PostMessage( &uin );


	BMessage contact( ICQ_ADD_CONTACT );
	contact.AddInt32( "UIN", 649272 );
	icq -> PostMessage( &contact );


	contact.ReplaceInt32( "UIN", 1511159 );
	icq -> PostMessage( &contact );

	udp = new SThread( 1, "UDPThread", SOCK_DGRAM );
	udp -> SetTarget( this );
	
	BMessage msg( ST_CONNECT );	

	// __ICQ Servers__
	// icq.mirabilis.com : 4000
	// icq1.mirabilis.com : 4000 
	
	msg.AddString( "HOSTNAME", "icq1.mirabilis.com" );
	msg.AddInt32( "PORT", 4000 );
	
	udp -> PostMessage( &msg );
}

void classWindow::MessageReceived( BMessage *msg )
{
	BMessage *m;
	BString str;
	bool b;
	int32 num;

	switch (msg -> what )
	{
		case A_BUTTON:
			m = new BMessage( ICQ_LOGIN );
			m -> AddString( "PASSWORD", "kb0lcj" );
			m -> AddInt32( "TCP_PORT", 4000 );
			m -> AddInt32( "STATUS", STATUS_ONLINE );
			icq -> PostMessage( m );
			buttonLogin -> SetEnabled( false );
			break;

		case B_BUTTON:
			icq -> PostMessage( new BMessage( ICQ_LOGOUT ) );
			break;

		case C_BUTTON:
			m = new BMessage( ICQ_STATUS_UPDATE );
			if( strcmp( buttonStatus -> Label( ), "Set Away" ) == 0 )
			{
				m -> AddInt32( "STATUS", STATUS_AWAY );
				buttonStatus -> SetLabel( "Set Online" );
			}
			else
			{
				m -> AddInt32( "STATUS", STATUS_ONLINE );
				buttonStatus -> SetLabel( "Set Away" );
			}
			icq -> PostMessage( m );
			break;

		case D_BUTTON:
			str = "Hi there!!!!  This is a test message sent from GimICQ!";
			m = new BMessage( ICQ_TEXT_MESSAGE );
			m -> AddInt32( "TO", 649272 );  // kb0lcj
			//m -> AddInt32( "TO", 1511159 ); // GNichols
			m -> AddString( "TEXT", str.String() );
			m -> AddInt32( "LENGTH", str.Length() );
			icq -> PostMessage( m );
			break;

		case E_BUTTON:
			str = "URL from GimICQ!";
			m = new BMessage( ICQ_URL_MESSAGE );
			m -> AddInt32( "TO", 649272 );  // kb0lcj
			//m -> AddInt32( "TO", 1511159 ); // GNichols
			m -> AddString( "TEXT", str.String() );
			m -> AddInt32( "LENGTH_TEXT", str.Length() );
			str = "http://www.gimmick.org/";
			m -> AddString( "URL", str.String() );
			m -> AddInt32( "LENGTH_URL", str.Length() );
			icq -> PostMessage( m );		
			break;

		case F_BUTTON:
			m = new BMessage( ICQ_USER_INFO );
			//m -> AddInt32( "UIN", 649272 );	// kb0lcj
			m -> AddInt32( "UIN", 1511159 ); // GNichols
			icq -> PostMessage( m );
			break;
			
		case G_BUTTON:
//			m = new BMessage( ICQ_ADD_CONTACT );
//			m -> AddInt32( "UIN", 1511159 );
//			icq -> PostMessage( m );
//			delete m;
			m = new BMessage( ICQ_ADD_CONTACT );
			m -> AddInt32( "UIN", 37759420 );
			icq -> PostMessage( m );
			break;
			
		case H_BUTTON:
			m = new BMessage( ICQ_USER_SEARCH );
			m -> AddString( "EMAIL", "" );
			m -> AddInt32( "LENGTH_EMAIL", 0 );
			m -> AddString( "FIRSTNAME", "" );
			m -> AddInt32( "LENGTH_FIRST", 0 );
			m -> AddString( "LASTNAME", "Heber" );
			m -> AddInt32( "LENGTH_LAST", 5 );
			m -> AddString( "NICKNAME", "" );
			m -> AddInt32( "LENGTH_NICK", 0 );

			icq -> PostMessage( m );
			break;

		case ST_CONNECTED:
			//printf( "Connected [%lu].\n", msg -> FindInt32( "LOCALIP" ) );
			fflush( stdout );
			m = new BMessage( ICQ_SETUP );
			m -> AddInt32( "INT_IP", msg -> FindInt32( "LOCALIP" ) );
			icq -> PostMessage( m );
			buttonLogin -> SetEnabled( true );
			break;

		case ICQ_LOGGED_IN:
			buttonLogin -> SetEnabled( false );
			buttonLogout -> SetEnabled( true );
			buttonStatus -> SetEnabled( true );
			buttonSend -> SetEnabled( true );		
			buttonURL -> SetEnabled( true );
			buttonInfo -> SetEnabled( true );
			buttonAdd -> SetEnabled( true );
			buttonSearch -> SetEnabled( true );
			break;
			
		case ICQ_LOGGED_OUT:
			buttonLogin -> SetEnabled( true );
			buttonLogout -> SetEnabled( false );
			buttonStatus -> SetLabel( "Set Away" );
			buttonStatus -> SetEnabled( false );
			buttonSend -> SetEnabled( false );
			buttonURL -> SetEnabled( false );
			buttonInfo -> SetEnabled( false );
			buttonAdd -> SetEnabled( false );
			buttonSearch -> SetEnabled( false );
			break;
			
		case ICQ_TEXT_MESSAGE:
			listView->AddItem(new BStringItem( "INCOMING MESSAGE:" ));
			str = "From: ";
			str << msg -> FindInt32( "FROM" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Text: ";
			str << msg -> FindString( "TEXT" );
			listView->AddItem(new BStringItem( str.String() ));

			listView->AddItem(new BStringItem( " " ));
			break;

		case ICQ_URL_MESSAGE:
			listView->AddItem(new BStringItem( "INCOMING URL:" ));
			str = "From: ";
			str << msg -> FindInt32( "FROM" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Url: ";
			str << msg -> FindString( "URL" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Text: ";
			str << msg -> FindString( "TEXT" );
			listView->AddItem(new BStringItem( str.String() ));

			listView->AddItem(new BStringItem( " " ));
			break;

		case ICQ_USER_INFO:
			listView->AddItem(new BStringItem( "INCOMING USER INFO:" ));
			str = "ICQ #: ";
			str << msg -> FindInt32( "UIN" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Nickname: ";
			str << msg -> FindString( "NICKNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "First Name: ";
			str << msg -> FindString( "FIRSTNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Last Name: ";
			str << msg -> FindString( "LASTNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "E-Mail: ";
			str << msg -> FindString( "EMAIL" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Requires Ack: ";
			b = msg -> FindBool( "REQACK" );
			if( b )
				str << "yes";
			else
				str << "no";
			listView->AddItem(new BStringItem( str.String() ));

			listView->AddItem(new BStringItem( " " ));
			break;

		case ICQ_USER_SEARCH:
			listView->AddItem(new BStringItem( "INCOMING SEARCH RESULT:" ));
			str = "ICQ #: ";
			str << msg -> FindInt32( "UIN" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Nickname: ";
			str << msg -> FindString( "NICKNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "First Name: ";
			str << msg -> FindString( "FIRSTNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Last Name: ";
			str << msg -> FindString( "LASTNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "E-Mail: ";
			str << msg -> FindString( "EMAIL" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Requires Ack: ";
			b = msg -> FindBool( "REQACK" );
			if( b )
				str << "yes";
			else
				str << "no";
			listView->AddItem(new BStringItem( str.String() ));

			listView->AddItem(new BStringItem( " " ));
			break;

		case ICQ_USER_SEARCH_DONE:
			listView->AddItem(new BStringItem( "SEARCH COMPLETE:" ));
			b = msg -> FindBool( "MORE" );

			str = "More: ";

			if( b )
				str << "yes";
			else
				str << "no";

			listView->AddItem(new BStringItem( str.String() ));

			listView->AddItem(new BStringItem( " " ));				
			break;

		case ICQ_AUTH_REQUEST:
			listView->AddItem(new BStringItem( "INCOMING AUTH REQUEST:" ));
			str = "ICQ #: ";
			str << msg -> FindInt32( "FROM" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Nickname: ";
			str << msg -> FindString( "NICKNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "First Name: ";
			str << msg -> FindString( "FIRSTNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Last Name: ";
			str << msg -> FindString( "LASTNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "E-Mail: ";
			str << msg -> FindString( "EMAIL" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Reason: ";
			str << msg -> FindString( "REASON" );
			listView->AddItem(new BStringItem( str.String() ));

			listView->AddItem(new BStringItem( " " ));
			
			// Sending the auth message right now (for fun)
			m = new BMessage( ICQ_GRANT_AUTH );
			m -> AddInt32( "UIN", msg -> FindInt32( "FROM" ) );
			icq -> PostMessage( m );
			break;

		case ICQ_ADD_CONTACT:
			listView->AddItem(new BStringItem( "INCOMING USER ADD MESSAGE:" ));
			str = "ICQ #: ";
			str << msg -> FindInt32( "UIN" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Nickname: ";
			str << msg -> FindString( "NICKNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "First Name: ";
			str << msg -> FindString( "FIRSTNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Last Name: ";
			str << msg -> FindString( "LASTNAME" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "E-Mail: ";
			str << msg -> FindString( "EMAIL" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "User added you to their contact list.";
			listView->AddItem(new BStringItem( str.String() ));

			listView->AddItem(new BStringItem( " " ));
			break;

		case ICQ_USER_STATUS:
			listView->AddItem(new BStringItem( "STATUS UPDATE:" ));
			str = "ICQ #: ";
			str << msg -> FindInt32( "UIN" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Status: ";

			num = msg -> FindInt32( "STATUS" );

			if( num == STATUS_ONLINE )
				str << "Online";
			if( num == STATUS_NA_99 || num == STATUS_NA )
				str << "NA";
			if( num == STATUS_FREE_CHAT )
				str << "Free to Chat";
			if( num == STATUS_OCCUPIED_MAC || num == STATUS_OCCUPIED )
				str << "Occupied";
			if( num == STATUS_AWAY )
				str << "Away";
			if( num == STATUS_DND || num == STATUS_DND_99 )
				str << "Do not Disturb";

			listView->AddItem(new BStringItem( str.String() ));

			listView->AddItem(new BStringItem( " " ));		
			break;
			
		case ICQ_USER_ONLINE:
			listView->AddItem(new BStringItem( "USER ONLINE:" ));
			str = "ICQ #: ";
			str << msg -> FindInt32( "UIN" );
			listView->AddItem(new BStringItem( str.String() ));
			str = "Status: ";

			num = msg -> FindInt32( "STATUS" );

			if( num == STATUS_ONLINE )
				str << "Online";
			if( num == STATUS_NA_99 || num == STATUS_NA )
				str << "NA";
			if( num == STATUS_FREE_CHAT )
				str << "Free to Chat";
			if( num == STATUS_OCCUPIED_MAC || num == STATUS_OCCUPIED )
				str << "Occupied";
			if( num == STATUS_AWAY )
				str << "Away";
			if( num == STATUS_DND || num == STATUS_DND_99 )
				str << "Do not Disturb";

			listView->AddItem(new BStringItem( str.String() ));

			listView->AddItem(new BStringItem( " " ));					
			break;

		case ICQ_USER_OFFLINE:
			listView->AddItem(new BStringItem( "USER OFFLINE:" ));
			str = "ICQ #: ";
			str << msg -> FindInt32( "UIN" );
			listView->AddItem( new BStringItem( str.String() ));

			listView->AddItem(new BStringItem( " " ));			
			break;

		case ICQ_UDP_DATA:
			msg -> what = ST_DATA_SEND;
			udp -> PostMessage( msg );
			break;
			
		case ST_DATA_RECV:
			msg -> what = ICQ_UDP_DATA;
			icq -> PostMessage( msg );
			break;

		default:
			BWindow::MessageReceived(msg);
			break;
	};
}

bool classWindow::QuitRequested()
{
	// Kill the server by locking and shutting it down.
	//printf( "Killing loopers...\n" );
	fflush( stdout );

	icq -> Lock( );
	icq -> Quit( );

	udp -> Lock( );
	udp -> Quit( );

	//printf( "Done.\n" );
	fflush( stdout );

	// The big goodbye
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}