#include <Debug.h>
#include "GManager.h"
#include <Bitmap.h>

#include "WindowManager.h"
#include "ProtocolManager.h"
#include "PeopleData.h"
#include "Prefs.h"
#include "Gicq.h"
#include "History.h"
#include "classSoundMaster.h"
#include "MiscStuff.h"
#include "Locale.h"

GManager::GManager(){

	LoggedIn = false;

	deskbarIconInstalled = false;
	
	// make the ICQ class itself
	icq = new protoICQ(this);
	
	// Create other necessary global objects
	windows = new WindowManager(this);
	history = new History(this);
	list = new PeopleList(this);
	sounds = new classSoundMaster;
	p_comm = new ProtocolManager(this);
	prefs = new GPreferences;

	mLocale = new Locale( this );
		
	defEncoding = B_MS_WINDOWS_CONVERSION;
	// load in the status bitmaps
	for( int32 i = 0; i < 17; ++i )
		statBitmaps[i] = NULL;
	for( int32 i2 = 0; i2 < 6; ++i2 ) 
		GetBitmapFromResources( statBitmaps[i2], 3701 + i2, mLocale );

	own_uin = 0;

}


GManager::~GManager(){

	if( icq ) {
		icq->Lock();
		icq->Quit();
	}
	
	delete p_comm;
	delete sounds;
	delete history;
	delete list;
	delete windows;
	delete mLocale;
	delete prefs;

}

