#include <Debug.h>
#include "Locale.h"

#include <Message.h>
#include <InterfaceDefs.h>
#include <Locker.h>
#include <Autolock.h>
#include <File.h>
#include <String.h>
#include <StorageDefs.h>
#include <Directory.h>

#include "GConstants.h"
#include "GManager.h"
#include "Prefs.h"

const char *LOCALE_PATH = "Locale";    // config_path + locale_path = true locale path

Locale::Locale( GManager *aManager )
	:mManager(aManager)
{ 
	
	char filename[B_FILE_NAME_LENGTH];

	mLocaleMsg = new BMessage();	
	mLock = new BLocker("locale_lock");
	
		
	// Load language.
	aManager -> prefs -> ReadString("locale_file", filename, "current", B_FILE_NAME_LENGTH, true);

	// Read preference.
	LoadDefault();
//	DumpLocale();
	SetLocale( filename );
}

Locale::~Locale() {

	delete mLocaleMsg;
	delete mLock;
}

const char *Locale::FindString(const char *aName) {

	BAutolock autolock(mLock);	
	const char *value = mLocaleMsg -> FindString(aName);
	
	if(value == NULL)
		return "\0";
	return value;
	
}

void Locale::DumpLocale() {
	
	int32 i;
	char *name;
	uint32 type;
	
	for(i=0; mLocaleMsg->GetInfo(B_ANY_TYPE, i, &name, &type) == B_OK ; i++) {
	
		printf("%s:%s\n", name, mLocaleMsg -> FindString( name ));
	
	}
		
}

int Locale::SetLocale(const char *aLocaleFile) {
	
	BAutolock autolock(mLock);
	BFile localeFile;
	
	if( mManager->prefs->FindConfigFile( LOCALE_PATH, aLocaleFile, &localeFile, B_READ_ONLY ) != B_OK )
		return B_ERROR;
	
	return LoadMessage( &localeFile );
}

int Locale::LoadMessage(BFile *aFile) {

	char buf[BUFFER_LENGTH];
	BString text = "";
	
	BString type, value;
	int size;
	int type_off, value_off;
	
	aFile->Seek(0, SEEK_SET);
	while( (size = aFile->Read(buf, BUFFER_LENGTH - 1) )>0) {
		buf[size] = '\0';
		text += buf;
	}
	
	while(text.CountChars() > 0) {
	
		ClearComment(&text);
		ClearWhites(&text);
		
		type_off = text.FindFirst(':');
		text.MoveInto(type, 0, type_off);
		text.Remove(0,1);
		
		ClearWhites(&text);
		
		value_off = text.FindFirst('\n');
		text.MoveInto(value, 0, value_off);
		text.Remove(0,1);
		
		mLocaleMsg -> ReplaceString( type.String() , value.String() );
		
		ClearWhites(&text);
	}	
	
	return B_OK;
}

void Locale::ClearComment(BString *aStr) {

	ClearWhites( aStr );
	
	while(aStr -> ByteAt(0) == '#') {
		
		while(aStr -> ByteAt(0) != '\n') {
			aStr -> Remove(0,1);
		}
		ClearWhites( aStr );	
	}

}

void Locale::ClearWhites(BString *aStr) {
	
	while(1) {
		switch( aStr -> ByteAt(0) ) {
		
		case ' ':
		case '\n':
		case '\t':
			aStr -> Remove(0,1);
			break;
		default:
			return;
		}
	}
}


void Locale::LoadDefault() {
	
	/* Default and cant be changed */
	mLocaleMsg -> AddString("constant1", GIM_MENU );

// Beta 17

	/* buttons */
	mLocaleMsg -> AddString("closebutton", "Close");
	mLocaleMsg -> AddString("cancelbutton", "Cancel");
	mLocaleMsg -> AddString("okbutton", "OK");
	mLocaleMsg -> AddString("savebutton", "Save");
	mLocaleMsg -> AddString("yesbutton", "Yes");
	mLocaleMsg -> AddString("nobutton", "No");
	mLocaleMsg -> AddString("userinfobutton", "User Info");
	mLocaleMsg -> AddString("sendbutton", "Send");
	mLocaleMsg -> AddString("clearbutton", "Clear History" );
	mLocaleMsg -> AddString("deletebutton", "Delete History" );
	mLocaleMsg -> AddString("addbutton", "Add to Contact List" );
	mLocaleMsg -> AddString("notesbutton", "Notes");
		
	mLocaleMsg -> AddString("button1", "Login");
	mLocaleMsg -> AddString("button2", "Setup");
	/* THESE NOT USED */
	mLocaleMsg -> AddString("button3", "New");		
	/* END NOT USED */

	mLocaleMsg -> AddString("button4", "Search");

	mLocaleMsg -> AddString("button5", "Update");

	mLocaleMsg -> AddString("n/alabel", "N/A");

	mLocaleMsg -> AddString("country0","Not Entered");
	mLocaleMsg -> AddString("country1","USA");
	mLocaleMsg -> AddString("country2","Afghanistan");
	mLocaleMsg -> AddString("country3","Albania");
	mLocaleMsg -> AddString("country4","Algeria");
	mLocaleMsg -> AddString("country5","American Samoa");
	mLocaleMsg -> AddString("country6","Andorra");
	mLocaleMsg -> AddString("country7","Angola");
	mLocaleMsg -> AddString("country8","Anguilla");
	mLocaleMsg -> AddString("country9","Antigua");
	mLocaleMsg -> AddString("country10","Argentina");
	mLocaleMsg -> AddString("country11","Armenia");
	mLocaleMsg -> AddString("country12","Aruba");
	mLocaleMsg -> AddString("country13","Ascention Island");
	mLocaleMsg -> AddString("country14","Australia");
	mLocaleMsg -> AddString("country15","Australian Antartic Territory");
	mLocaleMsg -> AddString("country16","Austria");
	mLocaleMsg -> AddString("country17","Azerbaijan");
	mLocaleMsg -> AddString("country18","Bahamas");
	mLocaleMsg -> AddString("country19","Bahrain");
	mLocaleMsg -> AddString("country20","Bangladesh");
	mLocaleMsg -> AddString("country21","Barbados");
	mLocaleMsg -> AddString("country22","Belarus");
	mLocaleMsg -> AddString("country23","Belgium");
	mLocaleMsg -> AddString("country24","Belize");
	mLocaleMsg -> AddString("country25","Benin");
	mLocaleMsg -> AddString("country26","Bermuda");
	mLocaleMsg -> AddString("country27","Bhutan");
	mLocaleMsg -> AddString("country28","Bolivia");
	mLocaleMsg -> AddString("country29","Bosnia & Herzegovina");
	mLocaleMsg -> AddString("country30","Botswana");
	mLocaleMsg -> AddString("country31","Brazil");
	mLocaleMsg -> AddString("country32","British Virgin Islands");
	mLocaleMsg -> AddString("country33","Brunei");
	mLocaleMsg -> AddString("country34","Bulgaria");
	mLocaleMsg -> AddString("country35","Burkina Faso");
	mLocaleMsg -> AddString("country36","Burundi");
	mLocaleMsg -> AddString("country37","Cambodia");
	mLocaleMsg -> AddString("country38","Cameroon");
	mLocaleMsg -> AddString("country39","Canada");
	mLocaleMsg -> AddString("country40","Cape Verde Islands");
	mLocaleMsg -> AddString("country41","Cayman Islands");
	mLocaleMsg -> AddString("country42","Central African Republic");
	mLocaleMsg -> AddString("country43","Chad");
	mLocaleMsg -> AddString("country44","Christmas Island");
	mLocaleMsg -> AddString("country45","Cocos-Keeling Islands");
	mLocaleMsg -> AddString("country46","Comoros");
	mLocaleMsg -> AddString("country47","Congo");
	mLocaleMsg -> AddString("country48","Cook Islands");
	mLocaleMsg -> AddString("country49","Chile");
	mLocaleMsg -> AddString("country50","China");
	mLocaleMsg -> AddString("country51","Columbia");
	mLocaleMsg -> AddString("country52","Costa Rice");
	mLocaleMsg -> AddString("country53","Croatia");
	mLocaleMsg -> AddString("country54","Cuba");
	mLocaleMsg -> AddString("country55","Cyprus");
	mLocaleMsg -> AddString("country56","Czech Republic");
	mLocaleMsg -> AddString("country57","Denmark");
	mLocaleMsg -> AddString("country58","Diego Garcia");
	mLocaleMsg -> AddString("country59","Djibouti");
	mLocaleMsg -> AddString("country60","Dominica");
	mLocaleMsg -> AddString("country61","Dominican Republic");
	mLocaleMsg -> AddString("country62","Ecuador");
	mLocaleMsg -> AddString("country63","Egypt");
	mLocaleMsg -> AddString("country64","El Salvador");
	mLocaleMsg -> AddString("country65","Equitorial Guinea");
	mLocaleMsg -> AddString("country66","Eritrea");
	mLocaleMsg -> AddString("country67","Estonia");
	mLocaleMsg -> AddString("country68","Ethiopia");
	mLocaleMsg -> AddString("country69","F.Y.R.O.M. (Former Yugoslavia)");
	mLocaleMsg -> AddString("country70","Faeroe Islands");
	mLocaleMsg -> AddString("country71","Falkland Islands");
	mLocaleMsg -> AddString("country72","Federated States of Micronesia");
	mLocaleMsg -> AddString("country73","Fiji");
	mLocaleMsg -> AddString("country74","Finland");
	mLocaleMsg -> AddString("country75","France");
	mLocaleMsg -> AddString("country76","French Antilles - Old");
	mLocaleMsg -> AddString("country77","French Antilles - New");
	mLocaleMsg -> AddString("country78","French Guiana");
	mLocaleMsg -> AddString("country79","French Polynesia");
	mLocaleMsg -> AddString("country80","Gabon");
	mLocaleMsg -> AddString("country81","Gambia");
	mLocaleMsg -> AddString("country82","Georgia");
	mLocaleMsg -> AddString("country83","Germany");
	mLocaleMsg -> AddString("country84","Ghana");
	mLocaleMsg -> AddString("country85","Gibraltar");
	mLocaleMsg -> AddString("country86","Greece");
	mLocaleMsg -> AddString("country87","Greenland");
	mLocaleMsg -> AddString("country88","Grenada");
	mLocaleMsg -> AddString("country89","Guadeloupe");
	mLocaleMsg -> AddString("country90","Guam");
	mLocaleMsg -> AddString("country91","Guantanomo Bay");
	mLocaleMsg -> AddString("country92","Guatemala");
	mLocaleMsg -> AddString("country93","Guinea");
	mLocaleMsg -> AddString("country94","Guinea-Bissau");
	mLocaleMsg -> AddString("country95","Guyana");
	mLocaleMsg -> AddString("country96","Haiti");
	mLocaleMsg -> AddString("country97","Honduras");
	mLocaleMsg -> AddString("country98","Hong Kong");
	mLocaleMsg -> AddString("country99","Hungary");
	mLocaleMsg -> AddString("country100","Iceland");
	mLocaleMsg -> AddString("country101","India");
	mLocaleMsg -> AddString("country102","Indonesia");
	mLocaleMsg -> AddString("country103","INMARSAT");
	mLocaleMsg -> AddString("country104","INMARSAT Atlantic-East");
	mLocaleMsg -> AddString("country105","Iran");
	mLocaleMsg -> AddString("country106","Iraq");
	mLocaleMsg -> AddString("country107","Ireland");
	mLocaleMsg -> AddString("country108","Israel");
	mLocaleMsg -> AddString("country109","Italy");
	mLocaleMsg -> AddString("country110","Ivory Coast");
	mLocaleMsg -> AddString("country111","Japan");
	mLocaleMsg -> AddString("country112","Jordan");
	mLocaleMsg -> AddString("country113","Kenya");
	mLocaleMsg -> AddString("country114","South Korea");
	mLocaleMsg -> AddString("country115","Kuwait");
	mLocaleMsg -> AddString("country116","Liberia");
	mLocaleMsg -> AddString("country117","Libya");
	mLocaleMsg -> AddString("country118","Liechtenstein");
	mLocaleMsg -> AddString("country119","Luxembourg");
	mLocaleMsg -> AddString("country120","Malawi");
	mLocaleMsg -> AddString("country121","Malaysia");
	mLocaleMsg -> AddString("country122","Mali");
	mLocaleMsg -> AddString("country123","Malta");
	mLocaleMsg -> AddString("country124","Mexico");
	mLocaleMsg -> AddString("country125","Monaco");
	mLocaleMsg -> AddString("country126","Morocco");
	mLocaleMsg -> AddString("country127","Namibia");
	mLocaleMsg -> AddString("country128","Nepal");
	mLocaleMsg -> AddString("country129","Netherlands");
	mLocaleMsg -> AddString("country130","Netherlands Antilles");
	mLocaleMsg -> AddString("country131","New Caledonia");
	mLocaleMsg -> AddString("country132","New Zealand");
	mLocaleMsg -> AddString("country133","Nicaragua");
	mLocaleMsg -> AddString("country134","Nigeria");
	mLocaleMsg -> AddString("country135","Norway");
	mLocaleMsg -> AddString("country136","Oman");
	mLocaleMsg -> AddString("country137","Pakistan");
	mLocaleMsg -> AddString("country138","Panama");
	mLocaleMsg -> AddString("country139","Papua New Guinea");
	mLocaleMsg -> AddString("country140","Paraguay");
	mLocaleMsg -> AddString("country141","Peru");
	mLocaleMsg -> AddString("country142","Philippines");
	mLocaleMsg -> AddString("country143","Poland");
	mLocaleMsg -> AddString("country144","Portugal");
	mLocaleMsg -> AddString("country145","Qatar");
	mLocaleMsg -> AddString("country146","Romania");
	mLocaleMsg -> AddString("country147","Russia");
	mLocaleMsg -> AddString("country148","Saipan");
	mLocaleMsg -> AddString("country149","San Marino");
	mLocaleMsg -> AddString("country150","Saudia Arabia");
	mLocaleMsg -> AddString("country151","Senegal");
	mLocaleMsg -> AddString("country152","Singapore");
	mLocaleMsg -> AddString("country153","Slovakia");
	mLocaleMsg -> AddString("country154","South Africa");
	mLocaleMsg -> AddString("country155","Spain");
	mLocaleMsg -> AddString("country156","Sri Lanka");
	mLocaleMsg -> AddString("country157","Suriname");
	mLocaleMsg -> AddString("country158","Sweden");
	mLocaleMsg -> AddString("country159","Switzerland");
	mLocaleMsg -> AddString("country160","Taiwan");
	mLocaleMsg -> AddString("country161","Tanzania");
	mLocaleMsg -> AddString("country162","Thailand");
	mLocaleMsg -> AddString("country163","Tunisia");
	mLocaleMsg -> AddString("country164","Turkey");
	mLocaleMsg -> AddString("country165","United Arab Emirates");
	mLocaleMsg -> AddString("country166","Uruguay");
	mLocaleMsg -> AddString("country167","UK");
	mLocaleMsg -> AddString("country168","Ukraine");
	mLocaleMsg -> AddString("country169","Vatican City");
	mLocaleMsg -> AddString("country170","Venezuela");
	mLocaleMsg -> AddString("country171","Vietnam");
	mLocaleMsg -> AddString("country172","Yemen");
	mLocaleMsg -> AddString("country173","Yugoslavia");
	mLocaleMsg -> AddString("country174","Zaire");
	mLocaleMsg -> AddString("country175","Zimbabwe");

	mLocaleMsg -> AddString("label1", "User Info");
	mLocaleMsg -> AddString("label2", "Extended");
	mLocaleMsg -> AddString("label3", "Profile");

	mLocaleMsg -> AddString("label20", "User Profile");	

	mLocaleMsg -> AddString("label21", "ICQ UIN");	
	mLocaleMsg -> AddString("label22", "Nick Name");	
	mLocaleMsg -> AddString("label23", "First Name");	
	mLocaleMsg -> AddString("label24", "Last Name");	
	mLocaleMsg -> AddString("label25", "Email");	
	mLocaleMsg -> AddString("label26", "Requires Auth");	

	mLocaleMsg -> AddString("label27", "Web Page");	
	mLocaleMsg -> AddString("label28", "City/State/Zip");	
	mLocaleMsg -> AddString("label29", "Country");	
	mLocaleMsg -> AddString("label30", "Phone Number");	
	mLocaleMsg -> AddString("label31", "Time Zone");	
	mLocaleMsg -> AddString("label32", "Age/Sex");	

	mLocaleMsg -> AddString("label33", "Info");	
	mLocaleMsg -> AddString("label34", "Extended Info");	

	mLocaleMsg -> AddString("label40", "ICQ UIN");
	mLocaleMsg -> AddString("label41", "Password");
	mLocaleMsg -> AddString("label42", "Save Password");
	mLocaleMsg -> AddString("label43", "Auto-Login");

	/* THESE NOT USED */
	mLocaleMsg -> AddString("label50", "Type the password for your new UIN");
	mLocaleMsg -> AddString("label51", "New Password");
	mLocaleMsg -> AddString("label52", "Retype");
	mLocaleMsg -> AddString("label53", "Waiting for response");

	/* END NOT USED */
	
	mLocaleMsg -> AddString("label60", "User Notes: (not sent to the ICQ server)" );

	mLocaleMsg -> AddString("label70", "New Password" );
	mLocaleMsg -> AddString("label71", "Retype" );

	mLocaleMsg -> AddString("label80", "ICQ Server" );
	mLocaleMsg -> AddString("label81", "Host" );
	mLocaleMsg -> AddString("label82", "Port" );

	mLocaleMsg -> AddString("label90", "General" );
	mLocaleMsg -> AddString("label91", "Chat Windows" );
	mLocaleMsg -> AddString("label92", "Connection" );


	mLocaleMsg -> AddString("label110", "" );

	mLocaleMsg -> AddString("label120", "UIN" );
	mLocaleMsg -> AddString("label121", "Nickname" );
	mLocaleMsg -> AddString("label122", "First" );
	mLocaleMsg -> AddString("label123", "Last" );
	mLocaleMsg -> AddString("label124", "e-mail" );
	mLocaleMsg -> AddString("label125", "Auth" );
	mLocaleMsg -> AddString("label126", "Search Results" );
	
	mLocaleMsg -> AddString("label130", "User Info for a UIN" );
	mLocaleMsg -> AddString("label131", "UIN");
	mLocaleMsg -> AddString("label132", "Search by name");
	mLocaleMsg -> AddString("label133", "Nick");
	mLocaleMsg -> AddString("label134", "First");
	mLocaleMsg -> AddString("label135", "Last");
	mLocaleMsg -> AddString("label136", "Search by email");
	mLocaleMsg -> AddString("label137", "email");

	mLocaleMsg -> AddString("label140", "URL");

	mLocaleMsg -> AddString("label150", "Nick Name");
	mLocaleMsg -> AddString("label151", "First Name");
	mLocaleMsg -> AddString("label152", "Last Name");
	mLocaleMsg -> AddString("label153", "email");
	mLocaleMsg -> AddString("label154", "Authorization Required");
	mLocaleMsg -> AddString("label155", "Age");
	mLocaleMsg -> AddString("label156", "Sex");
	mLocaleMsg -> AddString("label157", "City");
	mLocaleMsg -> AddString("label158", "St");
	mLocaleMsg -> AddString("label159", "Zip");
	mLocaleMsg -> AddString("label160", "Country");
	mLocaleMsg -> AddString("label161", "Home Page");
	mLocaleMsg -> AddString("label162", "Phone Num");
	mLocaleMsg -> AddString("label163", "Your Profile");

	mLocaleMsg -> AddString("label170", "Online");
	mLocaleMsg -> AddString("label171", "Offline");
	mLocaleMsg -> AddString("label172", "Pending");
	
	mLocaleMsg -> AddString("menu1", "Edit");
	mLocaleMsg -> AddString("menu2", "Window");
	mLocaleMsg -> AddString("menu3", "Show This Window");
	mLocaleMsg -> AddString("menu4", "Use Encoding");
	mLocaleMsg -> AddString("menu5", "Default Encoding");
	
	mLocaleMsg -> AddString("menuitem1","Search for Contacts");
	mLocaleMsg -> AddString("menuitem2","Update Info");
	mLocaleMsg -> AddString("menuitem3","Change Password");
	mLocaleMsg -> AddString("menuitem4","Preferences");
	mLocaleMsg -> AddString("menuitem5","About");
	mLocaleMsg -> AddString("menuitem6","Login");
	mLocaleMsg -> AddString("menuitem7","Logout");

	mLocaleMsg -> AddString("menuitem20","Available");
	mLocaleMsg -> AddString("menuitem21","Free For Chat");
	mLocaleMsg -> AddString("menuitem22","Away");
	mLocaleMsg -> AddString("menuitem23","Not Available");
	mLocaleMsg -> AddString("menuitem24","Occupied");
	mLocaleMsg -> AddString("menuitem25","Do Not Disturb");
	mLocaleMsg -> AddString("menuitem26","Invisible");

	mLocaleMsg -> AddString("menuitem40"," Send Message");
	mLocaleMsg -> AddString("menuitem41", "Send URL");
	mLocaleMsg -> AddString("menuitem42", "User Info");
	mLocaleMsg -> AddString("menuitem43", "History");
	mLocaleMsg -> AddString("menuitem44", "Authorize" );
	mLocaleMsg -> AddString("menuitem45", "Notify When Online" );
	mLocaleMsg -> AddString("menuitem46", "Remove from List" );

	mLocaleMsg -> AddString("menuitem60", "Undo" );
	mLocaleMsg -> AddString("menuitem61", "Cut" );
	mLocaleMsg -> AddString("menuitem62", "Copy" );
	mLocaleMsg -> AddString("menuitem63", "Paste" );
	mLocaleMsg -> AddString("menuitem64", "Select All");

	mLocaleMsg -> AddString("menuitem80", "Only in This Workspace" );
	mLocaleMsg -> AddString("menuitem81", "In All Workspaces" );

	mLocaleMsg -> AddString("menuitem90", "Popup on Message Receive" );
	mLocaleMsg -> AddString("menuitem91", "Enable web/email links" );
	mLocaleMsg -> AddString("menuitem92", "Jump to Contact List" );
	mLocaleMsg -> AddString("menuitem93", "Close" );
	
	mLocaleMsg -> AddString("menuitem100", "Add to Contact List");
	mLocaleMsg -> AddString("menuitem101", "User Info");
	mLocaleMsg -> AddString("menuitem102", "Send URL");

	mLocaleMsg -> AddString("menuitem110", "Central European (ISO 8859-2)" );
	mLocaleMsg -> AddString("menuitem111", "Cyrillic (ISO 8859-5)" );
	mLocaleMsg -> AddString("menuitem112", "Cyrillic (KOI8-R)" );
	mLocaleMsg -> AddString("menuitem113", "Cyrillic (MS-DOS 866)" );
	mLocaleMsg -> AddString("menuitem114", "Cyrillic (Windows 1251)" );
	mLocaleMsg -> AddString("menuitem115", "Greek (ISO 8859-7)" );
	mLocaleMsg -> AddString("menuitem116", "Japanese (Shift-JIS)" );
	mLocaleMsg -> AddString("menuitem117", "Japanese (EUC)" );
	mLocaleMsg -> AddString("menuitem118", "Unicode" );
	mLocaleMsg -> AddString("menuitem119", "Western (ISO 8859-1)" );
	mLocaleMsg -> AddString("menuitem120", "Western (Mac Roman)" );
	mLocaleMsg -> AddString("menuitem121", "Western (MS Windows)" );

	mLocaleMsg -> AddString("menuitem130", "Guest" );

	mLocaleMsg -> AddString("menuitem140", "Yes" );
	mLocaleMsg -> AddString("menuitem141", "No" );

	mLocaleMsg -> AddString("menuitem150", "Male" );
	mLocaleMsg -> AddString("menuitem151", "Female" );
	mLocaleMsg -> AddString("menuitem152", "Unspecified" );
	mLocaleMsg -> AddString("menuitem153", "Yes, please!" );

	mLocaleMsg -> AddString("text1", "Gim-ICQ version" );
	mLocaleMsg -> AddString("text2", "Incoming authorization request" );
	mLocaleMsg -> AddString("text3", "wants to add you to his/her contact list" );
	mLocaleMsg -> AddString("text4", "Reason" );
	
	mLocaleMsg -> AddString("text20", "Status" );
	mLocaleMsg -> AddString("text21", "Offline" );

	mLocaleMsg -> AddString("text40", "no message" );
	mLocaleMsg -> AddString("text41", "Outgoing URL" );
	mLocaleMsg -> AddString("text42", "Incoming URL" );
	mLocaleMsg -> AddString("text43", "No more offline messages" );
		
	mLocaleMsg -> AddString("text50", "There is no installed handler for 'text/html'." );
	
	mLocaleMsg -> AddString("text60", "History");
	mLocaleMsg -> AddString("text61", "The history will be erased from disc. Are you sure you want to delete the history?");

	mLocaleMsg -> AddString("text80", "User Info");
	
	mLocaleMsg -> AddString("text90", "Done");
	mLocaleMsg -> AddString("text91", "Waiting for extended info");
	mLocaleMsg -> AddString("text92", "Waiting for regular info");
	mLocaleMsg -> AddString("text93", "Waiting for response");

	mLocaleMsg -> AddString("text100", "Your password was not accepted." );
	mLocaleMsg -> AddString("text101", "There was an error logging in. Try again." );
	mLocaleMsg -> AddString("text102", "Logging in...");
	mLocaleMsg -> AddString("text103", "Resolving info");
	mLocaleMsg -> AddString("text104", "Auto-login in 5 seconds");
	mLocaleMsg -> AddString("text105", "Error! Thread not spawned!");
	mLocaleMsg -> AddString("text106", "Auto-login in");
	mLocaleMsg -> AddString("text107", "second" );
	mLocaleMsg -> AddString("text108", "seconds" );

	mLocaleMsg -> AddString("text120", "The passwords do not match!" );
	
	mLocaleMsg -> AddString("text130", "Show the Contact List in all workspaces" );
	mLocaleMsg -> AddString("text131", "Play sound effects" );
	mLocaleMsg -> AddString("text132", "Status is Away after 10 minutes, N/A after 20 minutes" );
	mLocaleMsg -> AddString("text133", "Enable the Gim-ICQ Deskbar Icon" );
	mLocaleMsg -> AddString("text134", "Flash the deskbar icon when new messages come in" );

	mLocaleMsg -> AddString("text140", "Show chat windows in all workspaces by default" );
	mLocaleMsg -> AddString("text141", "Popup chat windows when messages are received by default" );
	mLocaleMsg -> AddString("text142", "Enable web/email links" );
	mLocaleMsg -> AddString("text143", "Prefix messages you haven't seen yet with '√' in the title bar" );
	mLocaleMsg -> AddString("text144", "Use Mod+Enter to send (Enter inserts a newline instead)" );
	mLocaleMsg -> AddString("text145", "Keep chat windows minimized when not in use" );

	mLocaleMsg -> AddString("text150", "Yes" );
	mLocaleMsg -> AddString("text151", "No" );

	mLocaleMsg -> AddString("text160", "Searching" );
	mLocaleMsg -> AddString("text161", "found" );
	mLocaleMsg -> AddString("text162", "Maximum of 40 results exceeded. Try making your search more specific." );
	mLocaleMsg -> AddString("text163", "Search completed" );
	mLocaleMsg -> AddString("text164", "result" );
	mLocaleMsg -> AddString("text165", "results" );

	mLocaleMsg -> AddString("text170", "Please enter a UIN." );
	mLocaleMsg -> AddString("text171", "Please enter a name of some sort.");
	mLocaleMsg -> AddString("text172", "Please enter an email address.");

	mLocaleMsg -> AddString("text180", "Please enter a URL.");

	mLocaleMsg -> AddString("text190","Error opening file");
	mLocaleMsg -> AddString("text191","Error opening directory");
	mLocaleMsg -> AddString("text192","Error reading historyfile");

	mLocaleMsg -> AddString("text200","Error while reading resource from file.");
	mLocaleMsg -> AddString("text201","Error opening resource file.");

	mLocaleMsg -> AddString("text210","Your attempt to update your user info has failed!\nSilly ICQ. Try again or something.");
	mLocaleMsg -> AddString("text211","has come online.");
		

	mLocaleMsg -> AddString("title1", "About" );
	mLocaleMsg -> AddString("title2", "Authorization Request" );
	mLocaleMsg -> AddString("title3", "Contact List" );
	mLocaleMsg -> AddString("title4", "Login" );
	mLocaleMsg -> AddString("title5", "Notes" );
	mLocaleMsg -> AddString("title6", "Search Results" );
	mLocaleMsg -> AddString("title7", "Search for Contacts" );
	mLocaleMsg -> AddString("title8", "Send URL to" );

// Beta 18

	mLocaleMsg -> AddString("text22", "Reconnecting" );

	mLocaleMsg -> AddString("text220","Reconnect to server, if connection is lost.");

// Beta 19

	mLocaleMsg -> AddString("label93", "Language" );

	mLocaleMsg -> AddString("text230", "The Locale files must be placed in" );
	mLocaleMsg -> AddString("text231", "The Locale files can be downloaded from the homepage of Gim-ICQ." );
	mLocaleMsg -> AddString("text232", "The changes will take effect at next launch of Gim-ICQ." );

}
