#include <Debug.h>
#include "MiscStuff.h"

#include <Bitmap.h>
#include <Resources.h>
#include <Alert.h>
#include <View.h>
#include <Picture.h>
#include <Application.h>
#include <UTF8.h>
#include <String.h>

#include <ctype.h>

#include "GConstants.h"
#include "Gicq.h"
#include "GManager.h"
#include "Locale.h"

//-------------------------------------------------------------------------

void GetBitmapFromResources( BBitmap*& themap, int32 resid, Locale *aLocale) 
{

	size_t  reslength;
	const char * resbuf;
	BMessage archive;
	BResources *res;
	
	res = be_app->AppResources();
	
	if(res)  {

		// Find and load resource
		resbuf = (char*)res->LoadResource( B_RAW_TYPE, resid, &reslength );
   							
		if( resbuf ) {
   		
		// Inflate and unarchive BBitmap
			archive.Unflatten( resbuf );	
			themap = new BBitmap( &archive );	
	
		} else {
			(new BAlert("", aLocale -> FindString("text200"), aLocale -> FindString("okbutton") ))->Go();
			exit(1);
		}
	} else {	// Error
	(new BAlert("", aLocale -> FindString("text201"), aLocale -> FindString("okbutton") ))->Go();
		exit(1);
	}
}

//-------------------------------------------------------------------------

void MakeButtonPicture( BPicture*& pic, BView* view, int32 resid, Locale *aLocale) 
{
	BBitmap* bitmap = NULL;
	GetBitmapFromResources( bitmap, resid, aLocale );
	
	//tempview for creating the picture
	BView *tempView = new BView( BRect(0,0,50,50), "temp", B_FOLLOW_NONE, B_WILL_DRAW );
	view->AddChild(tempView);	
	
	// draw the bitmap into the BPicture
	tempView->BeginPicture(new BPicture); 
	tempView->DrawBitmap(bitmap);
	pic = tempView->EndPicture();

	//get rid of tempview
	view->RemoveChild(tempView);
	delete tempView;	
	delete bitmap;
}

//-------------------------------------------------------------------------

int ConvertFontSize( int fontSize ) {

	switch( fontSize ) {
		case 1: return 8; 	break;
		case 2: return 10; 	break;	
		case 3: return 12; 	break;
		case 4: return 14; 	break;
		case 5: return 18; 	break;
		case 6: return 24; 	break;
		case 7: return 38; 	break;					
		default: return 12; break;
	}	
}

//-------------------------------------------------------------------------

void MakeFilenameFromUIN( char *filename, unsigned uin, const char *noun ) {
	sprintf( filename, "%s-%u", noun, uin );
}

//-------------------------------------------------------------------------

ICQStatus StatusA( int32 status ) {

  if(STATUS_OFFLINE == status) /* this because -1 & 0x01FF is not -1 */
    return IS_OFFLINE;

	switch( status & 0x1ff) {
		case STATUS_OFFLINE:
			return IS_OFFLINE;
		case STATUS_ONLINE:
			return IS_AVAILABLE;
//		case STATUS_INVISIBLE:
//			return IS_INVISIBLE;
//		case STATUS_NA_99:
		case STATUS_NA:
			return IS_EXTENDEDAWAY;
		case STATUS_FREEFORCHAT:
			return IS_FREEFORCHAT;
//		case STATUS_OCCUPIED_MAC:
		case STATUS_OCCUPIED:
			return IS_OCCUPIED;
		case STATUS_AWAY:
			return IS_AWAY;
//		case STATUS_DND_99:
		case STATUS_DND:
			return IS_DND;
	}
	PRINT( ("DID NOT FIND A STATUS\n" ) );
	return IS_OFFLINE;
}

//-------------------------------------------------------------------------

int32 StatusB( ICQStatus status ) {

	switch( status ) {
		case IS_PENDING:
		case IS_RECONNECTING:
		case IS_OFFLINE:
			return STATUS_OFFLINE;
		case IS_AVAILABLE:
			return STATUS_ONLINE;
//		case IS_INVISIBLE:
//			return STATUS_INVISIBLE;
		case IS_EXTENDEDAWAY:
			return STATUS_NA;
		case IS_FREEFORCHAT:
			return STATUS_FREEFORCHAT;
		case IS_OCCUPIED:
			return STATUS_OCCUPIED;
		case IS_AWAY:
			return STATUS_AWAY;
		case IS_DND:
			return STATUS_DND;
	}

	return STATUS_OFFLINE;
}

//-------------------------------------------------------------------------

int32 StatusC( ICQStatus status ) {

	switch( status ) {
		case IS_AVAILABLE:
			return 0;
		case IS_FREEFORCHAT:
			return 1;
		case IS_AWAY:
			return 2;
		case IS_EXTENDEDAWAY:
			return 3;
		case IS_OCCUPIED:
			return 4;
		case IS_DND:
			return 5;
		case IS_INVISIBLE:
			return 6;
		case IS_OFFLINE:
			return 7;
		case IS_PENDING:
			return 8;
		default:
			return 7;
	};	
}

//-------------------------------------------------------------------------

char TranslateFromEncoding( uint32 e ) {

	char ret = 'O';
	switch( e ) {
		case B_ISO1_CONVERSION:
			ret = 'A'; break;
		case B_ISO2_CONVERSION:
			ret = 'B'; break;
		case B_ISO3_CONVERSION:
			ret = 'C'; break;
		case B_ISO4_CONVERSION:
			ret = 'D'; break;
		case B_ISO5_CONVERSION:
			ret = 'E'; break;
		case B_ISO6_CONVERSION:
			ret = 'F'; break;
		case B_ISO7_CONVERSION:
			ret = 'G'; break;
		case B_ISO8_CONVERSION:
			ret = 'H'; break;
		case B_ISO9_CONVERSION:
			ret = 'I'; break;
		case B_ISO10_CONVERSION:
			ret = 'J'; break;
		case B_MAC_ROMAN_CONVERSION:
			ret = 'K'; break;
		case B_SJIS_CONVERSION:
			ret = 'L'; break;
		case B_EUC_CONVERSION:
			ret = 'M'; break;
		case B_JIS_CONVERSION:
			ret = 'N'; break;
		case B_MS_WINDOWS_CONVERSION:
			ret = 'O'; break;
		case B_UNICODE_CONVERSION:
			ret = 'P'; break;
		case B_KOI8R_CONVERSION:
			ret = 'Q'; break;
		case B_MS_WINDOWS_1251_CONVERSION:
			ret = 'R'; break;
		case B_MS_DOS_866_CONVERSION:
			ret = 'S'; break;
	}
	return ret;
}

//-------------------------------------------------------------------------

uint32 TranslateToEncoding( char c, GManager *mManager ) {

	if( c == 'o' )
		c = TranslateFromEncoding( mManager -> defEncoding );

	uint32 destEncoding = B_MS_WINDOWS_CONVERSION;
	switch( c ) {
		case 'A':
			destEncoding = B_ISO1_CONVERSION; break;
		case 'B':
			destEncoding = B_ISO2_CONVERSION; break;
		case 'C':
			destEncoding = B_ISO3_CONVERSION; break;
		case 'D':
			destEncoding = B_ISO4_CONVERSION; break;
		case 'E':
			destEncoding = B_ISO5_CONVERSION; break;
		case 'F':
			destEncoding = B_ISO6_CONVERSION; break;
		case 'G':
			destEncoding = B_ISO7_CONVERSION; break;
		case 'H':
			destEncoding = B_ISO8_CONVERSION; break;
		case 'I':
			destEncoding = B_ISO9_CONVERSION; break;
		case 'J':
			destEncoding = B_ISO10_CONVERSION; break;
		case 'K':
			destEncoding = B_MAC_ROMAN_CONVERSION; break;
		case 'L':
			destEncoding = B_SJIS_CONVERSION; break;
		case 'M':
			destEncoding = B_EUC_CONVERSION; break;
		case 'N':
			destEncoding = B_JIS_CONVERSION; break;
		case 'O':
			destEncoding = B_MS_WINDOWS_CONVERSION; break;
		case 'P':
			destEncoding = B_UNICODE_CONVERSION; break;
		case 'Q':
			destEncoding = B_KOI8R_CONVERSION; break;
		case 'R':
			destEncoding = B_MS_WINDOWS_1251_CONVERSION; break;
		case 'S':
			destEncoding = B_MS_DOS_866_CONVERSION; break;
		case 'Z':
			destEncoding = 42;
	}
	return destEncoding;
}

//-------------------------------------------------------------------------

