#include <Debug.h>
#include "ProtocolManager.h"

#include <Autolock.h>
#include <Locker.h>
#include <Message.h>
#include <UTF8.h>
#include <String.h>

#include "AuthorizationWindow.h"
#include "Say.h"
#include "GManager.h"
#include "Prefs.h"
#include "PeopleData.h"
#include "WindowManager.h"
#include "classSoundMaster.h"
#include "Gicq.h"
#include "Locale.h"

// This is the BLooper class that will own and handle all the protocol
//   threads. Other functions that want to send data will send it through
//   this class, which will automatically route it to the correct
//   destination.

// Obviously it is rather lacking in power right now, but give it some time
//   and it will rise to the top.

// After all, like sagas, every class has a beginning...

//-------------------------------------------------------------------------

ProtocolManager::ProtocolManager(GManager *aManager)
		:mUin(0)
		,mNick("")
		,mStrUin("")
		,mManager( aManager )
{
	mLock = new BLocker( "protocol_manager_locker" );
}

//-------------------------------------------------------------------------

ProtocolManager::~ProtocolManager()
{
	delete mLock;
}

//-------------------------------------------------------------------------

void ProtocolManager::SetProgramUser( uint32 aUin )
{
	
	BAutolock a(mLock);

	// load the prefs for this user
	mUin = aUin;
	mStrUin="";
	mStrUin << mUin;
	mManager -> prefs->LoadUserFile( mUin );

	mManager -> list -> SetProgramUser( mUin );	
	mManager -> windows -> SetProgramUser( mUin );

	// enable/disable sounds for this user
	//mManager -> sounds->SetEnabled( mManager -> prefs->ReadBool("gm_ps", true) );
	BMessage msg( GIMICQ_RELOAD_PREF_SETTINGS );
	mManager -> windows -> SendBuddyListMessage( &msg );
	
}

//-------------------------------------------------------------------------

const char *ProtocolManager::GetDisplayName()
{

	BAutolock a(mLock);
	
	if( mNick.String()!="" )
		return mNick.String();
	return mStrUin.String();
}

//-------------------------------------------------------------------------

void ProtocolManager::SetNick( const char *aNick )
{
	BAutolock a(mLock);
	mNick=aNick;
}


//-------------------------------------------------------------------------

uint32 ProtocolManager::GetUin()
{
	return mUin;
}

//-------------------------------------------------------------------------

#warning Change this funcionality.
void ProtocolManager::HandleMessage( BMessage *aMsg )
{

	switch( aMsg->what ) {
	
		case ICQ_AUTH_REQUEST: {
			AuthorizationWindow *w = new AuthorizationWindow(aMsg -> FindString( "NICKNAME" ),
			(uint32)aMsg -> FindInt32( "FROM" ), aMsg -> FindString( "REASON" ), mManager );
			mManager -> windows -> AddGeneralWindow(w);
			w -> Show();
			break;
		}
		
		case ICQ_UPDATE_REPLY:
			if( !aMsg->FindBool( "SUCCESS" ) )
				Say( mManager -> mLocale -> FindString("text210") );
			break;

		case GIMICQ_ONLINE_NOTIFY: {
			BString str_message = "";
			str_message << aMsg->FindString("NICK");
			str_message += " ";
			str_message += mManager -> mLocale -> FindString("text211");
			mManager -> sounds -> PlaySound( WS_TEMP1 );
			Say( str_message.String() );
			break;
		}

	}
}

//-------------------------------------------------------------------------
