#include <Debug.h>
#include "Timezone.h"

#include <time.h>

// A rather cool time zone function written by John Ashmun
// I think it has problems with the few timezones around the world that are half hours, but this is close enough for now
long int timezone_hours( )
{

	time_t	  now = 0;
	long int	diff_hours = 0;
	struct tm  gmt_time;
	struct tm  time_here;
	struct tm* time_result = 0;

	// Get current GMT as the number of seconds since 1969.
	now = time( 0 );

	// Convert to time struct, expressed as local time.
	time_result = localtime( &now );

	time_here.tm_sec = time_result->tm_sec;
	time_here.tm_min = time_result->tm_min;
	time_here.tm_hour = time_result->tm_hour;
	time_here.tm_mday = time_result->tm_mday;
	time_here.tm_mon = time_result->tm_mon;
	time_here.tm_year = time_result->tm_year;
	time_here.tm_wday = time_result->tm_wday;
	time_here.tm_yday = time_result->tm_yday;
	time_here.tm_isdst = time_result->tm_isdst;

	// Convert to time struct, still expressed as GMT.
	time_result = gmtime( &now );

	gmt_time.tm_sec = time_result->tm_sec;
	gmt_time.tm_min = time_result->tm_min;
	gmt_time.tm_hour = time_result->tm_hour;
	gmt_time.tm_mday = time_result->tm_mday;
	gmt_time.tm_mon = time_result->tm_mon;
	gmt_time.tm_year = time_result->tm_year;
	gmt_time.tm_wday = time_result->tm_wday;
	gmt_time.tm_yday = time_result->tm_yday;
	gmt_time.tm_isdst = time_result->tm_isdst;

	// If tm_hour members of the two structs aren't equal,
	// our local time isn't GMT.  Find the difference.
	if( time_here.tm_hour != gmt_time.tm_hour )
	{
		if( time_here.tm_hour > gmt_time.tm_hour )
		{
			if( time_here.tm_mday < gmt_time.tm_mday )
			{
				// We're West of Greenwich
				diff_hours = time_here.tm_hour - (gmt_time.tm_hour + 24);
				if( time_here.tm_isdst > 0 )
					diff_hours += 1;
			}
			else
			{
				// We're East of Greenwich
				diff_hours = time_here.tm_hour - gmt_time.tm_hour;
				if( time_here.tm_isdst > 0 )
					diff_hours -= 1;
			}
		}
		else
		{
			if( time_here.tm_mday > gmt_time.tm_mday )
			{
				// We're East of Greenwich
				diff_hours = time_here.tm_hour + 24 - gmt_time.tm_hour;
				if( time_here.tm_isdst > 0 )
					diff_hours -= 1;
			}
			else
			{
				// We're West of Greenwich
				diff_hours = time_here.tm_hour - gmt_time.tm_hour;
				if( time_here.tm_isdst > 0 )
					diff_hours -= 1;
			}
		}
	}

	return diff_hours;
}
