#ifndef BUDDY_LIST_H
#define BUDDY_LIST_H

#include <Window.h>
#include <View.h>
#include <OutlineListView.h>
#include <MenuItem.h>
#include <TabView.h>

#include "ICQStatus.h"

class BRect;
class BPoint;
class BMessage;
class BMenuBar;
class BMenu;
class BPopUpMenu;
class BScrollView;
class BitmapView;

class GManager;
class Locale;

class ClickableListView : public BOutlineListView
{

	friend class BuddyList;	
	
	public:
		ClickableListView( BRect, const char*, list_view_type, uint32, GManager *the_manager );
		~ClickableListView();
		virtual void MouseDown( BPoint cursor );
		virtual void MessageReceived( BMessage *message );
		virtual void MouseMoved(BPoint point, uint32 transit, const BMessage *message);
				
	private:
		BMenuItem* onItem;
		BPopUpMenu* userPopup;
		GManager *mManager;
};

enum {

	BOOKMARK = 1,
	BOOKMARKFILE,
	TEXT

};
//-------------------------------------------------------------------------


class BuddyListView : public BView
{
	friend class BuddyList;

	public:
		BuddyListView(BRect rect, GManager *mManager);
		void DoResizeStuff( float width, float height );
		
	protected:
		virtual void Draw( BRect );

	private:
		BScrollView* scroller;
		ClickableListView* online;
};

//-------------------------------------------------------------------------

class BuddyListStatusItem : public BMenuItem
{
	public:
		BuddyListStatusItem(const char *label,BBitmap *bitmap,char shortcut = 0,uint32 modifiers = 0);
		virtual void DrawContent();
	
	private:
		BBitmap *fBitmap;
};

//-------------------------------------------------------------------------

class BuddyListStatusView : public BView 
{
	friend class BuddyList;

	public:
		BuddyListStatusView( BRect frame, GManager *the_manager );
		virtual void Draw( BRect );
		virtual void MouseDown( BPoint cursor );
		virtual void Pulse();
		virtual void DetachedFromWindow(void);
		ICQStatus status;
		
	private:
		BPopUpMenu* userPopup;
		ICQStatus oldStatus;
		bool doIdleTime;
		bool wasIdle;
		
		GManager *mManager;
		Locale *mLocale;
};



//-------------------------------------------------------------------------


class BuddyListInfoView : public BView 
{
	friend class BuddyList;
	friend class BuddyListStatusView;

	public:
		BuddyListInfoView(BRect frame, GManager *the_manager);
		virtual void Pulse();

	private:
		void DoIdleStuff();
		unsigned idleCount;
		bool doIdleTime;
		
		GManager *mManager;
};


//-------------------------------------------------------------------------

class BuddyList : public BView  
{

	public:
		BuddyList(BRect frame, GManager *the_manager);
		BuddyList(BMessage *archive);
		~BuddyList();
		
		virtual status_t Archive(BMessage *data, bool deep = true) const;
		static BArchivable *Instantiate(BMessage *archive);
		virtual void MessageReceived( BMessage *message );
		virtual void AttachedToWindow(void);
		virtual void DetachedFromWindow(void);

	private:
	
		bool is_replicant;
		unsigned int last_user_uin;
		
		void DoGlobalPrefs();
		void LoadPrefs();

		// these startup and shutdown for the entire app
		void DoGimICQStartupStuff();
		void DoGimICQShutdownStuff();
		void DoDeskbarIcon( bool install );	 

		void Logout();
		void Init();
				
		BMenuBar *menubar;
		BuddyListView* onlineview;
		BuddyListStatusView* statView;
		BitmapView* logoView;
		BuddyListInfoView* iView;
	
		BMenu *beMenu;
		BMenuItem *loginMenuItem;
		BMenuItem *logoutMenuItem;
		
		BRect buddy_bounds;
		
		GManager *mManager;
		Locale *mLocale;
};

class BuddyWindow : public BWindow {

	public:
		BuddyWindow(BRect frame, GManager *mManager);
		~BuddyWindow();
		virtual bool QuitRequested();
		
	private:
	
		GManager *mManager;
};

//-------------------------------------------------------------------------


#endif //BUDDY_LIST_H
