#ifndef HISTORYWINDOW_H
#define HISTORYWINDOW_H

#include <Window.h>
#include <UTF8.h>
#include <String.h>

class BMessage;

struct chatEntry;
class FancyTextView;
class GManager;
class Locale;

const uint32 CLOSE_HISTORY_WINDOW = 'ClHW';
const uint32 CLEAR_HISTORY_IO     = 'CHIO';

class HistoryWindow : public BWindow {

	public:
		HistoryWindow(unsigned int a_uin, unsigned int a_own_uin, GManager *the_manager, uint32 encoding = B_MS_WINDOWS_CONVERSION);
		~HistoryWindow();
		
		virtual void MessageReceived(BMessage *message);
		virtual bool QuitRequested();
		virtual void FrameResized(float width, float height);
		

	private:
		
		void DisplayDateTime(time_t time);
		void ProcessIncomingIM( BMessage*, time_t time );
		void ProcessIncomingURL( BMessage*, time_t time );
		void AddMyStatement( const char* statement, time_t time );
		void DisplaySentURL( BMessage*, time_t time );
		void SetEncoding( uint32 encoding );
		void FixLineBreaks( char* buffer, const char* input );
		
		FancyTextView *textview;

		unsigned int uin, own_uin;
		BString nick, own_nick;
		bool linksEnabled;
		
		uint32 useEncoding;

		GManager *mManager;
		Locale *mLocale;
};

#endif

