#include <Debug.h>
#include "InfoWindow.h"

#include <StringView.h>
#include <ScrollView.h>
#include <Box.h>
#include <String.h>

#include <string.h>

#include "GButton.h"
#include "NotesEditor.h"
#include "BuddyList.h"
#include "BarberPole.h"
#include "GManager.h"
#include "Gicq.h"
#include "WindowManager.h"
#include "Locale.h"

const uint32 NOTES_MODIFIED = 'nMdf';
const uint32 OPEN_NOTES = 'oNTS';

//=========================================================================

InfoTextView::InfoTextView( BRect frame, const char *name, BRect textRect, uint32 resizingMode, uint32 flags )
			: BTextView( frame, name, textRect, resizingMode, flags )
{

	PRINT(("InfoTextView::InfoTextView\n"));
	modified = false;
}

//-------------------------------------------------------------------------

void InfoTextView::InsertText(const char *text, int32 length, int32 offset, 
							  const text_run_array *runs )
{
	PRINT(("InfoTextView::InsertText\n"));
	modified = true;
	BTextView::InsertText( text, length, offset, runs );
}

//-------------------------------------------------------------------------

void InfoTextView::DeleteText( int32 start, int32 finish ) {

	PRINT(("InfoTextView::DeleteText\n"));
	modified = true;
	BTextView::DeleteText( start, finish );
}

//-------------------------------------------------------------------------

void InfoTextView::SetText2( char* text ) {

	PRINT(("InfoTextView::SetText2\n"));
	SetText( text );
	modified = false;
}

//=========================================================================

InfoWindow::InfoWindow( BRect frame, unsigned u, const char* nick, GManager *the_manager )
				: BWindow(frame, "", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE )
{

	PRINT(("InfoWindow::InfoWindow\n"));
	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;

	BString windowTitle;
	alldone = false;

	// do some name stuff
	uin = u;
	displayName = nick;
	windowTitle = _("text80");
	windowTitle += ": ";
	windowTitle += displayName;
	SetTitle( windowTitle.String() );
	
	// Make the message to request the info
#if 0
	BMessage* infMessage = new BMessage( ICQ_USER_INFO );
	infMessage->AddInt32( "UIN", (int32)uin );
	mManager -> icq -> PostMessage( infMessage );
	delete infMessage;
#endif
	BMessage* infMessage = new BMessage( ICQ_USER_EXTINFO );
	infMessage->AddInt32( "UIN", (int32)uin );
	if( mManager -> icq -> LockLooper() ) {
		mManager -> icq -> PostMessage( infMessage );
		mManager -> icq -> UnlockLooper();
	}
	delete infMessage;

	// make the background view 
	BRect rect = Bounds();
	iView = new InfoView( rect, "InfoView", u , mManager ); 
	
	// add the view to the window 
	AddChild(iView);
	
	// Tell the main app that the window has been opened
	BMessage* sendMessage = new BMessage( GIMICQ_IM_WINDOW_OPENED );
	sendMessage->AddInt32( "uin", (int32)uin );
	sendMessage->AddInt32( "wtype", (int32)USER_INFO_TYPE );
	sendMessage->AddPointer( "new_window", this );
	mManager -> windows -> SendBuddyListMessage( sendMessage );
}

//-------------------------------------------------------------------------

bool InfoWindow::QuitRequested()
{

	PRINT(("InfoWindow::QuitRequested\n"));
	// get rid of the spinner
	if( iView->spinner ) {
		iView->spinner->Stop();
		iView->spinner->RemoveSelf();
		delete iView->spinner;
	}
	
	mManager -> windows -> getBuddyList() -> LockLooper();

	// Tell the main app that the window has been closed
	BMessage* sendMessage = new BMessage( GIMICQ_IM_WINDOW_CLOSED );
	sendMessage->AddInt32( "wtype", (int32)USER_INFO_TYPE );
	sendMessage->AddInt32( "uin", (int32)uin );
	if(mManager -> windows != NULL)
		mManager -> windows -> SendBuddyListMessage( sendMessage );
/*
	if( alldone ) {
		if( iView->shouldUpdate && mManager -> windows != NULL)
			mManager -> windows -> SendBuddyListMessage( iView->updateMsg );
			//Say( "stuff" );
	}		
*/
	mManager -> windows -> getBuddyList() -> UnlockLooper();
	return true;
}

//-------------------------------------------------------------------------

void InfoWindow::MessageReceived( BMessage* msg ) {

	PRINT(("InfoWindow::MessageReceived\n"));
	switch( msg->what ) {

		case ICQ_USER_INFO:
			iView->UpdateDisplay( msg );
			alldone = true;		
			break;
			
		case ICQ_USER_EXTINFO:
			iView->UpdateDisplay2( msg );
			break;

		case B_CANCEL:
		case GIMICQ_CLOSE_WINDOW:
			QuitRequested();
			Close();
			break;
			
		case GIMICQ_TRY_ADD_PERSON:
			AddPerson();
			break;
			
		case GIMICQ_ADD_PERSON:
			mManager -> windows -> SendBuddyListMessage(msg);
			break;
			
		case OPEN_NOTES: {
			BRect rect( 0, 0, 300, 200 );
			mManager -> windows->MakeDialogFrame( rect, this );
			NotesEditor* ne = new NotesEditor( rect, uin, displayName.String() , mManager );
			mManager -> windows -> AddGeneralWindow(ne);
			ne->Show();
			break;
		}
			
		default:
			BWindow::MessageReceived( msg );
			break;
	}
}

//-------------------------------------------------------------------------

// the cancel function
void InfoWindow::DispatchMessage( BMessage* msg, BHandler* handler ) {

//	PRINT(("InfoWindow::DispatchMessage\n"));
	// if it's a cancel key, post a B_CANCEL message
	if( msg->what == B_KEY_DOWN )
		if( msg->HasString("bytes") && msg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( new BMessage(B_CANCEL) );
			return;
		}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( msg, handler );
}

//-------------------------------------------------------------------------

void InfoWindow::AddPerson() {

	PRINT(("InfoWindow::AddPerson\n"));
	/*
	// tweak the frame and open the dialog
	windows->MakeDialogFrame( frame, this );
 	dlg = new PersonAddEditWindow( frame, this, ET_ADDPERSON, NULL );
 	dlg->SetInitialName( displayName );
 	dlg->SetNow( true );
 	windows -> AddGeneralWindow(dlg);
 	dlg->Show();
 	*/
 	
	BMessage* sndMessage = new BMessage(GIMICQ_ADD_PERSON);
 	sndMessage->AddInt32( "UIN", (int32)uin );
 	if( displayName[0] != '\0' )
 		sndMessage->AddString( "NICKNAME", displayName.String() );
 	mManager -> windows -> SendBuddyListMessage(sndMessage);
	iView->shouldUpdate = false;
}

//=========================================================================

InfoView::InfoView( BRect rect, const char *name, unsigned u , GManager *the_manager)
	   	   : BView(rect, name, B_FOLLOW_ALL, B_WILL_DRAW)
{

	PRINT(("InfoView::InfoView\n"));
	mManager = the_manager;
	mLocale = mManager -> mLocale;

	SetViewColor( 216, 216, 216 );
	uin = u;
	updateMsg = NULL;
	shouldUpdate = true;
}

//-------------------------------------------------------------------------

void InfoView::AttachedToWindow() {

	PRINT(("InfoView::AttachedToWindow\n"));
	BTabView *tabView;
	BTab *infoTab, *notesTab, *extTab;
	BRect labelFrame1, labelFrame2;
	BStringView* notesLabel;
	
	BString temp, n_a_str( _("n_alabel") );	
	temp = "";
	
	// make the tab view
	BRect r = Bounds();	
	r.InsetBy( 4, 4 );
	r.bottom -= (56 + 15);
	tabView = new BTabView(r, "tab_view"); 
	tabView->SetViewColor( 216, 216, 216 );
	AddChild( tabView );	
	
	// make the main info view
	BRect rect = BRect(5,1,325,145);
	BView* infoView = new BView( rect, "infoView", B_FOLLOW_NONE, 0 );
	infoView->SetViewColor( 216, 216, 216 );
	//AddChild( infoView );

	// make the ext view
	rect = BRect(5,1,325,145);
	BView* extView = new BView( rect, "extView", B_FOLLOW_NONE, 0 );
	extView->SetViewColor( 216, 216, 216 );

	// make the notes view
	rect = BRect(0,1,330,149);
	BView* notesView = new BView( rect, "notesView", B_FOLLOW_NONE, 0 );
	notesView->SetViewColor( 216, 216, 216 );
	//AddChild( notesView );

	// first tab
	infoTab = new BTab(); 
	tabView->AddTab( infoView, infoTab ); 
	infoTab->SetLabel( _("label1") ); 

	// second tab
	extTab = new BTab(); 
	tabView->AddTab( extView, extTab );
	extTab->SetLabel( _("label2") );

	// third tab
	notesTab = new BTab(); 
	tabView->AddTab( notesView, notesTab ); 
	notesTab->SetLabel( _("label3") );
	
	// make the notes editor/label
	BFont chatFont = be_plain_font;
	chatFont.SetSize( 12.0 );
	BRect txbounds = notesView->Bounds();
	txbounds.InsetBy(8,6);
	txbounds.top += 16;
	txbounds.bottom -= 2;
	txbounds.right -= B_V_SCROLL_BAR_WIDTH;
	BRect txrect = txbounds;
	txrect.OffsetTo(0,0);
	txrect.InsetBy(4,4);
	notes = new BTextView( txbounds, "notes", txrect, B_FOLLOW_NONE, B_PULSE_NEEDED | B_WILL_DRAW );
	notes->MakeEditable(false);	
	notes->SetStylable(false);
	notes->SetFontAndColor( &chatFont );
	notes->SetMaxBytes( 16384 );
	notes->SetViewColor(230,230,230);
	notes->MakeSelectable(false);
	temp = _("label20");
	temp.Append(":");
	notesLabel = new BStringView( BRect(8,0,300,20), "label2", temp.String() );
	notesLabel->SetFontSize(12);
	notesLabel->SetFont( be_bold_font );
	notesView->AddChild( notesLabel );
	notesView->AddChild(notes_scroller = new BScrollView("notes_scroll_view", notes,
						B_FOLLOW_NONE, 0, false, true ));

	// Make the box frame
	BRect boxFrame = infoView->Bounds();
	boxFrame.InsetBy(8,6);
	boxFrame.bottom = 118;
	
	// set up the label frames
	labelFrame1 = boxFrame;
	labelFrame1.InsetBy( 12, 15 );
	labelFrame1.bottom = labelFrame1.top + 20;
	labelFrame2 = labelFrame1;
	labelFrame2.right += 15;
	labelFrame2.left = Bounds().Width() / 2 - 35;
	
	// make lots of labels
	temp = _("label21");
	temp.Append(":");
	label1 = new BStringView( labelFrame1, "label1", temp.String() );
	label1->SetFont(be_bold_font);
	label1->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	infoView->AddChild( label1 );
	
	temp = "";
	temp << uin;
	label2 = new BStringView( labelFrame2, "label2", temp.String() );
	label2->SetFont(be_plain_font);
	label2->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	infoView->AddChild( label2 );
	
	temp = _("label22");
	temp.Append(":");
	label3 = new BStringView( labelFrame1, "label3", temp.String() );
	label3->SetFont(be_bold_font);
	label3->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	infoView->AddChild( label3 );

	label4 = new BStringView( labelFrame2, "label4", n_a_str.String() );
	label4->SetFont(be_plain_font);
	label4->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	infoView->AddChild( label4 );
	
	temp = _("label23");
	temp.Append(":");
	label5 = new BStringView( labelFrame1, "label5", temp.String() );
	label5->SetFont(be_bold_font);
	label5->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	infoView->AddChild( label5 );

	label6 = new BStringView( labelFrame2, "label6", n_a_str.String() );
	label6->SetFont(be_plain_font);
	label6->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	infoView->AddChild( label6 );	
	
	temp = _("label24");
	temp.Append(":");
	label7 = new BStringView( labelFrame1, "label7", temp.String() );
	label7->SetFont(be_bold_font);
	label7->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	infoView->AddChild( label7 );

	label8 = new BStringView( labelFrame2, "label8", n_a_str.String() );
	label8->SetFont(be_plain_font);
	label8->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	infoView->AddChild( label8 );

	temp = _("label25");
	temp.Append(":");
	label9 = new BStringView( labelFrame1, "label9", temp.String() );
	label9->SetFont(be_bold_font);
	label9->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	infoView->AddChild( label9 );

	label10 = new BStringView( labelFrame2, "label10", n_a_str.String() );
	label10->SetFont(be_plain_font);
	label10->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	infoView->AddChild( label10 );	
	
	temp = _("label26");
	temp.Append(":");
	label11 = new BStringView( labelFrame1, "label9", temp.String() );
	label11->SetFont(be_bold_font);
	label11->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	infoView->AddChild( label11 );

	label12 = new BStringView( labelFrame2, "label10", n_a_str.String() );
	label12->SetFont(be_plain_font);
	label12->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	infoView->AddChild( label12 );
	
	
	
	
	
	
	// Make the box frame
	boxFrame = extView->Bounds();
	boxFrame.InsetBy(8,6);
	boxFrame.bottom = 118;
	
	// set up the label frames
	labelFrame1 = boxFrame;
	labelFrame1.InsetBy( 12, 15 );
	labelFrame1.bottom = labelFrame1.top + 20;
	labelFrame2 = labelFrame1;
	labelFrame2.right += 15;
	labelFrame2.left = Bounds().Width() / 2 - 35;
	
	// make lots of labels
	temp = _("label27");
	temp.Append(":");
	Label1 = new BStringView( labelFrame1, "label1", temp.String() );
	Label1->SetFont(be_bold_font);
	Label1->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	extView->AddChild( Label1 );
	
	Label2 = new BStringView( labelFrame2, "label2", n_a_str.String() );
	Label2->SetFont(be_plain_font);
	Label2->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	extView->AddChild( Label2 );
	
	temp = _("label28");
	temp.Append(":");
	Label3 = new BStringView( labelFrame1, "label3", temp.String() );
	Label3->SetFont(be_bold_font);
	Label3->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	extView->AddChild( Label3 );

	Label4 = new BStringView( labelFrame2, "label4", n_a_str.String() );
	Label4->SetFont(be_plain_font);
	Label4->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	extView->AddChild( Label4 );
	
	temp = _("label29");
	temp.Append(":");
	Label5 = new BStringView( labelFrame1, "label5", temp.String() );
	Label5->SetFont(be_bold_font);
	Label5->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	extView->AddChild( Label5 );

	Label6 = new BStringView( labelFrame2, "label6", n_a_str.String() );
	Label6->SetFont(be_plain_font);
	Label6->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	extView->AddChild( Label6 );	
	
	temp = _("label30");
	temp.Append(":");
	Label7 = new BStringView( labelFrame1, "label7", temp.String() );
	Label7->SetFont(be_bold_font);
	Label7->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	extView->AddChild( Label7 );

	Label8 = new BStringView( labelFrame2, "label8", n_a_str.String() );
	Label8->SetFont(be_plain_font);
	Label8->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	extView->AddChild( Label8 );
	
	temp = _("label31");
	temp.Append(":");
	Label11 = new BStringView( labelFrame1, "label9", temp.String() );
	Label11->SetFont(be_bold_font);
	Label11->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	extView->AddChild( Label11 );

	Label12 = new BStringView( labelFrame2, "label10", n_a_str.String() );
	Label12->SetFont(be_plain_font);
	Label12->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	extView->AddChild( Label12 );	

	temp = _("label32");
	temp.Append(":");
	Label9 = new BStringView( labelFrame1, "label9", temp.String() );
	Label9->SetFont(be_bold_font);
	Label9->SetFontSize(12);
	labelFrame1.top += 18;
	labelFrame1.bottom += 18;
	extView->AddChild( Label9 );

	Label10 = new BStringView( labelFrame2, "label10", n_a_str.String() );
	Label10->SetFont(be_plain_font);
	Label10->SetFontSize(12);
	labelFrame2.top += 18;
	labelFrame2.bottom += 18;
	extView->AddChild( Label10 );	

	

	
	boxFrame.bottom += 18;
	ResizeBy( 0, 18 );
	Window()->ResizeBy( 0, 18 );
	
	// make the box
	temp = _("label33");
	temp << ":";
	BBox* infoBox = new BBox( boxFrame );
	infoBox->SetLabel( temp.String() );
	infoView->AddChild( infoBox );	
	
	temp = _("label34");
	temp << ":";
	infoBox = new BBox( boxFrame );
	infoBox->SetLabel( temp.String() );
	extView->AddChild( infoBox );		

	// make some buttons
	BRect button_rect(Bounds().right-68, tabView -> Bounds().bottom + 10, Bounds().right-8, tabView -> Bounds().bottom + 34 );
	
	closeButton = new GButton( button_rect, "close", _("closebutton") , new BMessage(GIMICQ_CLOSE_WINDOW), B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM );
	closeButton->MakeDefault( true );
	
	button_rect.right = Bounds().right - closeButton -> Bounds().Width() - 10;
	button_rect.left  = button_rect.right - 10;
	addToListButton = new GButton( button_rect, "add", _("addbutton") , new BMessage(GIMICQ_TRY_ADD_PERSON), B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM );
	addToListButton->SetEnabled(false);

	temp = _("notesbutton");
	temp.Append(B_UTF8_ELLIPSIS);
	button_rect.left = Bounds().left + 3;
	notesButton = new GButton( button_rect , "notes", temp.String() , new BMessage(OPEN_NOTES) );

	// make the stats view
	BRect statFrame = Bounds();
	statFrame.top = tabView -> Bounds().bottom + 44;
	statFrame.bottom = tabView -> Bounds().bottom + 58;
	statView = new GStatusView( statFrame, mManager );

	// make the spinner
	spinner = new BarberPole( BRect(4,4,50,11), "spinner", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW );
	spinner->SetHighColor(0,128,0);
	statView->AddChild( spinner );

	// add a vanilla "waiting" message so the user isn't left hanging
	//profile->Insert( "Waiting for response..." );


	// add the views
	AddChild( notesButton );
	AddChild( addToListButton );
	AddChild( closeButton );
	AddChild( statView );
	
	spinner->Start();
	tabView->Select( 0 );
}

//-------------------------------------------------------------------------

void InfoView::UpdateDisplay( BMessage* msg ) {

	PRINT(("InfoView::UpdateDisplay\n"));
	InfoWindow* window = dynamic_cast<InfoWindow*>(Window());
	
	// UIN
	if( msg->HasInt32("UIN") ) {
		BString labelTitle;
		labelTitle << (unsigned) msg->FindInt32("UIN");
		label2->SetText( labelTitle.String() );
	}

	// nick name
	if( msg->HasString("NICKNAME") ) {
		window->displayName = msg->FindString("NICKNAME");
		label4->SetText( msg->FindString("NICKNAME") );
		updateMsg = new BMessage(GIMICQ_UPDATE_INFO);
		updateMsg->AddInt32( "UIN", (unsigned)msg->FindInt32("UIN") );
		updateMsg->AddString( "NICKNAME", msg->FindString("NICKNAME") );
	}

	// first name
	if( msg->HasString("FIRSTNAME") ) {
		label6->SetText( msg->FindString("FIRSTNAME") );
	}

	// last name
	if( msg->HasString("LASTNAME") ) {
		label8->SetText( msg->FindString("LASTNAME") );
	}
	
	// email
	if( msg->HasString("EMAIL") ) {
		label10->SetText( msg->FindString("EMAIL") );
	}
	
	// auth needed
	if( msg->HasBool("REQACK") ) {
		label12->SetText( msg->FindBool("REQACK") ? "Yes" : "No" );
	}

	statView->SetDone1();
	addToListButton->SetEnabled(true);	
	if( statView->AllDone() && spinner ) {
		spinner->Stop();
		spinner->RemoveSelf();
		delete spinner;
		spinner = 0;
	}
}

//-------------------------------------------------------------------------

void InfoView::UpdateDisplay2( BMessage* msg ) {

	PRINT(("InfoView::UpdateDisplay2\n"));
#warning change to BString!!
	char temp[500];
	temp[0] = '\0';
	bool go = false, go2 = false;

	// homepage
	if( msg->HasString("HOMEPAGE") ) {
		Label2->SetText( msg->FindString("HOMEPAGE") );
	}

	// city
	if( msg->HasString("CITY") ) {
		//label8->SetText( (char*)msg->FindString("LASTNAME") );
		strcat( temp, msg->FindString("CITY") );
		go2 = true;
	}
	
	// state
	if( msg->HasString("STATE") ) {
		if( temp[0] )
			strcat( temp, ", " );
		strcat( temp, msg->FindString("STATE") );
		go = true;
		go2 = true;
	}
	
	// country
#if 0
	if( msg->HasInt32("ZIPCODE") ) {
		if( msg->FindInt32("ZIPCODE") != 0 ){ 
			if( go )
				strcat( temp, "  " );
			char bump[100];
			sprintf( bump, "%ld", msg->FindInt32("ZIPCODE") );
			strcat( temp, bump );
			go2 = true;
		}
	}
#endif
	if( msg->HasString("ZIP") ) {
		if( go )
			strcat( temp, "  " );
		strcat( temp, msg->FindString( "ZIP" ) );		
		go2 = true;
	}
	if( go2 )
		Label4->SetText( temp );
	
	// country
	if( msg->HasString("COUNTRYNAME") ) {
		Label6->SetText( msg->FindString("COUNTRYNAME") );
	}
	
	// phone no
	if( msg->HasString("PHONENUMBER") ) {
		Label8->SetText( msg->FindString("PHONENUMBER") );
	}
	
	// country
	if( msg->HasInt32("TIMEZONE") ) {
		if( msg->FindInt32("TIMEZONE") != -50 ) {
			char bump[300];
			char t2[5];
			t2[0] = '\0';
			if( msg->FindInt32("TIMEZONE") >= 0 )
				strcat( t2, "+" );
			sprintf( bump, "GMT %s%ld hours", t2, msg->FindInt32("TIMEZONE") );
			Label12->SetText( bump );
			go2 = true;
		}
	}	
	
	go = false;
	temp[0] = '\0';
	
	// age
	if( msg->HasInt32("AGE") ) {
		if( msg->FindInt32("AGE") != 0 ) {
			char bump[100];
			sprintf( bump, "%ld", msg->FindInt32("AGE") );
			strcat( temp, bump );
			go = true;
		}
	} else
		strcpy( temp, "Unknown" );

	// sex
	strcat( temp, "/" );
	if( msg->HasInt32("SEX") ) {
		switch( msg->FindInt32("SEX") ) {
			case ICQ_SEX_MALE: strcat( temp, "Male" );
				break;
			case ICQ_SEX_FEMALE: strcat( temp, "Female" );
				break;
			case ICQ_SEX_UNKNOWN:
			default: strcat( temp, "Unknown" );
				break;
		};
		go = true;
	} else
		strcat( temp, "Unknown" );

	if( go )
		Label10->SetText( temp );
		
	// profile
	if( msg->HasString("PROFILE") ) {
		char prof[500];
		FixLineBreaks( prof, const_cast<char*>(msg->FindString("PROFILE")) );
		notes->SetViewColor(255,255,255);
		notes->SetText( prof, strlen(prof) );
		notes->MakeSelectable(true);
		notes->Invalidate();
	}

	statView->SetDone2();
	if( statView->AllDone() && spinner ) {
		spinner->Stop();
		spinner->RemoveSelf();
		delete spinner;
		spinner = 0;
	}
}

//-------------------------------------------------------------------------

void InfoView::FixLineBreaks( char* buffer, char* input ) {

	PRINT(("InfoView::FixLineBreaks\n"));
	// Used to grab bytes
	char c, next;

	// position pointer for the buffer
	int i = 0;

    // Loop thru, grabbing bytes as we go
    while( (*input) != 0 ) {

	   c = (*input);
       if( c == CR ) {

         // attempt to get the next byte of input to see whether it's a
         // CR/LF pair (dos), or just a CR (mac)
         if( (next = *(input+1)) != 0 ) {

             // It's a CR/LF (dos), so the line has ended
             if( next == LF ) {
				buffer[i++] = '\n';
				input += 2;
				continue;
             }

             // Just a CR... put the next character onto the line and return it
             // Need to move the position back a byte so the first character
             // of the next line doesn't get lost!
             buffer[i++] = '\n';
             input++;
             continue;

         } else {    // couldn't get next byte; therefore the input stream is eof

			buffer[i++] = '\0';
			return;
         }
       }

       // If it's an LF, the line has ended no matter what the format.
       if( c == LF ) {

			buffer[i++] = '\n';
         	input++;
			continue;
       }

       // This byte is nothing special. Stick it onto the line.
       buffer[i++] = c;
       input++;
    }

    // apparently the input is now eof
    buffer[i++] = '\0';
}


//=========================================================================

GStatusView::GStatusView(BRect rect, GManager *the_manager)
	   	   : BView(rect, "BuddyListStatus", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_BOTTOM, B_WILL_DRAW )
{

	PRINT(("GStatusView::GStatusView\n"));
	SetFontSize(12);
	SetViewColor( 230, 230, 230 );
	done1 = false;
	done2 = false;
	
	mLocale = the_manager -> mLocale;

	showString = _("text93"); 
	showString += B_UTF8_ELLIPSIS;
}

//-------------------------------------------------------------------------

void GStatusView::Draw( BRect ) {

	PRINT(("GStatusView::Draw\n"));
	BRect frame = Bounds();

	SetHighColor( 156, 154, 156 );		// dark grey
	BPoint start = frame.LeftTop();
	BPoint end = frame.RightTop();
	StrokeLine( start, end );
	
	SetHighColor( 0, 0, 0 );
	SetLowColor( 222, 219, 222 );
	SetFont(be_plain_font);	
	SetFontSize(11);
	
	if( !AllDone() )
		MovePenTo(frame.left + 60, frame.bottom-2);
	else
		MovePenTo(frame.left + 4, frame.bottom-2);
	
	DrawString( showString.String() );
}

//-------------------------------------------------------------------------

void GStatusView::MouseDown( BPoint point ) {
	
	PRINT(("GStatusView::MouseDown\n"));
	BView::MouseDown( point );
}

//-------------------------------------------------------------------------

void GStatusView::SetDone1() {

	PRINT(("GStatusView::SetDone1\n"));
	done1 = true;
	BString temp;
	if( done2 )
		temp = _("text90");
	else {
		temp = _("text91");
		temp += B_UTF8_ELLIPSIS;
	}

	showString = temp.String();
	Invalidate();
}

//-------------------------------------------------------------------------

void GStatusView::SetDone2() {

	PRINT(("GStatusView::SetDone2\n"));
	done2 = true;
	BString temp;
	if( done1 )
		temp = _("text90");
	else {
		temp = _("text92");
		temp += B_UTF8_ELLIPSIS;
	}
	
	showString = temp.String();
	Invalidate();
}

//=========================================================================
