#ifndef _TRAY_ICON_H_
#define _TRAY_ICON_H_

#ifdef _EXPORT
class _EXPORT TrayIcon;
#endif

#include <View.h>
#include <String.h>

#include "GenList.h"
#include "ICQStatus.h"

class BRect;
class BMessage;
class BHandler;
class BBitmap;
class BMessageRunner;
class BMenuItem;

struct flashItem {
	BString display;
	unsigned uin;
	int count;
};

class TrayIcon : public BView
{
	public:
	
		// constructors - second one is a BArchivable constructor
		TrayIcon( BRect frame, BBitmap* active, BBitmap* inactive );
		TrayIcon( BMessage *archive );
		
		// destructor
		virtual ~TrayIcon();
		
		// standard handlers
		virtual void MessageReceived(BMessage *);		
		virtual void AttachedToWindow(void);
		virtual void Draw( BRect updateRect );
		virtual void MouseDown(BPoint);	
		
		// replicant stuff
		virtual status_t Archive( BMessage *archive, bool=true ) const;
		static TrayIcon *Instantiate( BMessage *archive );
		virtual BHandler *RecipientHandler() { return (BHandler *)this; }
		
	private:

		// keeps track of "flashy" events
		GenList<flashItem> flashes;

		// flash stuff
		void SetFlash( BMessage* msg );
		void FlashOn();
		void FlashOff();
		void Flash();
		
		BBitmap* ActiveIcon;
		BBitmap* InactiveIcon;
		BMessageRunner* runner;
		bool iconOn, flashing, doFlash;
		unsigned flashCount;
		ICQStatus status;
		
		BMenuItem* stat1;
		BMenuItem* stat2;
		BMenuItem* stat3;
		BMenuItem* stat4;
		BMenuItem* stat5;
		BMenuItem* stat6;
		BMenuItem* stat7;
};

#endif

