#ifndef _UpdateInfo_H_
#define _UpdateInfo_H_

#include <Window.h>
#include <MenuItem.h>

#include "PList.h"

class BView;
class BTextControl;
class BMenuField;
class BMenuItem;
class BScrollView;
class BTextView;

class GButton;
class GManager;

const uint32 YESNO_MSG = 'YsNo';
const uint32 COUNTRY_MSG = 'CnRg';
const uint32 SEX_MSG = 'SEX!';

class CountryMenuItem : public BMenuItem {
	public:
		CountryMenuItem( unsigned short cd, const char *label, BMessage *msg )
		: BMenuItem( label, msg ) { code = cd; };
		unsigned short GetCode() { return code; };
	private:
		unsigned short code;
};

class UpdateInfoWindow : public BWindow
{
	protected:
	
		BView			*regView;
		BView			*extView;
		BView			*profView;
	
		BView			*windowBack;
		BTextControl	*nickEdit;
		BTextControl	*firstEdit;
		BTextControl	*lastEdit;
		BTextControl	*emailEdit;
		BTextControl	*cityEdit;
		BTextControl	*stateEdit;
		BTextControl	*ageEdit;
		BMenuField		*sexEdit;
		BTextControl	*zipEdit;
		BTextControl	*phoneEdit;
		BTextControl	*webEdit;
		BMenuField		*authRequired;
		BMenuField		*countryEdit;
		GButton			*updateButton;
		GButton			*cancelButton;
		BMenuItem		*yesItem;
		BMenuItem		*noItem;
		BMenuItem		*maleItem;
		BMenuItem		*femaleItem;
		BMenuItem		*unknownItem;
		BScrollView		*profilescroller;		
		BTextView		*profile;
		PList<CountryMenuItem> countryItems;
		bool auth;
		unsigned short country;
		
		virtual void DispatchMessage( BMessage* msg, BHandler* handler );
		virtual bool QuitRequested();
		void Save();
	
	private:
		
		GManager *mManager;
	
	public:
		UpdateInfoWindow( BRect frame, GManager *the_manager );
		void MessageReceived( BMessage * );
		void Load();
};

#endif
