/*
classSoundMaster.cpp

By: Sean Heber (bigzaphod@legions.com)
Come and visit a cool site:  http://www.legions.com/

You are free to use this class for anything you want.  All that I ask is that
you please credit me and/or e-mail me and let me know what you're doing with it.

Also, if you are distributing source with your application, please keep this
comment and add a note with any changes you may have made to the class and how
it works.

As is standard, I take no responsibility if this causes any damage at all.  No matter what.  Forever.

(Note that this is not being released under the GPL or anything like that, so feel
 free to use it in a commercial program if you want.  I'll be honored if you do :-)

Have fun, drink lots of Dew, and never forget THE answer: 42.
*/

#include <Debug.h>
#include "classSoundMaster.h"

#include <Sound.h>
#include <Roster.h>
#include <Directory.h>
#include <Application.h>
#include <Path.h>

#include <string.h>

// Set up the defaults.
classSoundMaster::classSoundMaster( bool soundson )
{
	AllSoundsOn = soundson;
	
	player = NULL;		// Created the first time someone try to play a sound, and
										// it is created in the classSound PlaySound() function.		
	app_info info;
	char thepath[500], temp[500];
	thepath[0] = '\0';
	status_t error;
	BDirectory soundsDirectory;
	
	for(unsigned int i = 0; i<MAX_SOUNDS;i++)
		sndList[i] = NULL;

	// get the app's info

	if ( be_app->GetAppInfo(&info) == B_OK ) {
		// get the path for this app
		BEntry entry( &info.ref );
		BDirectory dir;
		BPath path2;

		entry.GetParent( &dir );
		entry.SetTo( &dir, "./" );
		entry.GetPath( &path2 );
		strcpy( thepath, path2.Path() );
		
		// tack on the protocols folder
		strcat( thepath, "/Sounds" );
	}	

	error = soundsDirectory.SetTo( "/boot/home/config/sounds/Gim-ICQ" );

	if( error == B_ENTRY_NOT_FOUND ) {
		error = soundsDirectory.SetTo( thepath );
		if( error == B_ENTRY_NOT_FOUND ) {
			return;
		} else {
			strcat( thepath, "/" );
			strcpy( temp, thepath );
			strcat( temp, "GimLogon.wav" );
			AddSound( WS_LOGON, temp);
			strcpy( temp, thepath );
			strcat( temp, "GimLogoff.wav" );
			AddSound( WS_LOGOFF, temp);
			strcpy( temp, thepath );
			strcat( temp, "GimSend.wav" );
			AddSound( WS_MSGSEND, temp);
			strcpy( temp, thepath );
			strcat( temp, "GimReceive.wav" );
			AddSound( WS_MSGRECEIVE, temp );
			strcpy( temp, thepath );
			strcat( temp, "GimRibbit.wav" );
			AddSound( WS_RIBBIT, temp );
			strcpy( temp, thepath );
			strcat( temp, "GimNewMsg.wav" );
			AddSound( WS_NEWMSG, temp );
			strcpy( temp, thepath );
			strcat( temp, "GimNotify.wav" );
			AddSound( WS_TEMP1, temp);
			strcpy( temp, thepath );
			strcat( temp, "GimOffline.wav" );
			AddSound( WS_EXIT, temp);
			strcpy( temp, thepath );
			strcat( temp, "GimOnline.wav" );
			AddSound( WS_ENTER, temp);
		}
	} else {
		AddSound( WS_LOGON, "/boot/home/config/sounds/Gim-ICQ/GimLogon.wav");
		AddSound( WS_LOGOFF, "/boot/home/config/sounds/Gim-ICQ/GimLogoff.wav");
		AddSound( WS_MSGSEND, "/boot/home/config/sounds/Gim-ICQ/GimSend.wav" );
		AddSound( WS_MSGRECEIVE, "/boot/home/config/sounds/Gim-ICQ/GimReceive.wav");
		AddSound( WS_RIBBIT, "/boot/home/config/sounds/Gim-ICQ/GimRibbit.wav" );
		AddSound( WS_NEWMSG, "/boot/home/config/sounds/Gim-ICQ/GimNewMsg.wav" );
		AddSound( WS_TEMP1, "/boot/home/config/sounds/Gim-ICQ/GimNotify.wav" );
		AddSound( WS_EXIT, "/boot/home/config/sounds/Gim-ICQ/GimOffline.wav" );
		AddSound( WS_ENTER, "/boot/home/config/sounds/Gim-ICQ/GimOnline.wav");
	}
}

// Destroy the objects in the list.
classSoundMaster::~classSoundMaster( )
{
	for(unsigned int i = 0; i<MAX_SOUNDS;i++) 
		if(sndList[i] != NULL)
			delete sndList[i];
	delete player;
}

// Add the sound into the linked list and load the sound file into memory
void classSoundMaster::AddSound( int id, const char *path, bool enabled )
{

	DelSound( id );  // If in the list, delete the sound and re-add it.  (The path may have changed or something)

	sounds *sounds_item = new sounds();
	sounds_item -> sound = new classSound( path);
	sounds_item -> enabled = enabled;
	sounds_item -> id = id;
	//if(sounds_item.sound -> IsOK())
	sndList[id] = sounds_item;

}

// Trash the sound and free some mem and stuff
void classSoundMaster::DelSound( int id )
{

	for( unsigned int i = 0; i < MAX_SOUNDS; ++i ) {
		if(sndList[i] != NULL && sndList[i] -> id == id) {
			delete sndList[i];
			sndList[i] = NULL;
		}
	}
}

// Just plays the sound.  (Unless of course sounds are disabled)
void classSoundMaster::PlaySound( int id )
{
	sounds *sounds_item = NULL;
	if( (sounds_item = sndList[id]) == NULL )    // no sound?... get out.
		return;
		
	if(IsPlaying())    // someone is already playing?... get out.
		return;

	if( !sounds_item -> enabled || !AllSoundsOn) // not enabled?... get out.
		return;

	if(player == NULL) {		// Need to create a player.
		player = new BSoundPlayer(&(sounds_item -> sound -> fmt),"Gim-ICQ");
		player -> SetVolume(1.0);
		player -> Start();
	}

	sounds_item -> playing_id = sounds_item -> sound -> PlaySound(player);

	return;
}

// This one will set an individual sound enabled or disabled.
void classSoundMaster::SetEnabled( int id, bool enable )
{
	sounds *sounds_item;
	if( (sounds_item = sndList[id]) != NULL )
		sounds_item -> enabled = enable;	
}

// This one will enable or disable the entire set of sounds in this
// object.
void classSoundMaster::SetEnabled( bool enable )
{
	AllSoundsOn = enable;
}

// This one will return an individual sound's enabled or disabled status.
bool classSoundMaster::IsEnabled( int id )
{
	sounds *sounds_item;
	if( (sounds_item = sndList[id]) != NULL )
		return sounds_item -> enabled;
	else
		return false;  // Not found, just return false
}

// This one will return the entire object's enable or disable status
bool classSoundMaster::IsEnabled( )
{
	return AllSoundsOn;
}

// Just checks to see if the sound is playing.
bool classSoundMaster::IsPlaying( int id )
{
	if(player == NULL)    // if the player is null it cant be playing.
		return false;

	sounds *sounds_item;
	if( (sounds_item = sndList[id]) == NULL )
		return false;

	return player -> IsPlaying(sounds_item -> playing_id);
}

// Checks if any sound is playing.
bool classSoundMaster::IsPlaying() {
	
	if(player == NULL)    // if the player is null it cant be playing.
		return false;

	bool playing = FALSE;
	for( unsigned int i = 0; i < MAX_SOUNDS && !playing; ++i )
		playing = playing || IsPlaying(i);	

	return playing;
}
