#ifndef _ICQ_H_
#define _ICQ_H_

#include <Looper.h>
#include <Invoker.h>
#include <OS.h>
#include <Locker.h>

#include <sigc++/signal_system.h>
#include <libicq2000/constants.h>

#include "PList.h"

typedef unsigned long DWORD;
typedef unsigned short WORD;
typedef unsigned char BYTE;

#define ICQ_SEX_MALE	2
#define ICQ_SEX_FEMALE	1
#define ICQ_SEX_UNKNOWN	0

// Interface BMessages
const uint ICQ_SETUP = 'ICQs';
const uint ICQ_SET_UIN = 'UINs';
const uint ICQ_LOGIN = 'ICqL';
const uint ICQ_LOGOUT = 'IcQl';
const uint ICQ_STATUS_UPDATE = 'IcqS';
const uint ICQ_GRANT_AUTH = 'GntA';
const uint ICQ_UPDATE_INFO = 'UiFO';
const uint ICQ_UPDATE_EXTINFO = 'EiFo';
const uint ICQ_UPDATE_PASSWORD = 'Pass';
const uint ICQ_STOP_RECONNECTING = 'ICSr';

// ICQ object to Target-only BMessages
const uint ICQ_LOGGED_IN = 'LOGi';
const uint ICQ_LOGGED_OUT = 'LOGo';
const uint ICQ_USER_SEARCH_DONE = 'DonS';
const uint ICQ_USER_SEARCH_EXPIRED = 'ExpS';
const uint ICQ_CLIENT_INFO = 'InfC';
const uint ICQ_UPDATE_REPLY = 'StaU';
const uint ICQ_PASSWORD_REPLY = 'PasR';
const uint ICQ_EXTUPDATE_REPLY = 'EtaU';
const uint ICQ_OFFLINE_DONE = 'OfDn';
const uint ICQ_NO_INFO = 'NoNF';
const uint ICQ_BAD_PASSWORD = 'BADp';
const uint ICQ_LOGIN_ERROR = 'ErrL';
const uint ICQ_RECONNECTING = 'ICRe';

// Below are two way..  Use it when sending one, and is sent when recving one
const uint ICQ_TEXT_MESSAGE = 'iCQt';
const uint ICQ_URL_MESSAGE = 'ICQu';
const uint ICQ_USER_INFO = 'iUsr';
const uint ICQ_USER_EXTINFO = 'eUsr';
const uint ICQ_USER_STATUS = 'sUsr';
const uint ICQ_USER_ONLINE = 'Usr1';
const uint ICQ_USER_OFFLINE = 'Usr0';
const uint ICQ_UDP_DATA = 'UDPd';
const uint ICQ_AUTH_REQUEST = 'AUth';
const uint ICQ_ADD_CONTACT = 'ADdI';
const uint ICQ_USER_SEARCH = 'UsrS';
const uint ICQ_NEW_UIN = 'NEWi';

const uint ICQ_POLL	= 'IPLL';

struct SocketInfo {

	SocketInfo():mThreadId(0), mValue(0),mFd(-1) {}
	
	thread_id mThreadId;
	int mValue;
	int mFd;

};

namespace ICQ2000 {

	class Client;
	class Contact;
	class ConnectedEvent; 
	class DisconnectedEvent; 
	class LogEvent; 
	class SocketEvent; 
	class MessageEvent;
	class MessageEvent;
	class ContactListEvent;
	class UserInfoChangeEvent;
	class StatusChangeEvent;
	class SearchResultEvent;
};
using namespace ICQ2000;

class BMessegRunner;
class GManager;
class protoICQ : public BLooper, public BInvoker, public SigC::Object
{
public:
	protoICQ( GManager *the_manager );	// Constructor
	~protoICQ();

	virtual void Quit( void );
	virtual void MessageReceived( BMessage* );
	
	int32 Main( int aFd );

protected:
	
	void InitFunctions();
	void Logout( );

private:
		
	void sendInfo( Contact *aContact );
	void sendExtInfo( Contact *aContact );
	void sendClientInfo( Contact *aContact );

	// Ickle callbacks.
	void CBConnected( ConnectedEvent *cev ); 
	void CBDisconnected( DisconnectedEvent *dev ); 
	void CBLogger( LogEvent *lev ); 
	void CBSocket( SocketEvent *sev ); 
	void CBMessageack( MessageEvent *mev );
	void CBMessaged( MessageEvent *mev );
	void CBContactList( ContactListEvent *clev );
	void CBSelf( UserInfoChangeEvent *uice );
	void CBContactInfo( UserInfoChangeEvent *uice );
	void CBContactStatus( StatusChangeEvent *scev );
	void CBSearchResult( SearchResultEvent *srev );

	Client *mClient;
	volatile bool mIsRunning;

	BLocker mSocketLock;
	BLocker mMapLock;
	PList<SocketInfo> mSocketList;
	SearchResultEvent *mSREvent;
	BMessageRunner *mPoller;	
			
	GManager *mManager;

	
};

#endif

