#ifndef NV_3DA_H
#define NV_3DA_H

//#include "buffers.h"
#include "DriverInterface.h"
#include "nv_macros.h"
#include "nv_acc.h"

status_t get_clone_nr(void);
status_t init_3da(void);
status_t uninit_3da(void);
void *get_framebuffer(void);
void get_dm(display_mode *dm);
void nv_start_dma(void);
status_t nv_acc_fifofree_dma(uint16 cmd_size);
void nv_acc_cmd_dma(uint32 cmd, uint16 offset, uint16 size);
void nv_acc_set_ch_dma(uint16 ch, uint32 handle);
void nv_acc_assert_fifo_dma(void);
status_t nv_acc_wait_idle_dma(void);

/* support functions */
void nv_log(char *format, ...);

#define LOG(level_bit, args) do { \
	uint32 mod = (si->settings.logmask &  0xfffffff0) & MODULE_BIT; \
	uint32 lev = (si->settings.logmask & ~0xfffffff0) & level_bit; \
	if (mod && lev) nv_log args; \
} while (0)

#endif
