//-------------------------------------------------------------------------------
// Non polling tool tip class.
// Changed to TToolTip by CGSoftware 1.15.2000.
//  Major overhaul by Alan (CGSoftware) 7.31.2000
//-------------------------------------------------------------------------------
// Major portions of ShowTip() from Marco Nelissen's BubbleHelper class.


//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------

#ifndef TOOLTIP_H
#define TOOLTIP_H

#include <map>

class BView;
class BWindow;
class BLocker;

namespace DCL
{

class TTipFilter;

class TToolTip
{
	public:
	
	    void SetTip(BView *view, const char *text);
	    void EnableAll( bool Enable = true );
		void Enable( BView* Which, bool Enable = true );
		
	private:
	    TToolTip();
	    virtual ~TToolTip();

		void ShowTip(const BPoint& Where, const BString& Tip);
		void HideTip();
		void RemoveTip(const BView* Which);
	
	private:
		int32								FRunCount;
		bool								FEnabled;
		std::map<const BView*, TTipFilter*>	FFilterMap;
		BWindow*							FTipWindow;
		BLocker								FLock;

		friend 	class	TToolTipCleanup;
		friend	class	TTipFilter;
		friend			TToolTip& ToolTip();
};

extern TToolTip& ToolTip();

}	// namespace DCL



#endif


