#include <Message.h>
#include <Looper.h>
#include <BitmapStream.h>
#include <DataIO.h>
#include <TranslatorRoster.h>

#include <stdio.h>

#include "BitmapView.h"

BitmapView::BitmapView(BMessage* message) 
	: BView(message){

	fBitmap = NULL;
	
	BMessage bitmapMessage;
    // Is there are bitmap in this archive?
	if(message->FindMessage("bitmap", &bitmapMessage) == B_OK) {
		// Does it have anything in it?
		if(!bitmapMessage.IsEmpty()) {
			const void*	buf;
			ssize_t	bytes;
			
			// Get the data
			if(bitmapMessage.FindData("data", B_RAW_TYPE, 	&buf, &bytes)==B_OK) {
				BMemoryIO inBuf(buf, bytes);

				BTranslatorRoster *roster = BTranslatorRoster::Default();
				BBitmapStream stream;
				// Now turn the data into a BBitmap
				if (roster->Translate(&inBuf, NULL, NULL, &stream, B_TRANSLATOR_BITMAP, B_PNG_FORMAT) == B_OK)
					stream.DetachBitmap(&fBitmap); 
				
			}
			
		}
	}
}

BitmapView::BitmapView(BRect frame, const char* name, uint32 resizeMode, uint32 flags) 
	: BView(frame, name, resizeMode, flags) {
	fBitmap = NULL;
}

BitmapView::~BitmapView() {
	if(fBitmap)
		delete fBitmap;
}

// Without this function the automatic instantiation of a class using the BArchivable stuff doesn't work
BArchivable *BitmapView::Instantiate(BMessage *from) 
{
	if ( validate_instantiation(from, "BitmapView"))
		return new BitmapView(from);
	return NULL; 
}

status_t BitmapView::Archive(BMessage *archive, bool deep = true) const {
	status_t result = BView::Archive(archive, deep);
	
	if(result == B_OK) {
		BMessage* bitmapMessage = new BMessage();
		
		if(fBitmap) {
			BBitmap* temp_bitmap = NULL;
			BMallocIO buf;
			BTranslatorRoster *roster = BTranslatorRoster::Default();
			BBitmapStream stream(fBitmap); // init with contents of bitmap
			// Now send the bitmap to a in memory stream as a PNG file
			roster->Translate(&stream, NULL, NULL, (BPositionIO*)&buf, B_PNG_FORMAT);
			// Detatch the bitmap from the stream
			stream.DetachBitmap(&temp_bitmap);
			
			// Now add the data containing the PNG compresses bitmap to the archive message
			bitmapMessage->AddData("data", B_RAW_TYPE, buf.Buffer(), buf.BufferLength());
		}
			
		archive->AddMessage("bitmap", bitmapMessage);
	}
	
	return result;
}
	
void BitmapView::SetBitmap(BBitmap* aBitmap) {
	if(fBitmap)
		delete fBitmap;
		
	fBitmap = aBitmap;
	
	Looper()->Lock();
	Invalidate();
	Looper()->Unlock();
}

BBitmap* BitmapView::GetBitmap() {
	return fBitmap;
}
	
void BitmapView::Draw(BRect updateRect) {

	if(fBitmap)
		DrawBitmap(fBitmap, BPoint(0,0));
	else {
		BRect r = Bounds();
		StrokeRect(r, B_MIXED_COLORS);
	}
}
