#include <BitmapStream.h>
#include <Path.h>
#include <ClassInfo.h>

#include "BitmapViewEditor.h"
#include "inspector.h"

#include "Debug.h"

extern InspectorWindow* inspector;

BitmapEditor::BitmapEditor() {
DEBUGOUT("BitmapEditor::BitmapEditor()\n");

	openPanel = new BFilePanel(B_OPEN_PANEL);
	openPanel->SetTarget(this);
	
	bOK->SetMessage(new BMessage(CMD_OK));
	bCancel->SetMessage(new BMessage(CMD_CANCEL));
	bLoad->SetMessage(new BMessage(CMD_LOAD));
	bClear->SetMessage(new BMessage(CMD_CLEAR));
	
	SetDefaultButton(bOK);
	
	CenterWindow(this);
}

BitmapEditor::~BitmapEditor() {
DEBUGOUT("BitmapEditor::~BitmapEditor()\n");
	delete openPanel;
}

void BitmapEditor::Execute(CProperty* aProperty) {
	BBitmap* bm;
	property = aProperty;
	
	bm = ((BitmapView*)property->Handler())->GetBitmap();
	
	if(bm) {
		BMessage msg;
		bm->Archive(&msg);
	
		bitmap->SetBitmap(new BBitmap(&msg));
	}
	
	Show(); 
}

void BitmapEditor::MessageReceived(BMessage* message) {
	BitmapView* bmv = NULL;
	BMessage msg;
	BBitmap* src;
		
	switch(message->what) {
		case CMD_OK:
  			bmv = (BitmapView*)property->Handler();
			src = bitmap->GetBitmap();
			if(src) {
				src->Archive(&msg);
				
				bmv->SetBitmap(new BBitmap(&msg));
			} else {
				bmv->SetBitmap(NULL);			
			}
				
			if(inspector)
				inspector->RefreshProperties();
				
			Quit();
			break;
			
		case CMD_CANCEL:
			Quit();
			break;
			
			
		case CMD_CLEAR:
			bitmap->SetBitmap(NULL);
			break;
			
		case CMD_LOAD:
			openPanel->Show();
			break;
			
		case B_REFS_RECEIVED:
			HandleLoad(message);
			break;
			
		case B_KEY_DOWN:  // Check for the Escape key
			int32 key = 0;
			message->FindInt32("raw_char", &key);
			
			if(key==27) {
				Quit();
				break;
			}

			break;			
	}
	
	BWindow::MessageReceived(message);	
}

status_t BitmapEditor::HandleLoad(BMessage* message) {
	entry_ref 	ref;
	BPath		path;
	BEntry		entry;
	status_t	err = B_OK;
	
	if((err = message->FindRef("refs", &ref)) != B_OK)
		return err;
		
	if((err = entry.SetTo(&ref)) != B_OK)
		return err;
		
	entry.GetPath(&path);
	BFile file(path.Path(), B_READ_ONLY);
	BTranslatorRoster *roster = BTranslatorRoster::Default();
	BBitmapStream stream;
	BBitmap *result = NULL;
	if ((err = roster->Translate(&file, NULL, NULL, &stream, B_TRANSLATOR_BITMAP)) != B_OK)
		return err;
		
	stream.DetachBitmap(&result);
	
	bitmap->SetBitmap(result);
}

/* BitmapPropertyEditor */

CPropertyEditor* editor = RegisterPropertyEditor(new BitmapPropertyEditor());

bool BitmapPropertyEditor::CanHandle(BArchivable* object, char* name, int32 type) {
	return (strcmp(name,"bitmap")==0 && is_kind_of(object, BitmapView));
}

void BitmapPropertyEditor::GetAsString(BMessage* message, CProperty* property, char* buf, int bufSize) {
	if(((BitmapView*)property->Handler())->GetBitmap() == NULL) 
		strcpy(buf, "(Empty)");
	else
		strcpy(buf, "(Bitmap)");
}

void BitmapPropertyEditor::SetAsString(BMessage* message, CProperty* property, char* buf) {
}

void BitmapPropertyEditor::Edit(BMessage* message, CProperty* property, BView* view, BRect rect) {
	BitmapEditor* editor = new BitmapEditor();
	editor->Execute(property);
}
