#include <Bitmap.h>
#include <Message.h>
#include <FilePanel.h>
#include <File.h>
#include <TranslatorRoster.h>

#include "property.h"
#include "BitmapWindowBase.h"
#include "utils.h"

#define CMD_OK		'_OK_'
#define CMD_CANCEL	'CNCL'
#define CMD_LOAD	'LOAD'
#define CMD_CLEAR	'CLER'

class BitmapEditor : public BitmapWindowBase {
private:
	CProperty* 		property;
	BFilePanel*		openPanel;
	
	status_t		HandleLoad(BMessage* message);
public:
					BitmapEditor();
					~BitmapEditor();
			
	void			Execute(CProperty* aProperty);
	virtual void 	MessageReceived(BMessage* message);
};

class BitmapPropertyEditor : public CPropertyEditor {
protected:	
	virtual	bool CanHandle(BArchivable* object, char* name, int32 type);
	virtual void GetAsString(BMessage* message, CProperty* property, char* buf, int bufSize);
	virtual void SetAsString(BMessage* message, CProperty* property, char* buf);
public:
	virtual void Edit(BMessage* message, CProperty* property, BView* view, BRect rect);
};