#include <Window.h>
#include <ClassInfo.h>
#include <cstring>
#include <stdio.h>

#include "hintaddon.h"
#include "Info.h"

/* HintEnumerator */

static HintEnumerator* enumuerator = new HintEnumerator();

bool HintEnumerator::CanHandle(BArchivable* object) {
	return object && is_kind_of(object, BView);
}

void HintEnumerator::EnumerateProperties(BArchivable* object, BMessage* message) {
	BView* view = (BView*)object;
	
	CInfoNode* node = CInfoManager::FindInfo(view->Window());
	
	if(node) {
		char* value = NULL;
		
		node = node->Find("HINTS");
		
		if(node) {
			node = node->Find((char*)(view->Name()));
			
			if(node) {
				value = node->Value("TEXT");
			}
		}
		
		
		if(value) {
			message->AddString("Hint", value);
		} else {
			message->AddString("Hint", "");
		}
	}
}

/* HintPropertyEditor */

static CPropertyEditor* propEditor = RegisterPropertyEditor(new HintPropertyEditor());

bool HintPropertyEditor::CanHandle(BArchivable* object, char* name, int32 type) {
//	return object && is_kind_of(object, BView) && type==B_STRING_TYPE && strcmp("Hint", name)==0;
	return type==B_STRING_TYPE && strcmp("Hint", name)==0;
}

void HintPropertyEditor::GetAsString(BMessage* message, CProperty* property, char* buf, int bufSize) {
	BView* view = (BView*)(property->Handler());
	
	CInfoNode* node = CInfoManager::FindInfo(view->Window());
	
	if(node) {
		char* value = NULL;
		
		node = node->Find("HINTS");
		
		if(node) {
			node = node->Find((char*)(view->Name()));
			
			if(node) {
				value = node->Value("TEXT");
			}
		}
		
		
		if(value) {
			strcpy(buf, value);
		} else {
			buf[0] = '\0';
		}
	}
}

void HintPropertyEditor::SetAsString(BMessage* message, CProperty* property, char* buf) {
	BView* view = (BView*)(property->Handler());
	
	CInfoNode* form = CInfoManager::FindInfo(view->Window());
	
	if(form) {		
		CInfoNode* hints = form->Find("HINTS");
		if(!hints)
			hints =  new CInfoNode(form, "HINTS");
		
		CInfoNode* node = hints->Find((char*)(view->Name()));
		
		if(!node && buf && *buf) 
			node = new CInfoNode(hints, (char*)(view->Name()));
				
		if(node) {
			if(buf && *buf)
				node->SetValue("TEXT", buf);
			else
				delete node;
		}
	}
}

/* HintCodeGenerator */

static HintCodeGenerator* codeGenerator = new HintCodeGenerator();

void HintCodeGenerator::AfterIncludes(BWindow* form, FILE* file) {

	CInfoNode* node = CInfoManager::FindInfo(form);
	
	if(node) {
		node = node->Find("HINTS");
		
		// Are there any hints on this form?
		if(node && node->HasChildren()) {
			fprintf(file, "#include \"ToolTip.h\"\n");
		}
	}
}

void HintCodeGenerator::AfterConstructorItem(BWindow* form, BArchivable* item, FILE* file) {
	BView* view = (BView*)(item);
	
	CInfoNode* node = CInfoManager::FindInfo(view->Window());
	
	if(node) {
		char* value = NULL;
		
		node = node->Find("HINTS");
		
		if(node) {
			node = node->Find((char*)(view->Name()));
			
			if(node) {
				value = node->Value("TEXT");
			}
		}
		
		
		if(value) 
			fprintf(file, "\tDCL::ToolTip().SetTip(%s,\"%s\");\n", view->Name(), value);
	}
}

/* HintListener */

static HintListener* hitListener = new HintListener();

void HintListener::Renamed(BArchivable* comp, char* oldName, char* newName) {
	BView* view = (BView*)comp;
		
	CInfoNode* node = CInfoManager::FindInfo(view->Window());
	
	if(node) {
		node = node->Find("HINTS");
		
		if(node) {
			node = node->Find(oldName);
			
			if(node) {
				node->SetName(newName);
			}
		}
	}
}

void HintListener::Added(BArchivable* comp) {
	// Do nothing because we don't care
}

void HintListener::Deleted(BArchivable* comp) {
	BView* view = (BView*)comp;
		
	CInfoNode* node = CInfoManager::FindInfo(view->Window());
	
	if(node) {
		node = node->Find("HINTS");
		
		if(node) {
			node = node->Find((char*)view->Name());
			
			// Is there a hint node associated with this component?		
			if(node) {
				delete node; // Yep, frag it!
			}
		}
	}
}


