#include "property.h"
#include "PropertyEnumerator.h"
#include "CodeGenerator.h"
#include "ComponentListener.h"

#ifndef _HINT_ADDON_H_
#define _HINT_ADDON_H_

class HintEnumerator : public PropertyEnumerator {
public:
	virtual	bool	CanHandle(BArchivable* object);
	virtual	void	EnumerateProperties(BArchivable* object, BMessage* message);
};

class HintPropertyEditor : public CStringEditor {
public:
	virtual bool CanHandle(BArchivable* object, char* name, int32 type);
	virtual void GetAsString(BMessage* message, CProperty* property, char* buf, int bufSize);
	virtual void SetAsString(BMessage* message, CProperty* property, char* buf);
};

class HintCodeGenerator : public CodeGenerationPlugin {
public:
	virtual void 	AfterIncludes(BWindow* form, FILE* file);
	virtual void 	AfterConstructorItem(BWindow* form, BArchivable* item, FILE* file);
};

class HintListener : public ComponentListener {
public:
	virtual void Renamed(BArchivable* comp, char* oldName, char* newName);
	virtual void Added(BArchivable* comp);
	virtual void Deleted(BArchivable* comp);
};

#endif